/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.HotSwapCompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;

public final class Es6SplitVariableDeclarations
extends NodeTraversal.AbstractPostOrderCallback
implements HotSwapCompilerPass {
    private final AbstractCompiler compiler;

    public Es6SplitVariableDeclarations(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverseEs6(this.compiler, externs, this);
        NodeTraversal.traverseEs6(this.compiler, root, this);
    }

    @Override
    public void hotSwapScript(Node scriptRoot, Node originalRoot) {
        NodeTraversal.traverseEs6(this.compiler, scriptRoot, this);
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        if (NodeUtil.isDestructuringDeclaration(n)) {
            this.splitDeclaration(n, parent);
        }
    }

    public void splitDeclaration(Node n, Node parent) {
        while (n.getFirstChild() != n.getLastChild()) {
            Node child = n.getLastChild().detachFromParent();
            Node newVar = IR.declaration(child, n.getType()).srcref(n);
            parent.addChildAfter(newVar, n);
            this.compiler.reportCodeChange();
        }
    }
}

