/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.apache.trinidad.tagsupport.converter.operations;

import java.util.List;
import org.eclipse.jst.jsf.apache.trinidad.tagsupport.ITrinidadConstants;
import org.eclipse.jst.jsf.apache.trinidad.tagsupport.converter.operations.AbstractTrinidadTransformOperation;
import org.eclipse.jst.jsf.common.dom.TagIdentifier;
import org.eclipse.jst.jsf.core.internal.tld.TagIdentifierFactory;
import org.eclipse.jst.pagedesigner.converter.ConvertPosition;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class PanelFormLayoutOperation
extends AbstractTrinidadTransformOperation {
    private static final String STYLECLASS_REQUIREDSPAN = "AFRequiredIconStyle";
    private static final String STYLECLASS_GROUPSEPARATOR = "af_panelFormLayout_separator";
    private static final String STYLECLASS_LABELCELL = "af_inputText_label af_panelFormLayout_label-cell";
    private static final String STYLECLASS_FIELDCELL = "af_panelFormLayout_content-cell";

    public Element transform(Element srcElement, Element curElement) {
        List<Element> footerChildElements;
        String inlineStyle;
        int columnCount = this.calculateColumnCount(srcElement);
        int rowCount = this.calculateRowCount(srcElement);
        String fieldWidth = this.calculateFieldWidth(srcElement);
        String labelWidth = this.calculateLabelWidth(srcElement);
        int currentColumn = 1;
        int currentRow = 1;
        Element outerTableElement = this.createElement("table");
        String styleClass = srcElement.getAttribute("styleClass");
        if (styleClass != null && styleClass.length() > 0) {
            this.appendAttribute(outerTableElement, "class", styleClass);
        }
        if ((inlineStyle = srcElement.getAttribute("inlineStyle")) != null && inlineStyle.length() > 0) {
            this.appendAttribute(outerTableElement, "style", String.valueOf(inlineStyle) + ";width:100%;");
        } else {
            this.appendAttribute(outerTableElement, "style", "width:100%;");
        }
        this.appendAttribute(outerTableElement, "cellpadding", "0");
        this.appendAttribute(outerTableElement, "cellspacing", "0");
        this.appendAttribute(outerTableElement, "border", "0");
        Element outerTBodyElement = this.appendChildElement("tbody", outerTableElement);
        Element outerTopTRElement = this.appendChildElement("tr", outerTBodyElement);
        Element currentTBodyElement = this.buildColumnStart(outerTopTRElement, columnCount, currentColumn, labelWidth, fieldWidth);
        List<Element> childElements = this.getChildElementsSkipFacets(srcElement);
        for (Element childElement : childElements) {
            if (ITrinidadConstants.TAG_IDENTIFIER_GROUP.isSameTagType(TagIdentifierFactory.createDocumentTagWrapper((Element)childElement))) {
                if (currentRow > 1) {
                    this.buildGroupSeparatorRow(currentTBodyElement);
                }
                List<Element> groupChildElements = this.getChildElementsSkipFacets(childElement);
                for (Element groupChildElement : groupChildElements) {
                    this.buildControlRow(groupChildElement, currentTBodyElement);
                }
                if ((currentRow += groupChildElements.size()) <= rowCount) {
                    this.buildGroupSeparatorRow(currentTBodyElement);
                }
                if (currentRow <= rowCount || currentColumn >= columnCount) continue;
                currentRow = 1;
                currentTBodyElement = this.buildColumnStart(outerTopTRElement, columnCount, ++currentColumn, labelWidth, fieldWidth);
                continue;
            }
            this.buildControlRow(childElement, currentTBodyElement);
            if (++currentRow <= rowCount || currentColumn >= columnCount) continue;
            currentRow = 1;
            currentTBodyElement = this.buildColumnStart(outerTopTRElement, columnCount, ++currentColumn, labelWidth, fieldWidth);
        }
        Element footerElement = this.getChildFacetByName(srcElement, "footer");
        if (footerElement != null && (footerChildElements = this.getChildElementsSkipFacets(footerElement)).size() > 0) {
            Element outerBottomTRElement = this.appendChildElement("tr", outerTBodyElement);
            currentTBodyElement = this.buildFooterStart(outerBottomTRElement, columnCount, labelWidth);
            rowCount = this.countChildElements(footerElement);
            currentRow = 1;
            for (Element footerChildElement : footerChildElements) {
                if (ITrinidadConstants.TAG_IDENTIFIER_GROUP.isSameTagType(TagIdentifierFactory.createDocumentTagWrapper((Element)footerChildElement))) {
                    if (currentRow > 1) {
                        this.buildGroupSeparatorRow(currentTBodyElement);
                    }
                    List<Element> groupFooterChildElements = this.getChildElementsSkipFacets(footerChildElement);
                    for (Element groupFooterChildElement : groupFooterChildElements) {
                        if (ITrinidadConstants.TAG_IDENTIFIER_GROUP.isSameTagType(TagIdentifierFactory.createDocumentTagWrapper((Element)groupFooterChildElement))) {
                            if (currentRow > 1) {
                                this.buildGroupSeparatorRow(currentTBodyElement);
                            }
                            List<Element> subGroupFooterChildElements = this.getChildElementsSkipFacets(groupFooterChildElement);
                            for (Element subGroupFooterChildElement : subGroupFooterChildElements) {
                                this.buildControlRow(subGroupFooterChildElement, currentTBodyElement, true);
                                ++currentRow;
                            }
                            if (currentRow > rowCount) continue;
                            this.buildGroupSeparatorRow(currentTBodyElement);
                            continue;
                        }
                        this.buildControlRow(groupFooterChildElement, currentTBodyElement, true);
                        ++currentRow;
                    }
                    if (currentRow > rowCount) continue;
                    this.buildGroupSeparatorRow(currentTBodyElement);
                    continue;
                }
                this.buildControlRow(footerChildElement, currentTBodyElement, true);
                ++currentRow;
            }
        }
        return outerTableElement;
    }

    private int calculateRowCount(Element srcElement) {
        int rowCount = Integer.MAX_VALUE;
        int specifiedRows = Integer.MAX_VALUE;
        String rows = srcElement.getAttribute("rows");
        if (rows != null && rows.length() > 0) {
            try {
                specifiedRows = Math.max(5, Integer.parseInt(rows));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        int specifiedMaxColumns = Integer.MAX_VALUE;
        String maxColumns = srcElement.getAttribute("maxColumns");
        if (maxColumns != null && maxColumns.length() > 0) {
            try {
                specifiedMaxColumns = Integer.parseInt(maxColumns);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        int childElementCount = this.countChildElements(srcElement);
        int calculatedColumns = childElementCount / specifiedRows;
        if (childElementCount % specifiedRows > 0) {
            ++calculatedColumns;
        }
        rowCount = calculatedColumns > specifiedMaxColumns ? childElementCount / specifiedMaxColumns : specifiedRows;
        return rowCount;
    }

    private int calculateColumnCount(Element srcElement) {
        int columnCount = Integer.MAX_VALUE;
        int specifiedRows = Integer.MAX_VALUE;
        String rows = srcElement.getAttribute("rows");
        if (rows != null && rows.length() > 0) {
            try {
                specifiedRows = Math.max(5, Integer.parseInt(rows));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        int specifiedMaxColumns = Integer.MAX_VALUE;
        String maxColumns = srcElement.getAttribute("maxColumns");
        if (maxColumns != null && maxColumns.length() > 0) {
            try {
                specifiedMaxColumns = Integer.parseInt(maxColumns);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        int childElementCount = this.countChildElements(srcElement);
        int calculatedColumns = childElementCount / specifiedRows;
        if (childElementCount % specifiedRows > 0) {
            ++calculatedColumns;
        }
        columnCount = Math.min(specifiedMaxColumns, calculatedColumns);
        return columnCount;
    }

    private int countChildElements(Element srcElement) {
        int count = 0;
        List<Element> childElements = this.getChildElementsSkipFacets(srcElement);
        for (Element childElement : childElements) {
            if (ITrinidadConstants.TAG_IDENTIFIER_GROUP.isSameTagType(TagIdentifierFactory.createDocumentTagWrapper((Element)childElement))) {
                count += this.countChildElements(childElement);
                continue;
            }
            ++count;
        }
        return count;
    }

    private String calculateFieldWidth(Element srcElement) {
        String width = null;
        String fieldWidth = srcElement.getAttribute("fieldWidth");
        if (fieldWidth != null && fieldWidth.length() > 0) {
            width = fieldWidth;
        } else {
            String labelWidth = srcElement.getAttribute("labelWidth");
            if (labelWidth != null && labelWidth.length() > 1 && labelWidth.endsWith("%")) {
                try {
                    int iLabelWidth = Integer.parseInt(labelWidth.substring(0, labelWidth.length() - 1));
                    if (iLabelWidth <= 100) {
                        width = String.valueOf(String.valueOf(100 - iLabelWidth)) + "%";
                    }
                }
                catch (NumberFormatException numberFormatException) {}
            }
        }
        return width;
    }

    private String calculateLabelWidth(Element srcElement) {
        String width = null;
        String labelWidth = srcElement.getAttribute("labelWidth");
        if (labelWidth != null && labelWidth.length() > 0) {
            width = labelWidth;
        } else {
            String fieldWidth = srcElement.getAttribute("fieldWidth");
            if (fieldWidth != null && fieldWidth.length() > 1 && fieldWidth.endsWith("%")) {
                try {
                    int iFieldWidth = Integer.parseInt(fieldWidth.substring(0, fieldWidth.length() - 1));
                    if (iFieldWidth <= 100) {
                        width = String.valueOf(String.valueOf(100 - iFieldWidth)) + "%";
                    }
                }
                catch (NumberFormatException numberFormatException) {}
            }
        }
        return width;
    }

    private Element buildColumnStart(Element parentElement, int columnCount, int currentColumn, String labelWidth, String fieldWidth) {
        Element tdElement = this.appendChildElement("td", parentElement);
        this.appendAttribute(tdElement, "style", "vertical-align:top;");
        if (currentColumn < columnCount) {
            String width = String.valueOf(String.valueOf(100 / columnCount)) + "%";
            this.appendAttribute(tdElement, "width", width);
        }
        Element tableElement = this.appendChildElement("table", tdElement);
        this.appendAttribute(tableElement, "cellpadding", "0");
        this.appendAttribute(tableElement, "cellspacing", "0");
        this.appendAttribute(tableElement, "border", "0");
        this.appendAttribute(tableElement, "width", "100%");
        Element tBodyElement = this.appendChildElement("tbody", tableElement);
        Element trElement = this.appendChildElement("tr", tBodyElement);
        Element tdLabelElement = this.appendChildElement("td", trElement);
        if (labelWidth != null && labelWidth.length() > 0) {
            this.appendAttribute(tdLabelElement, "style", "width:" + labelWidth);
        }
        Element tdFieldElement = this.appendChildElement("td", trElement);
        if (fieldWidth != null && fieldWidth.length() > 0) {
            this.appendAttribute(tdFieldElement, "style", "width:" + fieldWidth);
        }
        return tBodyElement;
    }

    private void buildControlRow(Element srcElement, Element parentElement, boolean alignLabelsTop) {
        Element trElement = this.appendChildElement("tr", parentElement);
        Element tdLabelElement = this.appendChildElement("td", trElement);
        this.appendAttribute(tdLabelElement, "class", STYLECLASS_LABELCELL);
        if (alignLabelsTop) {
            this.appendAttribute(tdLabelElement, "valign", "top");
        }
        this.appendAttribute(tdLabelElement, "nowrap", "");
        this.buildLabel(srcElement, tdLabelElement);
        Element tdFieldElement = this.appendChildElement("td", trElement);
        this.appendAttribute(tdFieldElement, "class", STYLECLASS_FIELDCELL);
        this.appendAttribute(tdFieldElement, "valign", "top");
        this.appendAttribute(tdFieldElement, "nowrap", "");
        this.tagConverterContext.addChild((Node)srcElement, new ConvertPosition((Node)tdFieldElement, 0));
    }

    private void buildControlRow(Element srcElement, Element parentElement) {
        this.buildControlRow(srcElement, parentElement, false);
    }

    private void buildLabel(Element srcElement, Element parentElement) {
        TagIdentifier tagID = TagIdentifierFactory.createDocumentTagWrapper((Element)srcElement);
        if (tagID.isSameTagType(ITrinidadConstants.TAG_IDENTIFIER_INPUTCOLOR) || tagID.isSameTagType(ITrinidadConstants.TAG_IDENTIFIER_INPUTDATE) || tagID.isSameTagType(ITrinidadConstants.TAG_IDENTIFIER_INPUTFILE) || tagID.isSameTagType(ITrinidadConstants.TAG_IDENTIFIER_INPUTLISTOFVALUES) || tagID.isSameTagType(ITrinidadConstants.TAG_IDENTIFIER_INPUTNUMBERSPINBOX) || tagID.isSameTagType(ITrinidadConstants.TAG_IDENTIFIER_INPUTTEXT) || tagID.isSameTagType(ITrinidadConstants.TAG_IDENTIFIER_SELECTBOOLEANCHECKBOX) || tagID.isSameTagType(ITrinidadConstants.TAG_IDENTIFIER_SELECTBOOLEANRADIO) || tagID.isSameTagType(ITrinidadConstants.TAG_IDENTIFIER_SELECTMANYCHECKBOX) || tagID.isSameTagType(ITrinidadConstants.TAG_IDENTIFIER_SELECTMANYLISTBOX) || tagID.isSameTagType(ITrinidadConstants.TAG_IDENTIFIER_SELECTONECHOICE) || tagID.isSameTagType(ITrinidadConstants.TAG_IDENTIFIER_SELECTONELISTBOX) || tagID.isSameTagType(ITrinidadConstants.TAG_IDENTIFIER_SELECTONERADIO) || tagID.isSameTagType(ITrinidadConstants.TAG_IDENTIFIER_PANELLABELANDMESSAGE)) {
            String label;
            String required = srcElement.getAttribute("required");
            String showRequired = srcElement.getAttribute("showRequired");
            if (Boolean.parseBoolean(required) || Boolean.parseBoolean(showRequired)) {
                Element spanElement = this.appendChildElement("span", parentElement);
                this.appendAttribute(spanElement, "title", "Required");
                this.appendAttribute(spanElement, "class", STYLECLASS_REQUIREDSPAN);
                this.appendChildText("* ", spanElement);
            }
            if ((label = srcElement.getAttribute("labelAndAccessKey")) == null || label.length() < 1) {
                label = srcElement.getAttribute("label");
            }
            if (label != null && label.length() > 0) {
                Element labelElement = this.appendChildElement("label", parentElement);
                this.appendChildText(label, labelElement);
            }
        }
    }

    private void buildGroupSeparatorRow(Element parentElement) {
        Element trElement = this.appendChildElement("tr", parentElement);
        Element tdElement = this.appendChildElement("td", trElement);
        this.appendAttribute(tdElement, "colspan", "2");
        Element divElement = this.appendChildElement("div", tdElement);
        this.appendAttribute(divElement, "class", STYLECLASS_GROUPSEPARATOR);
    }

    private Element buildFooterStart(Element parentElement, int columnCount, String labelWidth) {
        Element tdElement = this.appendChildElement("td", parentElement);
        this.appendAttribute(tdElement, "style", "vertical-align:top;");
        this.appendAttribute(tdElement, "colspan", String.valueOf(columnCount));
        Element tableElement = this.appendChildElement("table", tdElement);
        this.appendAttribute(tableElement, "cellpadding", "0");
        this.appendAttribute(tableElement, "cellspacing", "0");
        this.appendAttribute(tableElement, "border", "0");
        this.appendAttribute(tableElement, "width", "100%");
        Element tBodyElement = this.appendChildElement("tbody", tableElement);
        Element trElement = this.appendChildElement("tr", tBodyElement);
        String footerLabelWidth = null;
        String footerFieldWidth = null;
        if (labelWidth != null && labelWidth.length() > 0) {
            if (labelWidth.endsWith("%")) {
                try {
                    int iLabelWidth = Integer.parseInt(labelWidth.substring(0, labelWidth.length() - 1));
                    footerLabelWidth = String.valueOf(String.valueOf(iLabelWidth /= columnCount)) + "%";
                    footerFieldWidth = String.valueOf(String.valueOf(100 - iLabelWidth)) + "%";
                }
                catch (NumberFormatException numberFormatException) {}
            } else {
                footerLabelWidth = labelWidth;
            }
        }
        Element tdLabelElement = this.appendChildElement("td", trElement);
        if (footerLabelWidth != null && footerLabelWidth.length() > 0) {
            this.appendAttribute(tdLabelElement, "width", footerLabelWidth);
        }
        Element tdFieldElement = this.appendChildElement("td", trElement);
        if (footerFieldWidth != null && footerFieldWidth.length() > 0) {
            this.appendAttribute(tdFieldElement, "width", footerFieldWidth);
        }
        return tBodyElement;
    }
}

