/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.context.symbol.tests;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jst.jsf.context.symbol.IBeanInstanceSymbol;
import org.eclipse.jst.jsf.context.symbol.IBeanMethodSymbol;
import org.eclipse.jst.jsf.context.symbol.IBeanPropertySymbol;
import org.eclipse.jst.jsf.context.symbol.IJavaTypeDescriptor2;
import org.eclipse.jst.jsf.context.symbol.IObjectSymbol;
import org.eclipse.jst.jsf.context.symbol.IPropertySymbol;
import org.eclipse.jst.jsf.context.symbol.ITypeDescriptor;
import org.eclipse.jst.jsf.context.symbol.SymbolFactory;
import org.eclipse.jst.jsf.context.symbol.SymbolPackage;
import org.eclipse.jst.jsf.context.symbol.tests.ContextSymbolTestPlugin;
import org.eclipse.jst.jsf.context.symbol.tests.ModelBaseTestCase;
import org.eclipse.jst.jsf.core.tests.TestsPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestIJavaTypeDescriptor2
extends ModelBaseTestCase {
    private Map _beanProperties;
    private Map _beanSubclassProperties;
    private Map<String, IBeanMethodSymbol> _beanMethods;
    private Map _beanMethodsSubclass;
    private Map<String, IPropertySymbol> _genericProperties;
    private IBeanInstanceSymbol _testBean1Symbol;
    private IBeanInstanceSymbol _testBean1SubclassSymbol;
    private IBeanInstanceSymbol _testBean2Symbol;
    private IBeanInstanceSymbol _testBean2SubclassSymbol;
    private static final String packageName1 = "com.test";
    private static final String testBeanName1 = "TestBean1";
    private static final String testBean1Sig = "Lcom.test.TestBean1;";
    private static final String testBeanSubclass1 = "TestBean1Subclass";
    private static final String testBeanName2 = "TestBean2";
    private static final String testBean2Subclass = "TestBean2Subclass";
    private static final String overloadedMethodName = "overloadedMethod";

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.loadSourceClass(ContextSymbolTestPlugin.getDefault().getBundle(), "/testdata/ITestBean2.java.data", packageName1, "ITestBean2");
        this.loadSourceClass(TestsPlugin.getDefault().getBundle(), "/testfiles/AnotherBean.java.data", packageName1, "AnotherBean");
        TestIJavaTypeDescriptor2.assertNotNull((Object)this._jdtTestEnvironment.getJavaProject().findType("com.test.AnotherBean"));
        this._beanProperties = new HashMap();
        this._testBean1Symbol = this.setupBeanProperty(TestsPlugin.getDefault().getBundle(), "/testfiles/TestBean1.java.data", packageName1, testBeanName1, this._beanProperties);
        this._beanSubclassProperties = new HashMap();
        this._testBean1SubclassSymbol = this.setupBeanProperty(TestsPlugin.getDefault().getBundle(), "/testfiles/TestBean1Subclass.java.data", packageName1, testBeanSubclass1, this._beanSubclassProperties);
        this._genericProperties = new HashMap<String, IPropertySymbol>();
        this.setupBeanProperty(ContextSymbolTestPlugin.getDefault().getBundle(), "/testdata/TestBeanWithGenericProperties.java.data", packageName1, "TestBeanWithGenericProperties", this._genericProperties);
        this._beanMethods = new HashMap<String, IBeanMethodSymbol>();
        this._testBean2Symbol = this.setupBeanMethods("/testdata/TestBean2.java.data", testBeanName2, this._beanMethods);
        this._beanMethodsSubclass = new HashMap();
        this._testBean2SubclassSymbol = this.setupBeanMethods("/testdata/TestBean2Subclass.java.data", testBean2Subclass, this._beanMethodsSubclass);
    }

    private IBeanInstanceSymbol setupBeanMethods(String fileName, String beanClassName, Map<String, IBeanMethodSymbol> methods) throws Exception {
        this.loadSourceClass(ContextSymbolTestPlugin.getDefault().getBundle(), fileName, packageName1, beanClassName);
        IType testBean1Type = this._jdtTestEnvironment.getJavaProject().findType("com.test." + beanClassName);
        TestIJavaTypeDescriptor2.assertNotNull((Object)testBean1Type);
        IJavaTypeDescriptor2 testBeanDescriptor = SymbolFactory.eINSTANCE.createIJavaTypeDescriptor2();
        testBeanDescriptor.setType(testBean1Type);
        IBeanInstanceSymbol bean = SymbolFactory.eINSTANCE.createIBeanInstanceSymbol();
        bean.setTypeDescriptor((ITypeDescriptor)testBeanDescriptor);
        bean.setName(beanClassName);
        EList methodList = bean.getMethods();
        for (IBeanMethodSymbol method : methodList) {
            if (overloadedMethodName.equals(method.getName())) continue;
            methods.put(method.getName(), method);
        }
        return bean;
    }

    public void testMapSanity() {
        TestIJavaTypeDescriptor2.assertEquals((String)"Check extra or missing properties", (int)15, (int)this._beanProperties.size());
        TestIJavaTypeDescriptor2.assertEquals((String)"Check extra or missing properties", (int)16, (int)this._beanSubclassProperties.size());
        TestIJavaTypeDescriptor2.assertEquals((String)"Check extra or missing methods", (int)12, (int)this._beanMethods.size());
        TestIJavaTypeDescriptor2.assertEquals((String)"Check extra or missing methods", (int)13, (int)this._beanMethodsSubclass.size());
        TestIJavaTypeDescriptor2.assertEquals((String)"Check extra or missing methods", (int)5, (int)this._genericProperties.size());
    }

    public void testStringProp1() {
        this.testStringProp1(this._beanProperties);
    }

    public void testStringProp1SubClass() {
        this.testStringProp1(this._beanSubclassProperties);
    }

    private void testStringProp1(Map properties) {
        IBeanPropertySymbol property = (IBeanPropertySymbol)properties.get("stringProp1");
        TestIJavaTypeDescriptor2.assertNotNull((Object)property);
        TestIJavaTypeDescriptor2.assertTrue((boolean)property.isReadable());
        TestIJavaTypeDescriptor2.assertTrue((boolean)property.isWritable());
        TestIJavaTypeDescriptor2.assertEquals((String)"Signature must be for a String", (String)"Ljava.lang.String;", (String)property.getTypeDescriptor().getTypeSignature());
    }

    public void testBooleanIsProp1() {
        this.testBooleanIsProp1(this._beanProperties);
    }

    public void testBooleanIsProp1SubClass() {
        this.testBooleanIsProp1(this._beanSubclassProperties);
    }

    private void testBooleanIsProp1(Map properties) {
        IBeanPropertySymbol property = (IBeanPropertySymbol)properties.get("booleanIsProp1");
        TestIJavaTypeDescriptor2.assertNotNull((Object)property);
        TestIJavaTypeDescriptor2.assertTrue((boolean)property.isReadable());
        TestIJavaTypeDescriptor2.assertTrue((boolean)property.isWritable());
        TestIJavaTypeDescriptor2.assertEquals((String)"Signature must be for a boolean", (String)"Z", (String)property.getTypeDescriptor().getTypeSignature());
    }

    public void testBooleanIsProp2() {
        this.testBooleanIsProp2(this._beanProperties);
    }

    public void testBooleanIsProp2SubClass() {
        this.testBooleanIsProp2(this._beanSubclassProperties);
    }

    private void testBooleanIsProp2(Map properties) {
        IBeanPropertySymbol property = (IBeanPropertySymbol)properties.get("booleanIsProp2");
        TestIJavaTypeDescriptor2.assertNotNull((Object)property);
        TestIJavaTypeDescriptor2.assertTrue((boolean)property.isReadable());
        TestIJavaTypeDescriptor2.assertTrue((boolean)property.isWritable());
        TestIJavaTypeDescriptor2.assertEquals((String)"Signature must be for a boolean", (String)"Z", (String)property.getTypeDescriptor().getTypeSignature());
    }

    public void testNotBooleanIsProp1() {
        this.testNotBooleanIsProp1(this._beanProperties);
    }

    public void testNotBooleanIsProp1SubClass() {
        this.testNotBooleanIsProp1(this._beanSubclassProperties);
    }

    private void testNotBooleanIsProp1(Map properties) {
        IBeanPropertySymbol property = (IBeanPropertySymbol)properties.get("notBooleanIsProp1");
        TestIJavaTypeDescriptor2.assertNotNull((Object)property);
        TestIJavaTypeDescriptor2.assertTrue((boolean)property.isReadable());
        TestIJavaTypeDescriptor2.assertTrue((boolean)property.isWritable());
        TestIJavaTypeDescriptor2.assertEquals((String)"Signature must be for a boolean", (String)"Z", (String)property.getTypeDescriptor().getTypeSignature());
    }

    public void testStringProperty2() {
        this.testStringProperty2(this._beanProperties);
    }

    public void testStringProperty2SubClass() {
        this.testStringProperty2(this._beanSubclassProperties);
    }

    private void testStringProperty2(Map properties) {
        IBeanPropertySymbol property = (IBeanPropertySymbol)properties.get("stringProperty2");
        TestIJavaTypeDescriptor2.assertNotNull((Object)property);
        TestIJavaTypeDescriptor2.assertTrue((boolean)property.isReadable());
        TestIJavaTypeDescriptor2.assertFalse((String)"No setter for this property", (boolean)property.isWritable());
        TestIJavaTypeDescriptor2.assertEquals((String)"Signature must be for a String", (String)"Ljava.lang.String;", (String)property.getTypeDescriptor().getTypeSignature());
    }

    public void testReadonlyStringProperty() {
        this.testReadonlyStringProperty(this._beanProperties);
    }

    private void testReadonlyStringProperty(Map properties) {
        IBeanPropertySymbol property = (IBeanPropertySymbol)properties.get("readonlyStringProperty");
        TestIJavaTypeDescriptor2.assertNotNull((Object)property);
        TestIJavaTypeDescriptor2.assertTrue((boolean)property.isReadable());
        TestIJavaTypeDescriptor2.assertFalse((String)"No setter for this property", (boolean)property.isWritable());
        TestIJavaTypeDescriptor2.assertEquals((String)"Signature must be for a String", (String)"Ljava.lang.String;", (String)property.getTypeDescriptor().getTypeSignature());
    }

    public void testReadonlyBooleanProperty() {
        this.testReadonlyBooleanProperty(this._beanProperties);
    }

    public void testReadonlyBooleanPropertySubClass() {
        this.testReadonlyBooleanProperty(this._beanSubclassProperties);
    }

    public void testReadonlyStringPropertySubClass() {
        this.testReadonlyStringProperty(this._beanSubclassProperties);
    }

    private void testReadonlyBooleanProperty(Map properties) {
        IBeanPropertySymbol property = (IBeanPropertySymbol)properties.get("readonlyBooleanProperty");
        TestIJavaTypeDescriptor2.assertNotNull((Object)property);
        TestIJavaTypeDescriptor2.assertTrue((boolean)property.isReadable());
        TestIJavaTypeDescriptor2.assertFalse((String)"No setter for this property", (boolean)property.isWritable());
        TestIJavaTypeDescriptor2.assertEquals((String)"Signature must be for a boolean", (String)"Z", (String)property.getTypeDescriptor().getTypeSignature());
    }

    public void testStringArrayProperty() {
        this.testStringArrayProperty(this._beanProperties);
    }

    public void testStringArrayPropertySubClass() {
        this.testStringArrayProperty(this._beanSubclassProperties);
    }

    private void testStringArrayProperty(Map properties) {
        IBeanPropertySymbol property = (IBeanPropertySymbol)properties.get("stringArrayProperty");
        TestIJavaTypeDescriptor2.assertNotNull((Object)property);
        TestIJavaTypeDescriptor2.assertTrue((boolean)property.isReadable());
        TestIJavaTypeDescriptor2.assertTrue((boolean)property.isWritable());
        ITypeDescriptor typeDesc = property.getTypeDescriptor();
        TestIJavaTypeDescriptor2.assertEquals((String)"Signature must be for a String[]", (String)Signature.createArraySignature((String)"Ljava.lang.String;", (int)1), (String)typeDesc.getTypeSignature());
        TestIJavaTypeDescriptor2.assertEquals((boolean)true, (boolean)typeDesc.isArray());
        TestIJavaTypeDescriptor2.assertEquals((int)1, (int)((IJavaTypeDescriptor2)typeDesc).getArrayCount());
    }

    public void testIntArrayProperty() {
        this.testIntArrayProperty(this._beanProperties);
    }

    public void testIntArrayPropertySubClass() {
        this.testIntArrayProperty(this._beanSubclassProperties);
    }

    private void testIntArrayProperty(Map properties) {
        IBeanPropertySymbol property = (IBeanPropertySymbol)properties.get("intArrayProperty");
        TestIJavaTypeDescriptor2.assertNotNull((Object)property);
        TestIJavaTypeDescriptor2.assertTrue((boolean)property.isReadable());
        ITypeDescriptor typeDesc = property.getTypeDescriptor();
        TestIJavaTypeDescriptor2.assertEquals((String)"Signature must be for a int[]", (String)Signature.createArraySignature((String)"I", (int)1), (String)typeDesc.getTypeSignature());
        TestIJavaTypeDescriptor2.assertEquals((boolean)true, (boolean)typeDesc.isArray());
        TestIJavaTypeDescriptor2.assertEquals((int)1, (int)((IJavaTypeDescriptor2)typeDesc).getArrayCount());
    }

    public void testArrayOfArrayOfStringProperty() {
        this.testArrayOfArrayOfStringProperty(this._beanProperties);
    }

    public void testArrayOfArrayOfStringPropertySubClass() {
        this.testArrayOfArrayOfStringProperty(this._beanSubclassProperties);
    }

    private void testArrayOfArrayOfStringProperty(Map properties) {
        IBeanPropertySymbol property = (IBeanPropertySymbol)properties.get("arrayOfArrayOfStringProperty");
        TestIJavaTypeDescriptor2.assertNotNull((Object)property);
        TestIJavaTypeDescriptor2.assertTrue((boolean)property.isReadable());
        ITypeDescriptor typeDesc = property.getTypeDescriptor();
        TestIJavaTypeDescriptor2.assertEquals((String)"Signature must be for a String[][]", (String)Signature.createArraySignature((String)"Ljava.lang.String;", (int)2), (String)typeDesc.getTypeSignature());
        TestIJavaTypeDescriptor2.assertEquals((boolean)true, (boolean)typeDesc.isArray());
        TestIJavaTypeDescriptor2.assertEquals((int)2, (int)((IJavaTypeDescriptor2)typeDesc).getArrayCount());
    }

    public void testCollectionProperty() {
        this.testCollectionProperty(this._beanProperties);
    }

    public void testCollectionPropertySubClass() {
        this.testCollectionProperty(this._beanSubclassProperties);
    }

    private void testCollectionProperty(Map properties) {
        IBeanPropertySymbol property = (IBeanPropertySymbol)properties.get("collectionProperty");
        TestIJavaTypeDescriptor2.assertNotNull((Object)property);
        TestIJavaTypeDescriptor2.assertTrue((boolean)property.isReadable());
        TestIJavaTypeDescriptor2.assertTrue((boolean)property.isWritable());
        TestIJavaTypeDescriptor2.assertEquals((String)"Signature must be for a Collection", (String)"Ljava.util.Collection;", (String)property.getTypeDescriptor().getTypeSignature());
    }

    public void testMapProperty() {
        this.testMapProperty(this._beanProperties);
    }

    public void testMapPropertySubClass() {
        this.testMapProperty(this._beanProperties);
    }

    private void testMapProperty(Map properties) {
        IBeanPropertySymbol property = (IBeanPropertySymbol)properties.get("mapProperty");
        TestIJavaTypeDescriptor2.assertNotNull((Object)property);
        TestIJavaTypeDescriptor2.assertTrue((boolean)property.isReadable());
        TestIJavaTypeDescriptor2.assertTrue((boolean)property.isWritable());
        TestIJavaTypeDescriptor2.assertEquals((String)"Signature must be for a Map", (String)"Ljava.util.Map;", (String)property.getTypeDescriptor().getTypeSignature());
    }

    public void testWriteonlyStringProperty() {
        this.testWriteonlyStringProperty(this._beanProperties);
    }

    public void testWriteonlyStringPropertySubClass() {
        this.testWriteonlyStringProperty(this._beanSubclassProperties);
    }

    private void testWriteonlyStringProperty(Map properties) {
        IBeanPropertySymbol property = (IBeanPropertySymbol)properties.get("writeonlyStringProperty");
        TestIJavaTypeDescriptor2.assertNotNull((Object)property);
        TestIJavaTypeDescriptor2.assertFalse((String)"No getter for this property", (boolean)property.isReadable());
        TestIJavaTypeDescriptor2.assertTrue((boolean)property.isWritable());
        TestIJavaTypeDescriptor2.assertEquals((String)"Signature must be for a String", (String)"Ljava.lang.String;", (String)property.getTypeDescriptor().getTypeSignature());
    }

    public void testAnotherBean() {
        this.testAnotherBean(this._beanProperties);
    }

    public void testAnotherBeanSubClass() {
        this.testAnotherBean(this._beanSubclassProperties);
    }

    private void testAnotherBean(Map properties) {
        IBeanPropertySymbol property = (IBeanPropertySymbol)properties.get("anotherBean");
        TestIJavaTypeDescriptor2.assertNotNull((Object)property);
        TestIJavaTypeDescriptor2.assertTrue((boolean)property.isReadable());
        TestIJavaTypeDescriptor2.assertTrue((String)"No setter for this property", (boolean)property.isWritable());
        TestIJavaTypeDescriptor2.assertEquals((String)"Signature must be for a com.test.AnotherBean", (String)"Lcom.test.AnotherBean;", (String)property.getTypeDescriptor().getTypeSignature());
    }

    public void testPropertyOfProperty() {
        this.testPropertyOfProperty(this._beanProperties);
    }

    public void testPropertyOfPropertyInSubclass() {
        this.testPropertyOfProperty(this._beanSubclassProperties);
    }

    private void testPropertyOfProperty(Map properties) {
        IBeanPropertySymbol property = (IBeanPropertySymbol)properties.get("anotherBean");
        TestIJavaTypeDescriptor2.assertNotNull((Object)property);
        boolean foundNestedProperty = false;
        EList anotherBeanProps = property.getTypeDescriptor().getProperties();
        TestIJavaTypeDescriptor2.assertTrue((String)"The nested properties has properties", (anotherBeanProps.size() > 0 ? 1 : 0) != 0);
        for (IBeanPropertySymbol nestedProp : anotherBeanProps) {
            if (!"property".equals(nestedProp.getName())) continue;
            foundNestedProperty = true;
            break;
        }
        TestIJavaTypeDescriptor2.assertTrue((boolean)foundNestedProperty);
    }

    public void testSubclassOnly() {
        TestIJavaTypeDescriptor2.assertNull(this._beanProperties.get("locallyDefinedProperty"));
        IBeanPropertySymbol property = (IBeanPropertySymbol)this._beanSubclassProperties.get("locallyDefinedProperty");
        TestIJavaTypeDescriptor2.assertNotNull((Object)property);
        TestIJavaTypeDescriptor2.assertTrue((boolean)property.isReadable());
        TestIJavaTypeDescriptor2.assertFalse((boolean)property.isWritable());
        TestIJavaTypeDescriptor2.assertEquals((String)"Signature must be for a String", (String)"Ljava.lang.String;", (String)property.getTypeDescriptor().getTypeSignature());
    }

    public void testArrayPropertyElement() {
        IPropertySymbol propSymbol = (IPropertySymbol)this._beanProperties.get("stringArrayProperty");
        TestIJavaTypeDescriptor2.assertNotNull((Object)propSymbol);
        ITypeDescriptor typeDesc = propSymbol.getTypeDescriptor();
        TestIJavaTypeDescriptor2.assertNotNull((Object)typeDesc);
        TestIJavaTypeDescriptor2.assertEquals((String)"Ljava.lang.String;", (String)typeDesc.getArrayElement().getTypeDescriptor().getTypeSignature());
        IObjectSymbol symbol = typeDesc.getArrayElement();
        TestIJavaTypeDescriptor2.assertNotNull((Object)symbol);
        TestIJavaTypeDescriptor2.assertEquals((String)"Ljava.lang.String;", (String)symbol.getTypeDescriptor().getTypeSignature());
    }

    public void testIntArrayPropertyElement() {
        IPropertySymbol propSymbol = (IPropertySymbol)this._beanProperties.get("intArrayProperty");
        TestIJavaTypeDescriptor2.assertNotNull((Object)propSymbol);
        ITypeDescriptor typeDesc = propSymbol.getTypeDescriptor();
        TestIJavaTypeDescriptor2.assertNotNull((Object)typeDesc);
        TestIJavaTypeDescriptor2.assertEquals((String)"I", (String)typeDesc.getArrayElement().getTypeDescriptor().getTypeSignature());
        IObjectSymbol symbol = typeDesc.getArrayElement();
        TestIJavaTypeDescriptor2.assertNotNull((Object)symbol);
        TestIJavaTypeDescriptor2.assertEquals((String)"I", (String)symbol.getTypeDescriptor().getTypeSignature());
    }

    public void testArrayOfArrayOfStringPropertyElement() {
        IPropertySymbol propSymbol = (IPropertySymbol)this._beanProperties.get("arrayOfArrayOfStringProperty");
        TestIJavaTypeDescriptor2.assertNotNull((Object)propSymbol);
        ITypeDescriptor typeDesc = propSymbol.getTypeDescriptor();
        TestIJavaTypeDescriptor2.assertNotNull((Object)typeDesc);
        TestIJavaTypeDescriptor2.assertEquals((String)Signature.createArraySignature((String)"Ljava.lang.String;", (int)1), (String)typeDesc.getArrayElement().getTypeDescriptor().getTypeSignature());
        IObjectSymbol symbol = typeDesc.getArrayElement();
        TestIJavaTypeDescriptor2.assertNotNull((Object)symbol);
        TestIJavaTypeDescriptor2.assertEquals((String)Signature.createArraySignature((String)"Ljava.lang.String;", (int)1), (String)typeDesc.getArrayElement().getTypeDescriptor().getTypeSignature());
        TestIJavaTypeDescriptor2.assertTrue((boolean)symbol.getTypeDescriptor().isArray());
        IObjectSymbol nestedSymbol = symbol.getTypeDescriptor().getArrayElement();
        TestIJavaTypeDescriptor2.assertNotNull((Object)nestedSymbol);
        TestIJavaTypeDescriptor2.assertEquals((String)"Ljava.lang.String;", (String)nestedSymbol.getTypeDescriptor().getTypeSignature());
    }

    public void testGenericGetterBeans() {
        IPropertySymbol propSymbol = this._genericProperties.get("listOfStrings");
        TestIJavaTypeDescriptor2.assertNotNull((Object)propSymbol);
        ITypeDescriptor typeDesc = propSymbol.getTypeDescriptor();
        TestIJavaTypeDescriptor2.assertNotNull((Object)typeDesc);
        TestIJavaTypeDescriptor2.assertEquals((String)"Ljava.util.List;", (String)typeDesc.getTypeSignature());
        TestIJavaTypeDescriptor2.assertEquals((int)1, (int)typeDesc.getTypeParameterSignatures().size());
        TestIJavaTypeDescriptor2.assertEquals((Object)"Ljava.lang.String;", (Object)typeDesc.getTypeParameterSignatures().get(0));
        propSymbol = this._genericProperties.get("mapOfStringsKeyedByString");
        TestIJavaTypeDescriptor2.assertNotNull((Object)propSymbol);
        typeDesc = propSymbol.getTypeDescriptor();
        TestIJavaTypeDescriptor2.assertNotNull((Object)typeDesc);
        TestIJavaTypeDescriptor2.assertEquals((String)"Ljava.util.Map;", (String)typeDesc.getTypeSignature());
        TestIJavaTypeDescriptor2.assertEquals((int)2, (int)typeDesc.getTypeParameterSignatures().size());
        TestIJavaTypeDescriptor2.assertEquals((Object)"Ljava.lang.String;", (Object)typeDesc.getTypeParameterSignatures().get(0));
        TestIJavaTypeDescriptor2.assertEquals((Object)"Ljava.lang.String;", (Object)typeDesc.getTypeParameterSignatures().get(1));
        propSymbol = this._genericProperties.get("mapOfTestBeansByString");
        TestIJavaTypeDescriptor2.assertNotNull((Object)propSymbol);
        typeDesc = propSymbol.getTypeDescriptor();
        TestIJavaTypeDescriptor2.assertNotNull((Object)typeDesc);
        TestIJavaTypeDescriptor2.assertEquals((String)"Ljava.util.Map;", (String)typeDesc.getTypeSignature());
        TestIJavaTypeDescriptor2.assertEquals((int)2, (int)typeDesc.getTypeParameterSignatures().size());
        TestIJavaTypeDescriptor2.assertEquals((Object)"Ljava.lang.String;", (Object)typeDesc.getTypeParameterSignatures().get(0));
        TestIJavaTypeDescriptor2.assertEquals((Object)testBean1Sig, (Object)typeDesc.getTypeParameterSignatures().get(1));
        propSymbol = this._genericProperties.get("mutableMapOfStringByString");
        TestIJavaTypeDescriptor2.assertNotNull((Object)propSymbol);
        typeDesc = propSymbol.getTypeDescriptor();
        TestIJavaTypeDescriptor2.assertNotNull((Object)typeDesc);
        TestIJavaTypeDescriptor2.assertEquals((String)"Ljava.util.Map;", (String)typeDesc.getTypeSignature());
        TestIJavaTypeDescriptor2.assertEquals((int)2, (int)typeDesc.getTypeParameterSignatures().size());
        TestIJavaTypeDescriptor2.assertEquals((Object)"Ljava.lang.String;", (Object)typeDesc.getTypeParameterSignatures().get(0));
        TestIJavaTypeDescriptor2.assertEquals((Object)"Ljava.lang.String;", (Object)typeDesc.getTypeParameterSignatures().get(1));
    }

    public void testABooleanMethodWithNoArgs() {
        this.testABooleanMethodWithNoArgs(this._beanMethods);
    }

    public void testABooleanMethodWithNoArgsSubclass() {
        this.testABooleanMethodWithNoArgs(this._beanMethodsSubclass);
    }

    private void testABooleanMethodWithNoArgs(Map properties) {
        IBeanMethodSymbol method = (IBeanMethodSymbol)properties.get("aBooleanMethodWithNoArgs");
        TestIJavaTypeDescriptor2.assertEquals((String)"()Z", (String)method.getSignature());
    }

    public void testAStringMethodWithNoArgs() {
        this.testAStringMethodWithNoArgs(this._beanMethods);
    }

    public void testAStringMethodWithNoArgsSubclass() {
        this.testAStringMethodWithNoArgs(this._beanMethodsSubclass);
    }

    private void testAStringMethodWithNoArgs(Map properties) {
        IBeanMethodSymbol method = (IBeanMethodSymbol)properties.get("aStringMethodWithNoArgs");
        TestIJavaTypeDescriptor2.assertEquals((String)"()Ljava.lang.String;", (String)method.getSignature());
    }

    public void testIsAnIsAccessor() {
        this.testIsAnIsAccessor(this._beanMethods);
    }

    public void testIsAnIsAccessorSubclass() {
        this.testIsAnIsAccessor(this._beanMethodsSubclass);
    }

    private void testIsAnIsAccessor(Map properties) {
        IBeanMethodSymbol method = (IBeanMethodSymbol)properties.get("isAnIsAccessor");
        TestIJavaTypeDescriptor2.assertEquals((String)"()Z", (String)method.getSignature());
    }

    public void testAIntegerMethodThatTakesAString() {
        this.testAIntegerMethodThatTakesAString(this._beanMethods);
    }

    public void testAIntegerMethodThatTakesAStringSubclass() {
        this.testAIntegerMethodThatTakesAString(this._beanMethodsSubclass);
    }

    private void testAIntegerMethodThatTakesAString(Map properties) {
        IBeanMethodSymbol method = (IBeanMethodSymbol)properties.get("aIntegerMethodThatTakesAString");
        TestIJavaTypeDescriptor2.assertEquals((String)"(Ljava.lang.String;)I", (String)method.getSignature());
    }

    public void testAIntegerMethodThatTakesAStringAndLong() {
        this.testAIntegerMethodThatTakesAStringAndLong(this._beanMethods);
    }

    public void testAIntegerMethodThatTakesAStringAndLongSubclass() {
        this.testAIntegerMethodThatTakesAStringAndLong(this._beanMethodsSubclass);
    }

    private void testAIntegerMethodThatTakesAStringAndLong(Map properties) {
        IBeanMethodSymbol method = (IBeanMethodSymbol)properties.get("aIntegerMethodThatTakesAStringAndLong");
        TestIJavaTypeDescriptor2.assertEquals((String)"(Ljava.lang.String;Ljava.lang.Long;)I", (String)method.getSignature());
    }

    public void testOverloadedMethod() {
        this.testOverloadedMethod(this._testBean2Symbol);
    }

    public void testOverloadedMethodSubclass() {
        this.testOverloadedMethod(this._testBean2SubclassSymbol);
    }

    private void testOverloadedMethod(IBeanInstanceSymbol bean) {
        boolean foundIntOverload = false;
        boolean foundStringOverload = false;
        for (IBeanMethodSymbol method : bean.getTypeDescriptor().getMethods()) {
            if (!overloadedMethodName.equals(method.getName())) continue;
            String typeSignature = method.getSignature();
            if ("(I)V".equals(typeSignature)) {
                foundIntOverload = true;
                continue;
            }
            if (!"(Ljava.lang.String;)V".equals(typeSignature)) continue;
            foundStringOverload = true;
        }
        TestIJavaTypeDescriptor2.assertTrue((foundIntOverload && foundStringOverload ? 1 : 0) != 0);
    }

    public void testMethodSubclassOnly() {
        TestIJavaTypeDescriptor2.assertNull((Object)this._beanMethods.get("validate"));
        IBeanMethodSymbol method = (IBeanMethodSymbol)this._beanMethodsSubclass.get("validate");
        TestIJavaTypeDescriptor2.assertNotNull((Object)method);
        TestIJavaTypeDescriptor2.assertEquals((String)"(Lcom.test.TestBean2;)V", (String)method.getSignature());
    }

    public void testSuperClassAcquisition() {
        EList superSigs = this._testBean1Symbol.getTypeDescriptor().getSuperTypeSignatures();
        TestIJavaTypeDescriptor2.assertEquals((int)superSigs.size(), (int)1);
        TestIJavaTypeDescriptor2.assertEquals((String)"Ljava.lang.Object;", (String)((String)superSigs.get(0)));
        superSigs = this._testBean1SubclassSymbol.getTypeDescriptor().getSuperTypeSignatures();
        TestIJavaTypeDescriptor2.assertEquals((int)superSigs.size(), (int)2);
        TestIJavaTypeDescriptor2.assertTrue((boolean)superSigs.contains("Ljava.lang.Object;"));
        TestIJavaTypeDescriptor2.assertTrue((boolean)superSigs.contains(testBean1Sig));
        superSigs = this._testBean2Symbol.getTypeDescriptor().getSuperTypeSignatures();
        TestIJavaTypeDescriptor2.assertEquals((int)superSigs.size(), (int)1);
        TestIJavaTypeDescriptor2.assertEquals((String)"Ljava.lang.Object;", (String)((String)superSigs.get(0)));
        superSigs = this._testBean2SubclassSymbol.getTypeDescriptor().getSuperTypeSignatures();
        TestIJavaTypeDescriptor2.assertEquals((int)superSigs.size(), (int)2);
        TestIJavaTypeDescriptor2.assertTrue((boolean)superSigs.contains("Ljava.lang.Object;"));
        TestIJavaTypeDescriptor2.assertTrue((boolean)superSigs.contains("Lcom.test.TestBean2;"));
    }

    public void testInterfaceAcquisition() {
        EList superSigs = this._testBean2Symbol.getTypeDescriptor().getInterfaceTypeSignatures();
        TestIJavaTypeDescriptor2.assertEquals((int)superSigs.size(), (int)1);
        TestIJavaTypeDescriptor2.assertEquals((String)"Lcom.test.ITestBean2;", (String)((String)superSigs.get(0)));
        superSigs = this._testBean2SubclassSymbol.getTypeDescriptor().getInterfaceTypeSignatures();
        TestIJavaTypeDescriptor2.assertEquals((int)superSigs.size(), (int)1);
        TestIJavaTypeDescriptor2.assertEquals((String)"Lcom.test.ITestBean2;", (String)((String)superSigs.get(0)));
    }

    public void testIsESet() {
        IType testBean1Type = null;
        try {
            testBean1Type = this._jdtTestEnvironment.getJavaProject().findType("com.test.TestBean1");
        }
        catch (JavaModelException jme) {
            TestIJavaTypeDescriptor2.fail((String)jme.getLocalizedMessage());
        }
        TestIJavaTypeDescriptor2.assertNotNull((Object)testBean1Type);
        IJavaTypeDescriptor2 desc = SymbolFactory.eINSTANCE.createIJavaTypeDescriptor2();
        TestIJavaTypeDescriptor2.assertFalse((boolean)desc.eIsSet((EStructuralFeature)SymbolPackage.eINSTANCE.getIJavaTypeDescriptor2_BeanProperties()));
        TestIJavaTypeDescriptor2.assertFalse((boolean)desc.eIsSet((EStructuralFeature)SymbolPackage.eINSTANCE.getIJavaTypeDescriptor2_BeanMethods()));
        desc.eSet((EStructuralFeature)SymbolPackage.eINSTANCE.getIJavaTypeDescriptor2_BeanProperties(), (Object)this._testBean2Symbol.getJavaTypeDescriptor().getBeanProperties());
        desc.eSet((EStructuralFeature)SymbolPackage.eINSTANCE.getIJavaTypeDescriptor2_BeanMethods(), (Object)this._testBean2Symbol.getJavaTypeDescriptor().getBeanMethods());
        desc.eSet((EStructuralFeature)SymbolPackage.eINSTANCE.getIJavaTypeDescriptor2_Type(), (Object)testBean1Type);
        TestIJavaTypeDescriptor2.assertFalse((((List)desc.eGet((EStructuralFeature)SymbolPackage.eINSTANCE.getIJavaTypeDescriptor2_BeanProperties())).size() == 0 ? 1 : 0) != 0);
        TestIJavaTypeDescriptor2.assertFalse((((List)desc.eGet((EStructuralFeature)SymbolPackage.eINSTANCE.getIJavaTypeDescriptor2_BeanMethods())).size() == 0 ? 1 : 0) != 0);
        TestIJavaTypeDescriptor2.assertEquals((Object)desc.eGet((EStructuralFeature)SymbolPackage.eINSTANCE.getIJavaTypeDescriptor2_Type()), (Object)testBean1Type);
        TestIJavaTypeDescriptor2.assertTrue((boolean)desc.eIsSet((EStructuralFeature)SymbolPackage.eINSTANCE.getIJavaTypeDescriptor2_BeanProperties()));
        TestIJavaTypeDescriptor2.assertTrue((boolean)desc.eIsSet((EStructuralFeature)SymbolPackage.eINSTANCE.getIJavaTypeDescriptor2_BeanMethods()));
        TestIJavaTypeDescriptor2.assertTrue((boolean)desc.eIsSet((EStructuralFeature)SymbolPackage.eINSTANCE.getIJavaTypeDescriptor2_Type()));
        desc.eUnset((EStructuralFeature)SymbolPackage.eINSTANCE.getIJavaTypeDescriptor2_BeanProperties());
        desc.eUnset((EStructuralFeature)SymbolPackage.eINSTANCE.getIJavaTypeDescriptor2_BeanMethods());
        desc.eUnset((EStructuralFeature)SymbolPackage.eINSTANCE.getIJavaTypeDescriptor2_Type());
        TestIJavaTypeDescriptor2.assertFalse((boolean)desc.eIsSet((EStructuralFeature)SymbolPackage.eINSTANCE.getIJavaTypeDescriptor2_BeanProperties()));
        TestIJavaTypeDescriptor2.assertFalse((boolean)desc.eIsSet((EStructuralFeature)SymbolPackage.eINSTANCE.getIJavaTypeDescriptor2_BeanMethods()));
        TestIJavaTypeDescriptor2.assertFalse((boolean)desc.eIsSet((EStructuralFeature)SymbolPackage.eINSTANCE.getIJavaTypeDescriptor2_Type()));
    }

    public void testToString() {
        this._testBean2Symbol.getTypeDescriptor().toString();
    }
}

