/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.dtd.ui.internal.properties.section;

import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.eclipse.wst.dtd.core.internal.Entity;
import org.eclipse.wst.dtd.ui.internal.DTDPropertiesMessages;
import org.eclipse.wst.dtd.ui.internal.properties.section.AbstractSection;

public class EntityTypeSection
extends AbstractSection {
    private final String ENTITY_TYPE = DTDPropertiesMessages._UI_LABEL_ENTITY_TYPE;
    private final String EXTERNAL_ENTITY = DTDPropertiesMessages._UI_LABEL_EXTERNAL_ENTITY;
    private final String PARAMETER = DTDPropertiesMessages._UI_LABEL_PARAMETER_ENTITY;
    private final String GENERAL = DTDPropertiesMessages._UI_LABEL_GENERAL_ENTITY;
    private CCombo typeCombo;
    private String[] typeComboValues = new String[]{this.PARAMETER, this.GENERAL};
    private Button checkBox;
    public static boolean isExternalEntity = false;

    @Override
    public void createControls(Composite parent, TabbedPropertySheetWidgetFactory factory) {
        super.createControls(parent, factory);
        Composite composite = this.getWidgetFactory().createFlatFormComposite(parent);
        CLabel cLabel = this.getWidgetFactory().createCLabel(composite, this.ENTITY_TYPE);
        Point p = cLabel.computeSize(-1, -1, false);
        int labelWidth = Math.max(p.x, 98);
        FormData data = new FormData(labelWidth, -1);
        data.left = new FormAttachment(0, 0);
        data.top = new FormAttachment(0, 0);
        cLabel.setLayoutData((Object)data);
        this.typeCombo = this.getWidgetFactory().createCCombo(composite, 0x800000);
        data = new FormData();
        data.left = new FormAttachment((Control)cLabel, -5);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment((Control)cLabel, 0, 0x1000000);
        this.typeCombo.setLayoutData((Object)data);
        this.typeCombo.addSelectionListener((SelectionListener)this);
        this.typeCombo.setItems(this.typeComboValues);
        this.checkBox = this.getWidgetFactory().createButton(composite, this.EXTERNAL_ENTITY, 32);
        p = this.checkBox.computeSize(-1, -1, false);
        labelWidth = Math.max(p.x, 98);
        data = new FormData(labelWidth, -1);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(95, 0);
        data.top = new FormAttachment((Control)cLabel, 4);
        this.checkBox.setLayoutData((Object)data);
        this.checkBox.addSelectionListener((SelectionListener)this);
    }

    @Override
    public void refresh() {
        this.setListenerEnabled(false);
        Object input = this.getInput();
        if (input != null && input instanceof Entity) {
            Entity entity = (Entity)input;
            if (entity.isParameterEntity()) {
                this.typeCombo.setText(this.PARAMETER);
            } else {
                this.typeCombo.setText(this.GENERAL);
            }
            if (entity.isExternalEntity()) {
                this.checkBox.setSelection(true);
                isExternalEntity = true;
            } else {
                this.checkBox.setSelection(false);
                isExternalEntity = false;
            }
        }
        this.setListenerEnabled(true);
    }

    @Override
    public void widgetSelected(SelectionEvent e) {
        Object input;
        if (e.widget == this.typeCombo) {
            Object input2 = this.getInput();
            if (input2 instanceof Entity) {
                Entity node = (Entity)input2;
                String selected = this.typeCombo.getText();
                if (this.PARAMETER.equals(selected)) {
                    node.setParameterEntity(true);
                } else {
                    node.setParameterEntity(false);
                }
            }
        } else if (e.widget == this.checkBox && (input = this.getInput()) instanceof Entity) {
            Entity node = (Entity)input;
            boolean selected = this.checkBox.getSelection();
            if (selected) {
                node.setExternalEntity(true);
                isExternalEntity = true;
            } else {
                node.setExternalEntity(false);
                isExternalEntity = false;
            }
        }
    }

    @Override
    public boolean shouldUseExtraSpace() {
        return false;
    }
}

