/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.common.internal.annotations.ui;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.MissingResourceException;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jdt.ui.text.java.IJavadocCompletionProcessor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jst.common.internal.annotations.core.AnnotationTagParser;
import org.eclipse.jst.common.internal.annotations.core.TagParseEventHandler;
import org.eclipse.jst.common.internal.annotations.core.Token;
import org.eclipse.jst.common.internal.annotations.registry.AnnotationTagRegistry;
import org.eclipse.jst.common.internal.annotations.registry.AttributeValueProposalHelper;
import org.eclipse.jst.common.internal.annotations.registry.AttributeValuesHelper;
import org.eclipse.jst.common.internal.annotations.registry.TagAttribSpec;
import org.eclipse.jst.common.internal.annotations.registry.TagSpec;
import org.eclipse.jst.common.internal.annotations.ui.AnnotationTagProposal;
import org.eclipse.ui.part.FileEditorInput;

public class AnnotationTagCompletionProc
implements IJavadocCompletionProcessor,
TagParseEventHandler {
    private static final String[] BOOLEAN_VALID_VALUES = new String[]{"false", "true"};
    ICompilationUnit m_icu;
    IDocument m_doc;
    List m_tags;
    Token m_tagName;
    Set m_attSet = new TreeSet();
    List m_attributes = new ArrayList();
    AnnotationTagParser m_parser = new AnnotationTagParser((TagParseEventHandler)this);
    int m_tagScope;

    public AnnotationTagCompletionProc() {
        this.initTagInfo();
    }

    private void initTagInfo() {
        if (this.m_tags == null) {
            this.m_tags = AnnotationTagRegistry.getAllTagSpecs();
        }
    }

    public IContextInformation[] computeContextInformation(ICompilationUnit cu, int offset) {
        return null;
    }

    public IJavaCompletionProposal[] computeCompletionProposals(ICompilationUnit cu, int offset, int length, int flags) {
        AnnotationArea area;
        block6: {
            if (cu == null) {
                return null;
            }
            FileEditorInput editorInput = new FileEditorInput((IFile)cu.getResource());
            this.m_doc = JavaUI.getDocumentProvider().getDocument((Object)editorInput);
            this.m_icu = cu;
            area = this.getAnnotationArea(offset);
            if (area != null) break block6;
            return null;
        }
        try {
            String tsf = this.getTagSoFarIfNotCompleted(area.beginOffset, offset);
            if (tsf != null) {
                return this.getTagCompletionsFor(tsf, area, length);
            }
            return this.maybeCompleteAttribute(area, offset);
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    private IJavaCompletionProposal[] maybeCompleteAttribute(AnnotationArea area, int cursorPos) throws BadLocationException {
        this.m_attSet.clear();
        this.m_attributes.clear();
        this.m_parser.setParserInput(this.m_doc.get(area.beginOffset, area.length()));
        this.m_parser.parse();
        TagSpec ts = null;
        if (this.m_tagName != null) {
            ts = this.getTagSpecForTagName(this.m_tagName.getText());
        }
        if (ts == null) {
            return null;
        }
        Attribute target = null;
        Attribute last = null;
        Attribute before = null;
        Attribute a2 = null;
        boolean between = false;
        int rCurPos = area.relativeCursorPos(cursorPos);
        for (Attribute a2 : this.m_attributes) {
            if (a2.contains(rCurPos)) {
                target = a2;
                break;
            }
            if (last != null) {
                if (rCurPos > last.maxExtent() + 1 && rCurPos < a2.minExtent() - 1) {
                    between = true;
                    break;
                }
                if (a2.immediatelyPrecedes(rCurPos)) {
                    before = a2;
                    break;
                }
            }
            last = a2;
        }
        if (target == null) {
            if (between) {
                return this.attributeCompletionsFor(ts, cursorPos, 0, "", true);
            }
            if (before != null) {
                target = before;
            } else {
                if (a2 == null) {
                    return this.attributeCompletionsFor(ts, cursorPos, 0, "", true);
                }
                if (rCurPos > a2.maxExtent()) {
                    if (a2.hasAssignment() && a2.hasValue()) {
                        return this.attributeCompletionsFor(ts, cursorPos, 0, "", true);
                    }
                    if (a2.hasAssignment()) {
                        return this.attributeValidValuesFor(ts, a2, area, cursorPos);
                    }
                    return this.attributeCompletionsFor(ts, cursorPos - a2.name.length(), 0, a2.name.getText(), true);
                }
                return this.attributeCompletionsFor(ts, cursorPos, 0, "", true);
            }
        }
        if (target.name.immediatelyPrecedes(rCurPos)) {
            return this.attributeCompletionsFor(ts, area.relativeToAbs(target.name.getBeginning()), target.name.length(), target.name.getText(), !target.hasAssignment());
        }
        if (target.name.contains(rCurPos)) {
            return this.attributeCompletionsFor(ts, area.relativeToAbs(target.name.getBeginning()), target.name.length(), target.name.getText().substring(0, rCurPos - target.name.getBeginning()), !target.hasAssignment());
        }
        if (a2 != null && a2.value != null && (a2.value.contains(rCurPos) || target.hasAssignment() && area.relativeCursorPos(cursorPos) > a2.name.getBeginning())) {
            return this.attributeValidValuesFor(ts, a2, area, cursorPos);
        }
        return this.attributeCompletionsFor(ts, cursorPos, 0, "", true);
    }

    private IJavaCompletionProposal[] attributeValidValuesFor(TagSpec ts, Attribute a, AnnotationArea area, int cursorPos) {
        TagAttribSpec tas = ts.attributeNamed(a.name.getText());
        if (tas == null) {
            return null;
        }
        String[] validValues = this.getValidValues(tas, a, area);
        String partialValue = this.calculatePartialValue(a, area, cursorPos);
        int valueOffset = this.calculateValueOffset(a, area, cursorPos);
        if (validValues == null || validValues.length == 0) {
            return this.createCustomAttributeCompletionProposals(ts, tas, partialValue, valueOffset, a.value.getText(), area.javaElement);
        }
        return this.createAttributeCompletionProposals(partialValue, valueOffset, validValues);
    }

    private IJavaCompletionProposal[] createCustomAttributeCompletionProposals(TagSpec ts, TagAttribSpec tas, String partialValue, int valueOffset, String value, IJavaElement javaElement) {
        AttributeValuesHelper helper = ts.getValidValuesHelper();
        if (helper == null) {
            return null;
        }
        AttributeValueProposalHelper[] proposalHelpers = helper.getAttributeValueProposalHelpers(tas, partialValue, valueOffset, javaElement);
        if (proposalHelpers == null || proposalHelpers.length == 0) {
            return null;
        }
        IJavaCompletionProposal[] proposals = new IJavaCompletionProposal[proposalHelpers.length];
        int i = 0;
        while (i < proposalHelpers.length) {
            AnnotationTagProposal proposal = new AnnotationTagProposal(proposalHelpers[i]);
            proposals[i] = proposal;
            ++i;
        }
        return proposals;
    }

    private IJavaCompletionProposal[] createAttributeCompletionProposals(String partialValue, int valueOffset, String[] validValues) {
        ArrayList<AnnotationTagProposal> resultingValues = new ArrayList<AnnotationTagProposal>();
        int i = 0;
        while (i < validValues.length) {
            String rplString = validValues[i];
            if (partialValue == null || rplString.startsWith(partialValue)) {
                AnnotationTagProposal prop = new AnnotationTagProposal(rplString, valueOffset, 0, null, rplString, 90);
                prop.setEnsureQuoted(true);
                resultingValues.add(prop);
            }
            ++i;
        }
        if (resultingValues.isEmpty()) {
            return null;
        }
        return resultingValues.toArray(new IJavaCompletionProposal[resultingValues.size()]);
    }

    private String[] getValidValues(TagAttribSpec tas, Attribute a, AnnotationArea area) {
        String[] validValues = tas.getValidValues();
        if (validValues == null || validValues.length == 0) {
            AttributeValuesHelper helper = tas.getTagSpec().getValidValuesHelper();
            if (helper == null) {
                return null;
            }
            validValues = helper.getValidValues(tas, area.javaElement);
            if ((validValues == null || validValues.length == 0) && tas.valueIsBool()) {
                validValues = BOOLEAN_VALID_VALUES;
            }
        }
        return validValues;
    }

    private int calculateValueOffset(Attribute a, AnnotationArea area, int cursorPos) {
        if (a.value == null) {
            return cursorPos;
        }
        int nameEnd = a.name.getEnd();
        int valBeg = a.value.getBeginning();
        if (valBeg > nameEnd + 2) {
            return area.relativeToAbs(nameEnd + 2);
        }
        return area.relativeToAbs(valBeg);
    }

    private String calculatePartialValue(Attribute a, AnnotationArea area, int cursorPos) {
        if (a.value == null) {
            return null;
        }
        int nameEnd = a.name.getEnd();
        int valueBeg = a.value.getBeginning();
        if (valueBeg > nameEnd + 2) {
            return null;
        }
        int relativePos = area.relativeCursorPos(cursorPos);
        if (a.value.contains(relativePos)) {
            boolean hasBeginQuote = valueBeg - nameEnd == 2;
            String value = a.value.getText();
            int end = relativePos - valueBeg;
            if (hasBeginQuote) {
                --end;
            }
            if (end > -1) {
                int length = value.length();
                if (end < length) {
                    return value.substring(0, end);
                }
                if (end == length) {
                    return value;
                }
            }
        }
        return null;
    }

    private TagSpec getTagSpecForTagName(String tagName) {
        String simpleName = tagName;
        if (tagName != null && tagName.length() > 0 && tagName.charAt(0) == '@') {
            simpleName = tagName.length() == 2 ? "" : tagName.substring(1);
        }
        switch (this.m_tagScope) {
            case 1: {
                return AnnotationTagRegistry.getTypeTag((String)simpleName);
            }
            case 0: {
                return AnnotationTagRegistry.getMethodTag((String)simpleName);
            }
            case 2: {
                return AnnotationTagRegistry.getFieldTag((String)simpleName);
            }
        }
        return null;
    }

    private IJavaCompletionProposal[] attributeCompletionsFor(TagSpec ts, int replaceOffset, int replaceLength, String partialAttributeName, boolean appendEquals) {
        Iterator i = ts.getAttributes().iterator();
        ArrayList<AnnotationTagProposal> props = new ArrayList<AnnotationTagProposal>();
        while (i.hasNext()) {
            TagAttribSpec tas = (TagAttribSpec)i.next();
            String aname = tas.getAttribName();
            if (this.m_attSet.contains(aname) || !aname.startsWith(partialAttributeName)) continue;
            String rtxt = appendEquals ? String.valueOf(aname) + '=' : aname;
            AnnotationTagProposal prop = new AnnotationTagProposal(rtxt, replaceOffset, replaceLength, null, aname, 90);
            prop.setHelpText(this.lookupAttHelp(tas));
            props.add(prop);
        }
        if (props.isEmpty()) {
            return null;
        }
        return props.toArray(new IJavaCompletionProposal[props.size()]);
    }

    public void annotationTag(Token tag) {
        this.m_tagName = tag;
    }

    public void endOfTag(int pos) {
    }

    public void attribute(Token name, int equalsPosition, Token value) {
        this.m_attributes.add(new Attribute(name, equalsPosition, value));
        this.m_attSet.add(name.getText());
    }

    private String getReplacementForTag(TagSpec ts, int beginIndex) {
        StringBuffer bud = new StringBuffer(32);
        bud.append('@');
        bud.append(ts.getTagName());
        String prefix = this.getArrayPrefixForMultipleAttribs(beginIndex);
        List attributes = ts.getAttributes();
        int i = 0;
        while (i < attributes.size()) {
            TagAttribSpec tas = (TagAttribSpec)attributes.get(i);
            if (tas.isRequired()) {
                bud.append(prefix);
                bud.append(tas.getAttribName());
                bud.append('=');
            }
            ++i;
        }
        return bud.toString();
    }

    private String getArrayPrefixForMultipleAttribs(int beginIndex) {
        String result = null;
        String source = null;
        try {
            source = this.m_icu.getSource();
            if (source == null || beginIndex < 0) {
                return result;
            }
            int newLineIndex = (source = source.substring(0, beginIndex + 1)).lastIndexOf(10);
            if (newLineIndex == -1) {
                newLineIndex = 0;
            }
            String currentLine = source.substring(newLineIndex, beginIndex + 1);
            int annotationIndex = currentLine.lastIndexOf(64);
            result = currentLine.substring(0, annotationIndex);
            result = String.valueOf(result) + "  ";
        }
        catch (Exception exception) {}
        return result;
    }

    private IJavaCompletionProposal[] getTagCompletionsFor(String partialTagName, AnnotationArea area, int selectLength) {
        ArrayList<AnnotationTagProposal> found = new ArrayList<AnnotationTagProposal>();
        int i = 0;
        while (i < this.m_tags.size()) {
            TagSpec ts = (TagSpec)this.m_tags.get(i);
            String tname = ts.getTagName();
            if (ts.getScope() == this.m_tagScope && tname.startsWith(partialTagName)) {
                String rtxt = this.getReplacementForTag(ts, area.beginOffset);
                String labl = String.valueOf('@') + tname;
                AnnotationTagProposal prop = new AnnotationTagProposal(rtxt, area.beginOffset, Math.max(selectLength, rtxt.length()), null, labl, 90);
                prop.setHelpText(this.lookupTagHelp(ts));
                found.add(prop);
            }
            ++i;
        }
        if (!found.isEmpty()) {
            return found.toArray(new IJavaCompletionProposal[found.size()]);
        }
        return null;
    }

    public String getErrorMessage() {
        return null;
    }

    private static boolean isWS1(char c) {
        return c == ' ' || c == '\t' || c == '*' || c == '\r' || c == '\n';
    }

    private String getTagSoFarIfNotCompleted(int startingAt, int cursorAt) throws BadLocationException {
        if (this.m_doc.getChar(startingAt) != '@') {
            return null;
        }
        int firstChar = startingAt + 1;
        if (firstChar == cursorAt) {
            return "";
        }
        int i = firstChar;
        while (i < cursorAt) {
            char c = this.m_doc.getChar(i);
            if (AnnotationTagCompletionProc.isWS1(c)) {
                return null;
            }
            ++i;
        }
        return this.m_doc.get(firstChar, cursorAt - firstChar);
    }

    private AnnotationArea getAnnotationArea(int fromOffset) throws JavaModelException {
        int max;
        int min;
        int absmax;
        IJavaElement el;
        block14: {
            int absmin;
            el = this.m_icu.getElementAt(fromOffset);
            if (el == null) {
                return null;
            }
            int ty = el.getElementType();
            switch (ty) {
                case 8: {
                    IField f = (IField)el;
                    absmax = f.getNameRange().getOffset();
                    absmin = f.getSourceRange().getOffset();
                    this.m_tagScope = 2;
                    break;
                }
                case 7: {
                    IType t = (IType)el;
                    absmax = t.getNameRange().getOffset();
                    absmin = t.getSourceRange().getOffset();
                    this.m_tagScope = 1;
                    break;
                }
                case 9: {
                    IMethod m = (IMethod)el;
                    absmax = m.getNameRange().getOffset();
                    absmin = m.getSourceRange().getOffset();
                    this.m_tagScope = 0;
                    break;
                }
                default: {
                    this.m_tagScope = -1;
                    return null;
                }
            }
            if (absmax < fromOffset) {
                return null;
            }
            min = 0;
            max = 0;
            boolean found = false;
            min = fromOffset;
            while (min >= absmin) {
                if (this.m_doc.getChar(min) == '@') {
                    found = true;
                    break;
                }
                --min;
            }
            if (found) break block14;
            return null;
        }
        try {
            max = fromOffset + 1;
            while (max < absmax) {
                if (this.m_doc.getChar(max) != '@') {
                    ++max;
                    continue;
                }
                break;
            }
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
        return new AnnotationArea(el, min, Math.min(absmax, max));
    }

    private String lookupTagHelp(TagSpec ts) {
        if (ts != null) {
            try {
                return ts.lookupTagHelp();
            }
            catch (MissingResourceException missingResourceException) {}
        }
        return null;
    }

    private String lookupAttHelp(TagAttribSpec tas) {
        if (tas != null) {
            try {
                return tas.lookupTagHelp();
            }
            catch (MissingResourceException missingResourceException) {}
        }
        return null;
    }

    private static class AnnotationArea {
        int beginOffset;
        int endOffset;
        IJavaElement javaElement;

        public AnnotationArea(IJavaElement javaElement, int beg, int end) {
            this.javaElement = javaElement;
            this.beginOffset = beg;
            this.endOffset = end;
        }

        public int length() {
            return this.endOffset - this.beginOffset;
        }

        public int relativeCursorPos(int absCursorPos) {
            return absCursorPos - this.beginOffset;
        }

        public int relativeToAbs(int relPos) {
            return this.beginOffset + relPos;
        }
    }

    private static class Attribute {
        Token name;
        Token value;
        int equalsPos;

        Attribute(Token n, int ep, Token v) {
            this.name = n;
            this.value = v;
            this.equalsPos = ep;
        }

        public boolean hasAssignment() {
            return this.equalsPos != -1;
        }

        public boolean hasValue() {
            return this.value.length() != 0;
        }

        public boolean contains(int srcPos) {
            return srcPos >= this.minExtent() && srcPos <= this.maxExtent();
        }

        public int minExtent() {
            return this.name.getBeginning();
        }

        public int maxExtent() {
            if (this.hasAssignment()) {
                if (this.hasValue()) {
                    return this.value.getEnd();
                }
                return this.equalsPos;
            }
            return this.name.getEnd();
        }

        public boolean immediatelyPrecedes(int pos) {
            return this.maxExtent() + 1 == pos;
        }
    }
}

