/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.ui.internal.breakpointproviders;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jdt.debug.core.IJavaStratumLineBreakpoint;
import org.eclipse.jdt.debug.core.JDIDebugModel;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jst.jsp.ui.internal.JSPUIMessages;
import org.eclipse.jst.jsp.ui.internal.breakpointproviders.ClassPatternRegistry;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.wst.sse.ui.internal.provisional.extensions.ISourceEditingTextTools;
import org.eclipse.wst.sse.ui.internal.provisional.extensions.breakpoint.IBreakpointProvider;

public class JavaStratumBreakpointProvider
implements IBreakpointProvider,
IExecutableExtension {
    private static final String DEFAULT_CLASS_PATTERN = "*jsp,jsp_servlet._*";
    private Object fData = null;

    public IStatus addBreakpoint(IDocument document, IEditorInput input, int editorLineNumber, int offset) throws CoreException {
        int pos = this.getValidPosition(document, editorLineNumber);
        Status status = null;
        if (pos >= 0) {
            IResource res = this.getResourceFromInput(input);
            if (res != null) {
                String path = null;
                IJavaStratumLineBreakpoint point = JDIDebugModel.createStratumBreakpoint((IResource)res, (String)"JSP", (String)res.getName(), path, (String)this.getClassPattern(res), (int)editorLineNumber, (int)pos, (int)pos, (int)0, (boolean)true, null);
                if (point == null) {
                    status = new Status(4, "org.eclipse.jst.jsp.ui", 4, "unsupported input type", null);
                }
            } else if (input instanceof IStorageEditorInput) {
                res = ResourcesPlugin.getWorkspace().getRoot();
                String id = input.getName();
                if (input instanceof IStorageEditorInput && ((IStorageEditorInput)input).getStorage() != null && ((IStorageEditorInput)input).getStorage().getFullPath() != null) {
                    id = ((IStorageEditorInput)input).getStorage().getFullPath().toString();
                }
                HashMap<String, String> attributes = new HashMap<String, String>();
                attributes.put("org.eclipse.wst.sse.ui.extensions.breakpoint.path", id);
                String path = null;
                IJavaStratumLineBreakpoint point = JDIDebugModel.createStratumBreakpoint((IResource)res, (String)"JSP", (String)input.getName(), path, (String)this.getClassPattern(res), (int)editorLineNumber, (int)pos, (int)pos, (int)0, (boolean)true, attributes);
                if (point == null) {
                    status = new Status(4, "org.eclipse.jst.jsp.ui", 4, "unsupported input type", null);
                }
            }
        } else {
            status = new Status(1, "org.eclipse.jst.jsp.ui", 1, JSPUIMessages.BreakpointNotAllowed, null);
        }
        if (status == null) {
            status = new Status(0, "org.eclipse.jst.jsp.ui", 0, JSPUIMessages.OK, null);
        }
        return status;
    }

    private String getClassPattern(IResource resource) {
        if (resource != null) {
            String shortName = resource.getName();
            String extension = resource.getFileExtension();
            if (extension != null && extension.length() < shortName.length()) {
                shortName = shortName.substring(0, shortName.length() - extension.length() - 1);
            }
            if (this.fData instanceof String && this.fData.toString().length() > 0) {
                return this.fData + ",_" + shortName;
            }
            if (this.fData instanceof Map && resource.isAccessible() && resource.getType() == 1) {
                IContentType[] types = Platform.getContentTypeManager().findContentTypesFor(resource.getName());
                if (types.length == 0) {
                    IContentDescription d = null;
                    try {
                        d = ((IFile)resource).getContentDescription();
                        if (d != null) {
                            types = new IContentType[]{d.getContentType()};
                        }
                    }
                    catch (CoreException coreException) {}
                }
                if (types == null) {
                    types = Platform.getContentTypeManager().findContentTypesFor(resource.getName());
                }
                StringBuffer patternBuffer = new StringBuffer("_" + shortName);
                HashSet contributions = new HashSet(0);
                int i = 0;
                while (i < types.length) {
                    String id = types[i].getId();
                    Object pattern = ((Map)this.fData).get(id);
                    if (pattern != null) {
                        patternBuffer.append(",");
                        patternBuffer.append(pattern);
                    }
                    Iterator it = ClassPatternRegistry.getInstance().getClassPatternSegments(id);
                    while (it.hasNext()) {
                        contributions.add(it.next());
                    }
                    ++i;
                }
                if (contributions.size() > 0) {
                    Iterator it = contributions.iterator();
                    while (it.hasNext()) {
                        patternBuffer.append(',');
                        patternBuffer.append(it.next());
                    }
                }
                return patternBuffer.toString();
            }
        }
        return DEFAULT_CLASS_PATTERN;
    }

    public IResource getResource(IEditorInput input) {
        return this.getResourceFromInput(input);
    }

    private IResource getResourceFromInput(IEditorInput input) {
        IResource resource = (IResource)input.getAdapter(IFile.class);
        if (resource == null) {
            resource = (IResource)input.getAdapter(IResource.class);
        }
        return resource;
    }

    private int getValidPosition(IDocument idoc, int editorLineNumber) {
        int result = -1;
        if (idoc != null) {
            int startOffset = 0;
            int endOffset = 0;
            try {
                IRegion line = idoc.getLineInformation(editorLineNumber - 1);
                startOffset = line.getOffset();
                endOffset = Math.max(line.getOffset(), line.getOffset() + line.getLength());
                String lineText = idoc.get(startOffset, endOffset - startOffset).trim();
                if (lineText.equals("") || lineText.equals("{") || lineText.equals("}") || lineText.equals("<%")) {
                    result = -1;
                } else {
                    ITypedRegion[] partitions = null;
                    partitions = idoc.computePartitioning(startOffset, endOffset - startOffset);
                    int i = 0;
                    while (i < partitions.length) {
                        String type = partitions[i].getType();
                        if (type == "org.eclipse.jst.jsp.SCRIPT.JAVA" || type == "org.eclipse.jst.jsp.JSP_DIRECTIVE" || type == "org.eclipse.jst.jsp.SCRIPT.JSP_EL" || type == "org.eclipse.jst.jsp.SCRIPT.JSP_EL2") {
                            result = partitions[i].getOffset();
                        }
                        ++i;
                    }
                }
            }
            catch (BadLocationException badLocationException) {
                result = -1;
            }
        }
        return result;
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        this.fData = data;
    }

    public void setSourceEditingTextTools(ISourceEditingTextTools tools) {
    }
}

