/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.jaxws.core.annotation.validation.tests;

import java.util.ArrayList;
import javax.jws.WebService;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jst.ws.annotations.core.AnnotationsCore;
import org.eclipse.jst.ws.annotations.core.utils.AnnotationUtils;
import org.eclipse.jst.ws.internal.jaxws.core.JAXWSCoreMessages;
import org.eclipse.jst.ws.jaxws.core.annotation.validation.tests.AbstractAnnotationValidationTest;
import org.eclipse.ltk.core.refactoring.Change;

public class WebServiceSEINoServiceNameRuleTest
extends AbstractAnnotationValidationTest {
    protected Annotation getAnnotation() {
        ArrayList<MemberValuePair> memberValuePairs = new ArrayList<MemberValuePair>();
        MemberValuePair nameValuePair = AnnotationsCore.createStringMemberValuePair((AST)this.ast, (String)"name", (String)"MyClass");
        MemberValuePair targetNamespaceValuePair = AnnotationsCore.createStringMemberValuePair((AST)this.ast, (String)"targetNamespace", (String)"http://example.com/");
        MemberValuePair serviceNameValuePair = AnnotationsCore.createStringMemberValuePair((AST)this.ast, (String)"serviceName", (String)"MyClassService");
        memberValuePairs.add(nameValuePair);
        memberValuePairs.add(targetNamespaceValuePair);
        memberValuePairs.add(serviceNameValuePair);
        return AnnotationsCore.createNormalAnnotation((AST)this.ast, (String)WebService.class.getSimpleName(), memberValuePairs);
    }

    protected String getClassContents() {
        StringBuilder classContents = new StringBuilder("package com.example;\n\n");
        classContents.append("public interface MyInterface {\n\n\tpublic String myeMethod();\n\n}");
        return classContents.toString();
    }

    protected String getClassName() {
        return "MyInterface.java";
    }

    protected String getPackageName() {
        return "com.example";
    }

    public void testWebServiceSEINoServiceNameRule() {
        try {
            WebServiceSEINoServiceNameRuleTest.assertNotNull((Object)this.annotation);
            WebServiceSEINoServiceNameRuleTest.assertEquals((String)WebService.class.getSimpleName(), (String)AnnotationUtils.getAnnotationName((Annotation)this.annotation));
            this.textFileChange.addEdit(AnnotationUtils.createAddImportTextEdit((IJavaElement)this.source.findPrimaryType(), (String)WebService.class.getCanonicalName()));
            this.textFileChange.addEdit(AnnotationUtils.createAddAnnotationTextEdit((IJavaElement)this.source.findPrimaryType(), (Annotation)this.annotation));
            WebServiceSEINoServiceNameRuleTest.assertTrue((boolean)this.executeChange((IProgressMonitor)new NullProgressMonitor(), (Change)this.textFileChange));
            WebServiceSEINoServiceNameRuleTest.assertTrue((boolean)AnnotationUtils.isAnnotationPresent((IJavaElement)this.source, (String)AnnotationUtils.getAnnotationName((Annotation)this.annotation)));
            WebServiceSEINoServiceNameRuleTest.assertTrue((boolean)this.source.getImport(WebService.class.getCanonicalName()).exists());
            Job.getJobManager().join(ResourcesPlugin.FAMILY_AUTO_BUILD, null);
            IMarker[] allmarkers = this.source.getResource().findMarkers("org.eclipse.core.resources.problemmarker", true, 2);
            WebServiceSEINoServiceNameRuleTest.assertEquals((int)1, (int)allmarkers.length);
            IMarker annotationProblemMarker = allmarkers[0];
            WebServiceSEINoServiceNameRuleTest.assertEquals((Object)this.source.getResource(), (Object)annotationProblemMarker.getResource());
            WebServiceSEINoServiceNameRuleTest.assertEquals((Object)JAXWSCoreMessages.WEBSERVICE_SERVICENAME_SEI, (Object)annotationProblemMarker.getAttribute("message"));
        }
        catch (CoreException ce) {
            WebServiceSEINoServiceNameRuleTest.fail((String)ce.getLocalizedMessage());
        }
        catch (OperationCanceledException oce) {
            WebServiceSEINoServiceNameRuleTest.fail((String)oce.getLocalizedMessage());
        }
        catch (InterruptedException ie) {
            WebServiceSEINoServiceNameRuleTest.fail((String)ie.getLocalizedMessage());
        }
    }
}

