/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.core.tests.cleanup;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import junit.framework.TestCase;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.core.internal.util.URIResolver;
import org.eclipse.wst.xml.core.internal.XMLCorePlugin;
import org.eclipse.wst.xml.core.internal.cleanup.CleanupProcessorXML;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;

public class TestCleanupProcessorXML
extends TestCase {
    private CleanupProcessorXML cleanup;

    protected void setUp() throws Exception {
        this.cleanup = new CleanupProcessorXML();
    }

    private IStructuredModel getModelForEdit(String filename) {
        IStructuredModel model = null;
        try {
            IModelManager modelManager = StructuredModelManager.getModelManager();
            InputStream inStream = ((Object)((Object)this)).getClass().getResourceAsStream(filename);
            if (inStream == null) {
                throw new FileNotFoundException("Can't file resource stream " + filename);
            }
            String baseFile = ((Object)((Object)this)).getClass().getResource(filename).toString();
            model = modelManager.getModelForEdit(baseFile, inStream, new URIResolver(baseFile){
                String fBase;
                {
                    this.fBase = string;
                }

                public String getFileBaseLocation() {
                    return this.fBase;
                }

                public String getLocationByURI(String uri) {
                    return this.getLocationByURI(uri, this.fBase);
                }

                public String getLocationByURI(String uri, boolean resolveCrossProjectLinks) {
                    return this.getLocationByURI(uri);
                }

                public String getLocationByURI(String uri, String baseReference) {
                    int lastSlash = baseReference.lastIndexOf("/");
                    if (lastSlash > 0) {
                        return String.valueOf(baseReference.substring(0, lastSlash + 1)) + uri;
                    }
                    return baseReference;
                }

                public String getLocationByURI(String uri, String baseReference, boolean resolveCrossProjectLinks) {
                    return this.getLocationByURI(uri, baseReference);
                }

                public IProject getProject() {
                    return null;
                }

                public IContainer getRootLocation() {
                    return null;
                }

                public InputStream getURIStream(String uri) {
                    return this.getClass().getResourceAsStream(this.getLocationByURI(uri));
                }

                public void setFileBaseLocation(String newLocation) {
                    this.fBase = newLocation;
                }

                public void setProject(IProject newProject) {
                }
            });
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return model;
    }

    public void testCleanupNoHeader() {
        String path = "testfiles/noheader.xml";
        IStructuredModel model = null;
        try {
            model = this.getModelForEdit(path);
            TestCleanupProcessorXML.assertNotNull((String)("Could not load model for [" + path + "]"), (Object)model);
            this.cleanup.getCleanupPreferences().setFormatSource(false);
            this.cleanup.cleanupModel(model);
            IndexedRegion region = model.getIndexedRegion(0);
            TestCleanupProcessorXML.assertTrue((String)"First region is not a node", (boolean)(region instanceof Node));
            Node node = (Node)region;
            TestCleanupProcessorXML.assertTrue((String)"First region is not a processing instruction", (node.getNodeType() == 7 ? 1 : 0) != 0);
            ProcessingInstruction pi = (ProcessingInstruction)node;
            TestCleanupProcessorXML.assertEquals((String)"Node is not an XML declaration", (String)"xml", (String)pi.getTarget());
            String encoding = XMLCorePlugin.getDefault().getPluginPreferences().getString("outputCodeset");
            TestCleanupProcessorXML.assertEquals((String)("version=\"1.0\" encoding=\"" + encoding + "\""), (String)pi.getData());
        }
        finally {
            if (model != null) {
                model.releaseFromEdit();
            }
        }
    }

    public void testCleanupFixDeclaration() {
        String path = "testfiles/fixdecl.xml";
        IStructuredModel model = null;
        try {
            model = this.getModelForEdit(path);
            TestCleanupProcessorXML.assertNotNull((String)("Could not load model for [" + path + "]"), (Object)model);
            this.cleanup.getCleanupPreferences().setFormatSource(false);
            this.cleanup.cleanupModel(model);
            IndexedRegion region = model.getIndexedRegion(0);
            TestCleanupProcessorXML.assertTrue((String)"First region is not a node", (boolean)(region instanceof Node));
            Node node = (Node)region;
            TestCleanupProcessorXML.assertTrue((String)"First region is not a processing instruction", (node.getNodeType() == 7 ? 1 : 0) != 0);
            ProcessingInstruction pi = (ProcessingInstruction)node;
            TestCleanupProcessorXML.assertEquals((String)"Node is not an XML declaration", (String)"xml", (String)pi.getTarget());
            TestCleanupProcessorXML.assertEquals((String)"version=\"1.0\" encoding=\"ISO-8859-1\"", (String)pi.getData());
        }
        finally {
            if (model != null) {
                model.releaseFromEdit();
            }
        }
    }
}

