/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.jaxws.dom.runtime.tests.dom.util;

import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jst.ws.jaxws.dom.runtime.DomUtil;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.DomFactory;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.DomPackage;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.IServiceEndpointInterface;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.IWebMethod;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.IWebParam;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.IWebService;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.IWebServiceProject;
import org.eclipse.jst.ws.jaxws.testutils.jmock.Mock;
import org.eclipse.jst.ws.jaxws.testutils.jmock.MockObjectTestCase;

public class DomUtilTest
extends MockObjectTestCase {
    private DomUtil util;

    public void setUp() {
        this.util = new DomUtil();
    }

    public void testIsOutideInWebService() {
        Mock ws = this.mock(IWebService.class);
        ws.stubs().method("getWsdlLocation").will(this.returnValue("C:/test/wsdl/location"));
        Mock sei = this.mock(IServiceEndpointInterface.class);
        BasicEList implemetingWs = new BasicEList();
        implemetingWs.add((Object)((IWebService)ws.proxy()));
        sei.stubs().method("getImplementingWebServices").will(this.returnValue(implemetingWs));
        DomUtilTest.assertTrue((boolean)this.util.isOutsideInWebService((IServiceEndpointInterface)sei.proxy()));
        ws.stubs().method("getWsdlLocation").will(this.returnValue(null));
        DomUtilTest.assertFalse((boolean)this.util.isOutsideInWebService((IServiceEndpointInterface)sei.proxy()));
    }

    public void testFindWsProject() {
        IWebServiceProject wsProject = DomFactory.eINSTANCE.createIWebServiceProject();
        IServiceEndpointInterface sei = DomFactory.eINSTANCE.createIServiceEndpointInterface();
        IWebMethod method = DomFactory.eINSTANCE.createIWebMethod();
        sei.getWebMethods().add((Object)method);
        wsProject.getServiceEndpointInterfaces().add((Object)sei);
        DomUtilTest.assertEquals((Object)wsProject, (Object)this.util.findWsProject((EObject)method));
    }

    public void testCalcUniqueImpl() {
        IWebMethod method = DomFactory.eINSTANCE.createIWebMethod();
        method.eSet((EStructuralFeature)DomPackage.Literals.IJAVA_WEB_SERVICE_ELEMENT__IMPLEMENTATION, (Object)"method(I)");
        IWebParam param = DomFactory.eINSTANCE.createIWebParam();
        param.eSet((EStructuralFeature)DomPackage.Literals.IJAVA_WEB_SERVICE_ELEMENT__IMPLEMENTATION, (Object)"a");
        method.getParameters().add((Object)param);
        DomUtilTest.assertEquals((String)"method(I)", (String)this.util.calcUniqueImpl((EObject)method));
        DomUtilTest.assertEquals((String)"method(I)[a]", (String)this.util.calcUniqueImpl((EObject)param));
    }
}

