/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.validation.el.tests.jsp;

import java.util.List;
import org.eclipse.jst.jsf.core.JSFVersion;
import org.eclipse.jst.jsf.core.tests.validation.MockValidationReporter;
import org.eclipse.jst.jsf.validation.el.tests.base.ELAssert;
import org.eclipse.jst.jsf.validation.el.tests.base.SingleJSPTestCase;

public class UnaryMinusTestCase
extends SingleJSPTestCase {
    public UnaryMinusTestCase() {
        super("/testdata/jsps/unaryMinus.jsp.data", "/unaryMinus.jsp", JSFVersion.V1_1, "/testdata/web/faces-config_1_1.xml.data");
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    public void testSanity() {
        UnaryMinusTestCase.assertEquals((String)"-myBean.integerProperty", (String)ELAssert.getELText(this._structuredDocument, 828));
        UnaryMinusTestCase.assertEquals((String)"-myBean.doubleProperty", (String)ELAssert.getELText(this._structuredDocument, 881));
        UnaryMinusTestCase.assertEquals((String)"-myBean.bigDoubleProperty", (String)ELAssert.getELText(this._structuredDocument, 933));
        UnaryMinusTestCase.assertEquals((String)"-myBean.bigIntegerProperty", (String)ELAssert.getELText(this._structuredDocument, 988));
        UnaryMinusTestCase.assertEquals((String)"-5", (String)ELAssert.getELText(this._structuredDocument, 1127));
        UnaryMinusTestCase.assertEquals((String)"-5.5", (String)ELAssert.getELText(this._structuredDocument, 1162));
        UnaryMinusTestCase.assertEquals((String)"-'5'", (String)ELAssert.getELText(this._structuredDocument, 1199));
        UnaryMinusTestCase.assertEquals((String)"-'5.5'", (String)ELAssert.getELText(this._structuredDocument, 1236));
        UnaryMinusTestCase.assertEquals((String)"-myBean.stringProperty", (String)ELAssert.getELText(this._structuredDocument, 1072));
        UnaryMinusTestCase.assertEquals((String)"-null", (String)ELAssert.getELText(this._structuredDocument, 1275));
        UnaryMinusTestCase.assertEquals((String)"-false", (String)ELAssert.getELText(this._structuredDocument, 1332));
        UnaryMinusTestCase.assertEquals((String)"-true", (String)ELAssert.getELText(this._structuredDocument, 1368));
        UnaryMinusTestCase.assertEquals((String)"-myBean.booleanProperty", (String)ELAssert.getELText(this._structuredDocument, 1403));
        UnaryMinusTestCase.assertEquals((String)"-myBean.collectionProperty", (String)ELAssert.getELText(this._structuredDocument, 1456));
        UnaryMinusTestCase.assertEquals((String)"-myBean.mapProperty", (String)ELAssert.getELText(this._structuredDocument, 1512));
        UnaryMinusTestCase.assertEquals((String)"-myBean.stringArrayProperty", (String)ELAssert.getELText(this._structuredDocument, 1561));
        UnaryMinusTestCase.assertEquals((String)"-'notANumber'", (String)ELAssert.getELText(this._structuredDocument, 1618));
    }

    public void testNoErrorExprs() {
        this.assertNoError(828, "I");
        this.assertNoError(881, "D");
        this.assertNoError(933, "Ljava.math.BigDecimal;");
        this.assertNoError(988, "Ljava.math.BigInteger;");
        this.assertNoError(1127, "J");
        this.assertNoError(1162, "D");
        this.assertNoError(1199, "J");
        this.assertNoError(1236, "D");
    }

    public void testWarningExprs() {
        List<MockValidationReporter.ReportedProblem> list = this.assertSemanticWarning(1072, "J", 1);
        ELAssert.assertContainsProblem(list, 17);
        list = this.assertSemanticWarning(1275, "J", 1);
        ELAssert.assertContainsProblem(list, 12);
    }

    public void testErrorExprs() {
        List<MockValidationReporter.ReportedProblem> list = this.assertSemanticError(1332, null, 1);
        ELAssert.assertContainsProblem(list, 13);
        list = this.assertSemanticError(1368, null, 1);
        ELAssert.assertContainsProblem(list, 13);
        list = this.assertSemanticError(1403, null, 1);
        ELAssert.assertContainsProblem(list, 13);
        list = this.assertSemanticError(1456, null, 1);
        ELAssert.assertContainsProblem(list, 13);
        list = this.assertSemanticError(1512, null, 1);
        ELAssert.assertContainsProblem(list, 13);
        list = this.assertSemanticError(1561, null, 1);
        ELAssert.assertContainsProblem(list, 13);
        list = this.assertSemanticError(1618, null, 1);
        ELAssert.assertContainsProblem(list, 13);
    }
}

