/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.html.ui.tests.contentassist;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import junit.extensions.TestSetup;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.wst.html.ui.StructuredTextViewerConfigurationHTML;
import org.eclipse.wst.html.ui.internal.contentassist.resources.AbstractWebResourcesCompletionProposalComputer;
import org.eclipse.wst.html.ui.internal.contentassist.resources.CSSWebResourcesCompletionProposalComputer;
import org.eclipse.wst.html.ui.internal.contentassist.resources.HrefWebResourcesCompletionProposalComputer;
import org.eclipse.wst.html.ui.internal.contentassist.resources.ImageWebResourcesCompletionProposalComputer;
import org.eclipse.wst.html.ui.internal.contentassist.resources.ScriptWebResourcesCompletionProposalComputer;
import org.eclipse.wst.html.ui.tests.ProjectUtil;
import org.eclipse.wst.sse.core.utils.StringUtils;
import org.eclipse.wst.sse.ui.StructuredTextEditor;
import org.eclipse.wst.sse.ui.internal.StructuredTextViewer;

public class TestHTMLContentAssistComputers
extends TestCase {
    private static final String PROJECT_NAME = "TestHTMLContentAssistComputers";
    private static final String JAVA_SCRIPT_NATURE_ID = "org.eclipse.wst.jsdt.core.jsNature";
    private static final String PROJECT_FILES = "/testresources/contentassist";
    static IProject fProject;
    static Map<IFile, StructuredTextEditor> fFileToEditorMap;

    static {
        fFileToEditorMap = new HashMap<IFile, StructuredTextEditor>();
    }

    public TestHTMLContentAssistComputers() {
        super("Test HTML Content Assist Computers");
    }

    public TestHTMLContentAssistComputers(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite ts = new TestSuite(TestHTMLContentAssistComputers.class, "Test HTML Content Assist Computers");
        return new TestHTMLContentAssistComputersSetup((Test)ts);
    }

    public void testEmptyDocument() throws Exception {
        int[] nArray = new int[6];
        nArray[0] = 7;
        nArray[1] = 6;
        nArray[2] = 1;
        nArray[5] = 7;
        int[] expectedProposalCounts = nArray;
        TestHTMLContentAssistComputers.runProposalTest("test0.html", 0, 0, expectedProposalCounts);
    }

    public void testAfterDocTypeBeforeHTMLTagProposals() throws Exception {
        int[] nArray = new int[6];
        nArray[0] = 8;
        nArray[1] = 8;
        nArray[5] = 8;
        int[] expectedProposalCounts = nArray;
        TestHTMLContentAssistComputers.runProposalTest("test1.html", 1, 0, expectedProposalCounts);
    }

    public void testAfterDocTypeBeforeEmptyDocProposals() throws Exception {
        int[] nArray = new int[6];
        nArray[0] = 9;
        nArray[1] = 8;
        nArray[2] = 1;
        nArray[5] = 9;
        int[] expectedProposalCounts = nArray;
        TestHTMLContentAssistComputers.runProposalTest("test2.html", 1, 0, expectedProposalCounts);
    }

    public void testBodyTagChildElementProposals() throws Exception {
        int[] nArray = new int[6];
        nArray[0] = 78;
        nArray[1] = 8;
        nArray[2] = 70;
        nArray[5] = 78;
        int[] expectedProposalCounts = nArray;
        TestHTMLContentAssistComputers.runProposalTest("test1.html", 8, 0, expectedProposalCounts);
    }

    public void testPTagChildElementProposals() throws Exception {
        int[] nArray = new int[6];
        nArray[0] = 54;
        nArray[1] = 8;
        nArray[2] = 46;
        nArray[5] = 54;
        int[] expectedProposalCounts = nArray;
        TestHTMLContentAssistComputers.runProposalTest("test1.html", 14, 0, expectedProposalCounts);
    }

    public void testDIVTagChildElementProposals() throws Exception {
        int[] nArray = new int[6];
        nArray[0] = 78;
        nArray[1] = 8;
        nArray[2] = 70;
        nArray[5] = 78;
        int[] expectedProposalCounts = nArray;
        TestHTMLContentAssistComputers.runProposalTest("test1.html", 18, 0, expectedProposalCounts);
    }

    public void testDIVTagAttributeNameProposals() throws Exception {
        int[] nArray = new int[6];
        nArray[0] = 18;
        nArray[2] = 18;
        nArray[5] = 18;
        int[] expectedProposalCounts = nArray;
        TestHTMLContentAssistComputers.runProposalTest("test1.html", 17, 5, expectedProposalCounts);
    }

    public void testFinishClosingTagNameProposals() throws Exception {
        int[] nArray = new int[6];
        nArray[0] = 1;
        nArray[2] = 1;
        nArray[5] = 1;
        int[] expectedProposalCounts = nArray;
        TestHTMLContentAssistComputers.runProposalTest("test4.html", 9, 9, expectedProposalCounts);
    }

    public void testFinishClosingTagProposals() throws Exception {
        int[] nArray = new int[6];
        nArray[0] = 2;
        nArray[2] = 2;
        nArray[5] = 2;
        int[] expectedProposalCounts = nArray;
        TestHTMLContentAssistComputers.runProposalTest("test4.html", 10, 0, expectedProposalCounts);
    }

    public void testFinishClosingTagNameProposalsXHTML() throws Exception {
        int[] nArray = new int[6];
        nArray[0] = 1;
        nArray[2] = 1;
        nArray[5] = 1;
        int[] expectedProposalCounts = nArray;
        TestHTMLContentAssistComputers.runProposalTest("test5.xhtml", 9, 9, expectedProposalCounts);
    }

    public void testFinishClosingTagProposalsXHTML() throws Exception {
        int[] nArray = new int[6];
        nArray[0] = 1;
        nArray[2] = 2;
        nArray[5] = 2;
        int[] expectedProposalCounts = nArray;
        TestHTMLContentAssistComputers.runProposalTest("test5.xhtml", 10, 0, expectedProposalCounts);
    }

    public void testResourceProposalsForAHref() throws Exception {
        IFile referencePoint = fProject.getFile("testResources.html");
        HrefWebResourcesCompletionProposalComputer proposalComputer = new HrefWebResourcesCompletionProposalComputer();
        Method findMatchingPaths = AbstractWebResourcesCompletionProposalComputer.class.getDeclaredMethod("findMatchingPaths", IResource.class);
        TestHTMLContentAssistComputers.assertNotNull((String)"findMatchingPaths", (Object)findMatchingPaths);
        findMatchingPaths.setAccessible(true);
        IPath[] paths = (IPath[])findMatchingPaths.invoke((Object)proposalComputer, referencePoint);
        TestHTMLContentAssistComputers.assertNotNull((String)"paths", (Object)paths);
        String[] strings = new String[paths.length];
        int i = 0;
        while (i < strings.length) {
            strings[i] = paths[i].toString();
            ++i;
        }
        TestHTMLContentAssistComputers.assertTrue((String)String.valueOf(paths.length).concat(StringUtils.pack((String[])strings)), (paths.length >= 6 ? 1 : 0) != 0);
        TestHTMLContentAssistComputers.assertTrue((String)StringUtils.pack((String[])strings), (boolean)Arrays.asList(paths).stream().map(proposedPath -> proposedPath.toString()).anyMatch(pathAsString -> pathAsString.endsWith("/alsoempty.css")));
        TestHTMLContentAssistComputers.assertTrue((String)StringUtils.pack((String[])strings), (boolean)Arrays.asList(paths).stream().map(proposedPath -> proposedPath.toString()).anyMatch(pathAsString -> pathAsString.endsWith("/alsoempty.js")));
        TestHTMLContentAssistComputers.assertTrue((String)StringUtils.pack((String[])strings), (boolean)Arrays.asList(paths).stream().map(proposedPath -> proposedPath.toString()).anyMatch(pathAsString -> pathAsString.endsWith("/alsoempty.txt")));
        TestHTMLContentAssistComputers.assertTrue((String)StringUtils.pack((String[])strings), (boolean)Arrays.asList(paths).stream().map(proposedPath -> proposedPath.toString()).anyMatch(pathAsString -> pathAsString.endsWith("/empty.css")));
        TestHTMLContentAssistComputers.assertTrue((String)StringUtils.pack((String[])strings), (boolean)Arrays.asList(paths).stream().map(proposedPath -> proposedPath.toString()).anyMatch(pathAsString -> pathAsString.endsWith("/empty.js")));
        TestHTMLContentAssistComputers.assertTrue((String)StringUtils.pack((String[])strings), (boolean)Arrays.asList(paths).stream().map(proposedPath -> proposedPath.toString()).anyMatch(pathAsString -> pathAsString.endsWith("/empty.txt")));
    }

    public void testResourceProposalsForImgSrc() throws Exception {
        IFile referenceFile = fProject.getFile("testResources.html");
        ImageWebResourcesCompletionProposalComputer proposalComputer = new ImageWebResourcesCompletionProposalComputer();
        Method findMatchingPaths = AbstractWebResourcesCompletionProposalComputer.class.getDeclaredMethod("findMatchingPaths", IResource.class);
        TestHTMLContentAssistComputers.assertNotNull((String)"findMatchingPaths", (Object)findMatchingPaths);
        findMatchingPaths.setAccessible(true);
        IPath[] paths = (IPath[])findMatchingPaths.invoke((Object)proposalComputer, referenceFile);
        TestHTMLContentAssistComputers.assertNotNull((String)"paths", (Object)paths);
        String[] strings = new String[paths.length];
        int i = 0;
        while (i < strings.length) {
            strings[i] = paths[i].toString();
            ++i;
        }
        TestHTMLContentAssistComputers.assertEquals((String)String.valueOf(paths.length).concat(StringUtils.pack((String[])strings)), (int)3, (int)paths.length);
        TestHTMLContentAssistComputers.assertTrue((boolean)Arrays.asList(paths).stream().map(proposedPath -> proposedPath.toString()).anyMatch(pathAsString -> pathAsString.equals("/TestHTMLContentAssistComputers/targets/alsoempty.png")));
        TestHTMLContentAssistComputers.assertTrue((boolean)Arrays.asList(paths).stream().map(proposedPath -> proposedPath.toString()).anyMatch(pathAsString -> pathAsString.equals("/TestHTMLContentAssistComputers/targets/empty.gif")));
        TestHTMLContentAssistComputers.assertTrue((boolean)Arrays.asList(paths).stream().map(proposedPath -> proposedPath.toString()).anyMatch(pathAsString -> pathAsString.equals("/TestHTMLContentAssistComputers/targets/empty.png")));
    }

    public void testResourceProposalsForLinkHref() throws Exception {
        IFile referencePoint = fProject.getFile("testResources.html");
        CSSWebResourcesCompletionProposalComputer proposalComputer = new CSSWebResourcesCompletionProposalComputer();
        Method findMatchingPaths = AbstractWebResourcesCompletionProposalComputer.class.getDeclaredMethod("findMatchingPaths", IResource.class);
        TestHTMLContentAssistComputers.assertNotNull((String)"findMatchingPaths", (Object)findMatchingPaths);
        findMatchingPaths.setAccessible(true);
        IPath[] paths = (IPath[])findMatchingPaths.invoke((Object)proposalComputer, referencePoint);
        TestHTMLContentAssistComputers.assertNotNull((String)"paths", (Object)paths);
        String[] strings = new String[paths.length];
        int i = 0;
        while (i < strings.length) {
            strings[i] = paths[i].toString();
            ++i;
        }
        TestHTMLContentAssistComputers.assertEquals((String)String.valueOf(paths.length).concat(StringUtils.pack((String[])strings)), (int)2, (int)paths.length);
        TestHTMLContentAssistComputers.assertTrue((boolean)Arrays.asList(paths).stream().map(proposedPath -> proposedPath.toString()).anyMatch(pathAsString -> pathAsString.endsWith("/alsoempty.css")));
        TestHTMLContentAssistComputers.assertTrue((boolean)Arrays.asList(paths).stream().map(proposedPath -> proposedPath.toString()).anyMatch(pathAsString -> pathAsString.endsWith("/empty.css")));
    }

    public void testResourceProposalsForScriptSrc() throws Exception {
        IFile referencePoint = fProject.getFile("testResources.html");
        ScriptWebResourcesCompletionProposalComputer proposalComputer = new ScriptWebResourcesCompletionProposalComputer();
        Method findMatchingPaths = AbstractWebResourcesCompletionProposalComputer.class.getDeclaredMethod("findMatchingPaths", IResource.class);
        TestHTMLContentAssistComputers.assertNotNull((String)"findMatchingPaths", (Object)findMatchingPaths);
        findMatchingPaths.setAccessible(true);
        IPath[] paths = (IPath[])findMatchingPaths.invoke((Object)proposalComputer, referencePoint);
        TestHTMLContentAssistComputers.assertNotNull((String)"paths", (Object)paths);
        String[] strings = new String[paths.length];
        int i = 0;
        while (i < strings.length) {
            strings[i] = paths[i].toString();
            ++i;
        }
        TestHTMLContentAssistComputers.assertEquals((String)String.valueOf(paths.length).concat(StringUtils.pack((String[])strings)), (int)2, (int)paths.length);
        TestHTMLContentAssistComputers.assertTrue((boolean)Arrays.asList(paths).stream().map(proposedPath -> proposedPath.toString()).anyMatch(pathAsString -> pathAsString.endsWith("/alsoempty.js")));
        TestHTMLContentAssistComputers.assertTrue((boolean)Arrays.asList(paths).stream().map(proposedPath -> proposedPath.toString()).anyMatch(pathAsString -> pathAsString.endsWith("/empty.js")));
    }

    private static ICompletionProposal[][] runProposalTest(String fileName, int lineNum, int lineRelativeCharOffset, int[] expectedProposalCounts) throws Exception {
        IFile file = TestHTMLContentAssistComputers.getFile(fileName);
        StructuredTextEditor editor = TestHTMLContentAssistComputers.getEditor(file);
        StructuredTextViewer viewer = editor.getTextViewer();
        int offset = editor.getDocumentProvider().getDocument((Object)editor.getEditorInput()).getLineOffset(lineNum) + lineRelativeCharOffset;
        ICompletionProposal[][] pages = TestHTMLContentAssistComputers.getProposals(viewer, offset, expectedProposalCounts.length);
        TestHTMLContentAssistComputers.verifyProposalCounts(pages, expectedProposalCounts);
        return pages;
    }

    private static ICompletionProposal[][] getProposals(StructuredTextViewer viewer, int offset, int pageCount) throws Exception {
        StructuredTextViewerConfigurationHTML configuration = new StructuredTextViewerConfigurationHTML();
        ContentAssistant contentAssistant = (ContentAssistant)configuration.getContentAssistant((ISourceViewer)viewer);
        viewer.configure((SourceViewerConfiguration)configuration);
        viewer.setSelectedRange(offset, 0);
        String partitionTypeID = viewer.getDocument().getPartition(offset).getType();
        TestHTMLContentAssistComputers.assertEquals((String)"partition type", (String)"org.eclipse.wst.html.HTML_DEFAULT", (String)partitionTypeID);
        IContentAssistProcessor processor = contentAssistant.getContentAssistProcessor(partitionTypeID);
        Method privateFireSessionBeginEventMethod = ContentAssistant.class.getDeclaredMethod("fireSessionBeginEvent", Boolean.TYPE);
        privateFireSessionBeginEventMethod.setAccessible(true);
        privateFireSessionBeginEventMethod.invoke((Object)contentAssistant, Boolean.TRUE);
        ICompletionProposal[][] pages = new ICompletionProposal[pageCount][];
        int p = 0;
        while (p < pageCount) {
            pages[p] = processor.computeCompletionProposals((ITextViewer)viewer, offset);
            ++p;
        }
        Method privateFireSessionEndEventMethod = ContentAssistant.class.getDeclaredMethod("fireSessionEndEvent", new Class[0]);
        privateFireSessionEndEventMethod.setAccessible(true);
        privateFireSessionEndEventMethod.invoke((Object)contentAssistant, new Object[0]);
        return pages;
    }

    private static void verifyProposalCounts(ICompletionProposal[][] pages, int[] expectedProposalCounts) {
        StringBuffer error = new StringBuffer();
        int page = 0;
        while (page < expectedProposalCounts.length) {
            if (expectedProposalCounts[page] > pages[page].length) {
                error.append("\nProposal page " + page + " is missing proposals: was " + pages[page].length + " expected " + expectedProposalCounts[page]);
            }
            ++page;
        }
        if (error.length() > 0) {
            TestHTMLContentAssistComputers.fail((String)error.toString());
        }
    }

    private static IFile getFile(String name) {
        IFile file = fProject.getFile(name);
        TestHTMLContentAssistComputers.assertTrue((String)("Test file " + file + " can not be found"), (boolean)file.exists());
        return file;
    }

    private static StructuredTextEditor getEditor(IFile file) {
        StructuredTextEditor editor = fFileToEditorMap.get(file);
        if (editor == null) {
            try {
                IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                IWorkbenchPage page = workbenchWindow.getActivePage();
                IEditorPart editorPart = IDE.openEditor((IWorkbenchPage)page, (IFile)file, (String)"org.eclipse.wst.html.core.htmlsource.source", (boolean)true);
                if (editorPart instanceof MultiPageEditorPart) {
                    MultiPageEditorPart mpEditorPart = (MultiPageEditorPart)editorPart;
                    editor = (StructuredTextEditor)mpEditorPart.getAdapter(StructuredTextEditor.class);
                } else if (editorPart instanceof StructuredTextEditor) {
                    editor = (StructuredTextEditor)editorPart;
                } else {
                    TestHTMLContentAssistComputers.fail((String)("Unable to open structured text editor: " + editorPart.getClass().getName()));
                }
                if (editor != null) {
                    TestHTMLContentAssistComputers.standardizeLineEndings(editor);
                    fFileToEditorMap.put(file, editor);
                } else {
                    TestHTMLContentAssistComputers.fail((String)("Could not open editor for " + file));
                }
            }
            catch (Exception e) {
                TestHTMLContentAssistComputers.fail((String)("Could not open editor for " + file + " exception: " + e.getMessage()));
            }
        }
        return editor;
    }

    private static void standardizeLineEndings(StructuredTextEditor editor) {
        IDocument doc = editor.getTextViewer().getDocument();
        String contents = doc.get();
        contents = StringUtils.replace((String)contents, (String)"\r\n", (String)"\n");
        contents = StringUtils.replace((String)contents, (String)"\r", (String)"\n");
        doc.set(contents);
    }

    private static class TestHTMLContentAssistComputersSetup
    extends TestSetup {
        private static final String WTP_AUTOTEST_NONINTERACTIVE = "wtp.autotest.noninteractive";
        private static String previousWTPAutoTestNonInteractivePropValue = null;

        public TestHTMLContentAssistComputersSetup(Test test) {
            super(test);
        }

        public void setUp() throws Exception {
            String noninteractive = System.getProperty(WTP_AUTOTEST_NONINTERACTIVE);
            previousWTPAutoTestNonInteractivePropValue = noninteractive != null ? noninteractive : "false";
            System.setProperty(WTP_AUTOTEST_NONINTERACTIVE, "true");
            fProject = ProjectUtil.createProject(TestHTMLContentAssistComputers.PROJECT_NAME, null, new String[]{TestHTMLContentAssistComputers.JAVA_SCRIPT_NATURE_ID});
            ProjectUtil.copyBundleEntriesIntoWorkspace(TestHTMLContentAssistComputers.PROJECT_FILES, TestHTMLContentAssistComputers.PROJECT_NAME);
        }

        public void tearDown() throws Exception {
            for (StructuredTextEditor editor : fFileToEditorMap.values()) {
                editor.doSave(null);
                editor.close(false);
            }
            if (previousWTPAutoTestNonInteractivePropValue != null) {
                System.setProperty(WTP_AUTOTEST_NONINTERACTIVE, previousWTPAutoTestNonInteractivePropValue);
            }
        }
    }
}

