/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.validation.tests.testcase;

import java.io.UnsupportedEncodingException;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.wst.validation.ValidationFramework;
import org.eclipse.wst.validation.ValidationResults;
import org.eclipse.wst.validation.internal.Tracing;
import org.eclipse.wst.validation.tests.testcase.TestEnvironment;

public class TestSuite9
extends TestCase {
    private TestEnvironment _env;
    private IProject _project;

    public static Test suite() {
        return new TestSuite(TestSuite9.class);
    }

    public TestSuite9(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this._env = new TestEnvironment();
        this._project = this._env.createProject("TestSuite9");
        IPath first = this._env.addFolder(this._project.getFullPath(), "first");
        IFile file = this._env.addFile(first, "test.xml", "<?xml version='1.0' encoding='UTF-8'?><root>");
        file.setDerived(true);
        TestEnvironment.enableOnlyThisValidator("org.eclipse.wst.xml.core.internal.validation.eclipse.Validator");
    }

    protected void tearDown() throws Exception {
        this._project.delete(true, null);
        this._env.dispose();
        super.tearDown();
    }

    public void testIgnoresDerivedResources() throws CoreException, UnsupportedEncodingException, InterruptedException {
        Tracing.log((String)"TestSuite9-01: testIgnoresDerivedResources starting");
        NullProgressMonitor monitor = new NullProgressMonitor();
        ValidationFramework vf = ValidationFramework.getDefault();
        IProject[] projects = new IProject[]{this._project};
        ValidationResults vr = vf.validate(projects, true, false, (IProgressMonitor)monitor);
        int errors = vr.getSeverityError();
        TestSuite9.assertEquals((String)"Number of errors", (int)0, (int)errors);
        Tracing.log((String)"TestSuite9-02: testIgnoresDerivedResources finished");
    }
}

