/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.jaxws.dom.runtime.tests.dom.persistence;

import java.io.IOException;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.IWsDomLoadListener;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.WsDOMLoadCanceledException;
import org.eclipse.jst.ws.jaxws.dom.runtime.persistence.JaxWsWorkspaceResource;
import org.eclipse.jst.ws.jaxws.dom.runtime.persistence.Jee5WsDomRuntimeExtension;
import org.eclipse.jst.ws.jaxws.testutils.IWaitCondition;
import org.eclipse.jst.ws.jaxws.testutils.assertions.Assertions;
import org.eclipse.jst.ws.jaxws.testutils.jmock.Mock;
import org.eclipse.jst.ws.jaxws.testutils.jmock.MockObjectTestCase;

public class Jee5WsDomRuntimeExtensionTest
extends MockObjectTestCase {
    private Jee5WsDomRuntimeExtension extension;

    public void setUp() throws Exception {
        this.extension = new Jee5WsDomRuntimeExtension();
    }

    public void testGetDOMCreateNotCalled() throws WsDOMLoadCanceledException {
        Jee5WsDomRuntimeExtensionTest.assertNull((Object)this.extension.getDOM());
    }

    public void testLoadListenerStartFinishCalled() throws Exception {
        Mock loadListenerMock = this.mock(IWsDomLoadListener.class);
        loadListenerMock.expects(this.once()).method("started");
        loadListenerMock.expects(this.once()).method("finished");
        this.extension.addLoadListener((IWsDomLoadListener)loadListenerMock.proxy());
        this.extension.createDOM(null);
    }

    public void testRemoveLoadListener() throws Exception {
        IWsDomLoadListener loadListener = (IWsDomLoadListener)this.mock(IWsDomLoadListener.class).proxy();
        this.extension.addLoadListener(loadListener);
        this.extension.removeLoadListener(loadListener);
        this.extension.createDOM(null);
    }

    public void testLoadCanceled() throws Exception {
        NullProgressMonitor monitor = new NullProgressMonitor();
        monitor.setCanceled(true);
        Mock loadListenerMock = this.mock(IWsDomLoadListener.class);
        loadListenerMock.expects(this.once()).method("started");
        loadListenerMock.expects(this.once()).method("finished");
        this.extension = new Jee5WsDomRuntimeExtension(){

            protected JaxWsWorkspaceResource createResource() {
                return new JaxWsWorkspaceResource(this.javaModel()){

                    public boolean isLoadCnaceled() {
                        return true;
                    }

                    public void startSynchronizing() {
                        Jee5WsDomRuntimeExtensionTest.fail((String)"startSynchronizing should not be called in this case");
                    }
                };
            }
        };
        this.extension.addLoadListener((IWsDomLoadListener)loadListenerMock.proxy());
        try {
            this.extension.createDOM((IProgressMonitor)monitor);
            Jee5WsDomRuntimeExtensionTest.fail((String)"WsDOMLoadCanceledException not thrown az expected");
        }
        catch (WsDOMLoadCanceledException wsDOMLoadCanceledException) {}
    }

    public void testStartSynchronizingCalledIfLoadNotCanceled() throws Exception {
        final boolean[] startSyncCalled = new boolean[1];
        this.extension = new Jee5WsDomRuntimeExtension(){

            protected JaxWsWorkspaceResource createResource() {
                return new JaxWsWorkspaceResource(this.javaModel()){

                    public void startSynchronizing() {
                        startSyncCalled[0] = true;
                    }
                };
            }
        };
        this.extension.createDOM((IProgressMonitor)new NullProgressMonitor());
        Jee5WsDomRuntimeExtensionTest.assertTrue((String)"Start syncronization was not started even the load wasa not canceled", (boolean)startSyncCalled[0]);
    }

    public void testCreateDOMBlocksWhenCalled() throws Exception {
        final boolean[] doLoadStarted = new boolean[1];
        final boolean[] doLoadFinished = new boolean[1];
        this.extension = new Jee5WsDomRuntimeExtension(){

            protected JaxWsWorkspaceResource createResource() {
                return new JaxWsWorkspaceResource(this.javaModel()){

                    protected void doLoad(Map<?, ?> options) throws IOException {
                        doLoadStarted[0] = true;
                        try {
                            Thread.sleep(400L);
                        }
                        catch (InterruptedException e) {
                            throw new IOException(e.getLocalizedMessage());
                        }
                        super.doLoad(options);
                        doLoadFinished[0] = true;
                    }
                };
            }
        };
        new Thread(){

            public void run() {
                try {
                    Jee5WsDomRuntimeExtensionTest.this.extension.createDOM((IProgressMonitor)new NullProgressMonitor());
                }
                catch (IOException e) {
                    Jee5WsDomRuntimeExtensionTest.fail((String)e.getMessage());
                }
                catch (WsDOMLoadCanceledException e) {
                    Jee5WsDomRuntimeExtensionTest.fail((String)e.getMessage());
                }
            }
        }.start();
        Assertions.waitAssert((IWaitCondition)new IWaitCondition(){

            public boolean checkCondition() {
                return doLoadStarted[0];
            }
        }, (String)"Loading from another thread not started");
        this.extension.createDOM((IProgressMonitor)new NullProgressMonitor());
        Jee5WsDomRuntimeExtensionTest.assertTrue((String)"Start syncronization was not started even the load was not canceled", (boolean)doLoadFinished[0]);
    }
}

