/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.validation.el.tests.jsp;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;
import org.eclipse.jst.jsf.core.JSFVersion;
import org.eclipse.jst.jsf.core.tests.validation.MockValidationReporter;
import org.eclipse.jst.jsf.test.util.TestFileResource;
import org.eclipse.jst.jsf.validation.el.tests.ELValidationTestPlugin;
import org.eclipse.jst.jsf.validation.el.tests.base.ELAssert;
import org.eclipse.jst.jsf.validation.el.tests.base.SingleJSPTestCase;

public class ResourceBundleTestCase
extends SingleJSPTestCase {
    public ResourceBundleTestCase() {
        super("/testdata/jsps/resourceBundleResolution.jsp.data", "/resourceBundle.jsp", JSFVersion.V1_2, "/testdata/web/faces-config_1_2.xml.data");
    }

    protected void doStandaloneSetup() {
        super.doStandaloneSetup();
    }

    protected void setUp() throws Exception {
        super.setUp();
        TestFileResource resource = new TestFileResource();
        resource.load(ELValidationTestPlugin.getDefault().getBundle(), "/testdata/classes/Bundle.properties.data");
        this._jdtTestEnv.addResourceFile("src", (InputStream)new ByteArrayInputStream(resource.toBytes()), "", "Bundle.properties");
        resource = new TestFileResource();
        resource.load(ELValidationTestPlugin.getDefault().getBundle(), "/testdata/classes/Bundle2.properties.data");
        this._jdtTestEnv.addResourceFile("src", (InputStream)new ByteArrayInputStream(resource.toBytes()), "beans", "Bundle2.properties");
    }

    public void testSanity() {
        ResourceBundleTestCase.assertEquals((String)"resBundleProp1.bundleProp2", (String)ELAssert.getELText(this._structuredDocument, 887));
        ResourceBundleTestCase.assertEquals((String)"noPackageBundle.bundleProp2", (String)ELAssert.getELText(this._structuredDocument, 943));
        ResourceBundleTestCase.assertEquals((String)"resBundleProp1.bundleProp1 && myBean.stringProperty", (String)ELAssert.getELText(this._structuredDocument, 1003));
        ResourceBundleTestCase.assertEquals((String)"empty resBundleProp1", (String)ELAssert.getELText(this._structuredDocument, 1087));
        ResourceBundleTestCase.assertEquals((String)"empty resBundleProp1.bundleProp2", (String)ELAssert.getELText(this._structuredDocument, 1140));
        ResourceBundleTestCase.assertEquals((String)"resBundleProp1.bundleProp2 + 5", (String)ELAssert.getELText(this._structuredDocument, 1205));
        ResourceBundleTestCase.assertEquals((String)"bundleProp2", (String)ELAssert.getELText(this._structuredDocument, 1265));
        ResourceBundleTestCase.assertEquals((String)"resBundleProp1.x.y", (String)ELAssert.getELText(this._structuredDocument, 1306));
        ResourceBundleTestCase.assertEquals((String)"noPackageBundle.x.y", (String)ELAssert.getELText(this._structuredDocument, 1354));
        ResourceBundleTestCase.assertEquals((String)"resBundleProp2.name", (String)ELAssert.getELText(this._structuredDocument, 1406));
        ResourceBundleTestCase.assertEquals((String)"resBundleProp2.movie", (String)ELAssert.getELText(this._structuredDocument, 1455));
        ResourceBundleTestCase.assertEquals((String)"-resBundleProp1.bundleProp1", (String)ELAssert.getELText(this._structuredDocument, 1530));
        ResourceBundleTestCase.assertEquals((String)"resBundleProp1.bundleProp3", (String)ELAssert.getELText(this._structuredDocument, 1590));
        ResourceBundleTestCase.assertEquals((String)"msg", (String)ELAssert.getELText(this._structuredDocument, 1649));
        ResourceBundleTestCase.assertEquals((String)"resBundleProp1.x", (String)ELAssert.getELText(this._structuredDocument, 1685));
        ResourceBundleTestCase.assertEquals((String)"noPackageBundle.notAProperty", (String)ELAssert.getELText(this._structuredDocument, 1731));
        ResourceBundleTestCase.assertEquals((String)"resBundleProp2.bundleProp2", (String)ELAssert.getELText(this._structuredDocument, 1792));
        ResourceBundleTestCase.assertEquals((String)"resBundleProp2.notAPropAtAll", (String)ELAssert.getELText(this._structuredDocument, 1848));
    }

    public void testNoErrorExprs() {
        this.assertNoError(887, "Ljava.lang.String;");
        this.assertNoError(943, "Ljava.lang.String;");
        this.assertNoError(1003, "Z");
        this.assertNoError(1087, "Z");
        this.assertNoError(1140, "Z");
        this.assertNoError(1205, "J");
        this.assertNoError(1306, "Ljava.lang.String;");
        this.assertNoError(1354, "Ljava.lang.String;");
        this.assertNoError(1406, "Ljava.lang.String;");
        this.assertNoError(1455, "Ljava.lang.String;");
    }

    public void testWarningExprs() {
        List<MockValidationReporter.ReportedProblem> problems = this.assertSemanticWarning(1530, null, 1);
        ELAssert.assertContainsProblem(problems, 17);
        problems = this.assertSemanticWarning(1590, null, 1);
        ELAssert.assertContainsProblem(problems, 19);
        problems = this.assertSemanticInfo(1649, null, 1);
        ELAssert.assertContainsProblem(problems, 20);
        problems = this.assertSemanticWarning(1685, null, 1);
        ELAssert.assertContainsProblem(problems, 29);
        problems = this.assertSemanticWarning(1731, null, 1);
        ELAssert.assertContainsProblem(problems, 19);
        problems = this.assertSemanticWarning(1792, null, 1);
        ELAssert.assertContainsProblem(problems, 19);
        problems = this.assertSemanticWarning(1848, null, 1);
        ELAssert.assertContainsProblem(problems, 19);
    }

    public void testErrorExprs() {
    }
}

