/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.jaxws.testutils.project;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jst.ws.jaxws.testutils.project.TestProjectsUtils;
import org.eclipse.jst.ws.jaxws.utils.ContractChecker;
import org.eclipse.jst.ws.jaxws.utils.exception.MissingResourceException;

public class TestEjb3Project {
    private IProject ejbProject;

    public TestEjb3Project(String name) throws Exception {
        this.ejbProject = this.createEjbModule(String.valueOf(name) + "_" + Long.toString(System.currentTimeMillis()));
    }

    public TestEjb3Project(String name, boolean appendUid, boolean reuseExisting) throws Exception {
        StringBuilder projectName = new StringBuilder(name);
        if (appendUid) {
            projectName.append("_");
            projectName.append(Long.toString(System.currentTimeMillis()));
        }
        IProject existingProject = null;
        if (reuseExisting) {
            existingProject = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName.toString());
        }
        this.ejbProject = existingProject == null ? this.createEjbModule(projectName.toString()) : existingProject;
    }

    private IProject createEjbModule(String name) throws Exception {
        return TestProjectsUtils.createEjb3Project(name);
    }

    public IProject getProject() {
        return this.ejbProject.getProject();
    }

    public IFolder getMetaInfFolder() throws MissingResourceException {
        return this.ejbProject.getProject().getFolder("ejbModule").getFolder("META-INF");
    }

    public IPackageFragment createPackage(String sourceFolder, String packageName) throws JavaModelException {
        IJavaProject javaProject = JavaCore.create((IProject)this.getProject());
        IFolder folder = this.getProject().getFolder(sourceFolder);
        IPackageFragmentRoot srcFolder = javaProject.getPackageFragmentRoot((IResource)folder);
        return srcFolder.createPackageFragment(packageName, false, (IProgressMonitor)new NullProgressMonitor());
    }

    public IFile createFile(IFolder folder, String fileName, URL inputUrl) throws IOException, CoreException {
        ContractChecker.nullCheckParam((Object)folder, (String)"folder");
        ContractChecker.nullCheckParam((Object)fileName, (String)"fileName");
        ContractChecker.nullCheckParam((Object)inputUrl, (String)"inputUrl");
        IFile file = folder.getFile(fileName);
        InputStream inputStream = inputUrl.openStream();
        try {
            file.create(inputStream, false, (IProgressMonitor)new NullProgressMonitor());
            IFile iFile = file;
            return iFile;
        }
        finally {
            inputStream.close();
        }
    }

    public final IFile getFile(String filePath) {
        ContractChecker.nullCheckParam((Object)filePath, (String)"filePath");
        return this.ejbProject.getProject().getFile(filePath);
    }

    public final void deleteFile(IFolder folder, String fileName) throws CoreException, IOException {
        ContractChecker.nullCheckParam((Object)folder, (String)"folder");
        ContractChecker.nullCheckParam((Object)fileName, (String)"fileName");
        IFile file = folder.getFile(fileName);
        if (file.exists()) {
            file.delete(true, (IProgressMonitor)new NullProgressMonitor());
        }
    }

    public final IFolder createFolder(String folderPath) throws CoreException {
        ContractChecker.nullCheckParam((Object)folderPath, (String)"folderPath");
        IFolder folder = this.ejbProject.getProject().getFolder(folderPath);
        folder.create(true, true, null);
        return folder;
    }

    public final IFolder getFolder(String folderPath) {
        ContractChecker.nullCheckParam((Object)folderPath, (String)"folderPath");
        return this.ejbProject.getProject().getFolder(folderPath);
    }
}

