/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.jaxws.dom.runtime.tests.dom.validation;

import java.util.HashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IType;
import org.eclipse.jst.ws.jaxws.dom.runtime.tests.dom.validation.ValidationTestsSetUp;

public class WpValidationTest
extends ValidationTestsSetUp {
    private IType seiType;

    public void setUp() throws Exception {
        super.setUp();
        this.seiType = this.testProject.createType(this.testPack, "Sei.java", "@javax.jws.WebService(name=\"SeiName\") public interface Sei {}");
        WpValidationTest.assertNotNull((String)"Could not find SEI", (Object)this.findSei(this.seiType.getFullyQualifiedName()));
        this.testProject.build(10);
    }

    public void testNameIsNCName() throws CoreException {
        this.setContents(this.seiType.getCompilationUnit(), "@javax.jws.WebService(name=\"SeiName\") public interface Sei {public void test(@javax.jws.WebParam(name=\"---\")int a); \n}");
        HashMap<String, Object> markerAttributes = new HashMap<String, Object>();
        markerAttributes.put("charStart", 116);
        markerAttributes.put("charEnd", 121);
        markerAttributes.put("lineNumber", 2);
        markerAttributes.put("severity", 2);
        ValidationTestsSetUp.MarkerData markerData = new ValidationTestsSetUp.MarkerData(this, this.seiType.getResource(), "org.eclipse.jdt.apt.core.nonreconcile.compile.problem", markerAttributes);
        this.validateResourceMarkers(this.seiType.getResource(), markerData);
    }

    public void testPartNameIsNCName() throws CoreException {
        this.setContents(this.seiType.getCompilationUnit(), "import javax.jws.soap.SOAPBinding;\n@SOAPBinding(style=SOAPBinding.Style.RPC)@javax.jws.WebService public interface Sei {public void test(@javax.jws.WebParam(partName=\"---\")int a); \n}");
        HashMap<String, Object> markerAttributes = new HashMap<String, Object>();
        markerAttributes.put("charStart", 180);
        markerAttributes.put("charEnd", 185);
        markerAttributes.put("severity", 2);
        ValidationTestsSetUp.MarkerData markerData = new ValidationTestsSetUp.MarkerData(this, this.seiType.getResource(), "org.eclipse.jdt.apt.core.nonreconcile.compile.problem", markerAttributes);
        this.validateResourceMarkers(this.seiType.getResource(), markerData);
    }

    public void testNameIsUniqe() throws CoreException {
        this.setContents(this.seiType.getCompilationUnit(), "@javax.jws.WebService(name=\"SeiName\") public interface Sei {public void test(@javax.jws.WebParam(name=\"param1\")int a, @javax.jws.WebParam(name=\"param1\")int b); \n}");
        HashMap<String, Object> marker1_Attributes = new HashMap<String, Object>();
        marker1_Attributes.put("charStart", 116);
        marker1_Attributes.put("charEnd", 124);
        marker1_Attributes.put("severity", 2);
        HashMap<String, Object> marker2_Attributes = new HashMap<String, Object>();
        marker2_Attributes.put("charStart", 157);
        marker2_Attributes.put("charEnd", 165);
        marker2_Attributes.put("severity", 2);
        ValidationTestsSetUp.MarkerData marker1_Data = new ValidationTestsSetUp.MarkerData(this, this.seiType.getResource(), "org.eclipse.jdt.apt.core.nonreconcile.compile.problem", marker1_Attributes);
        ValidationTestsSetUp.MarkerData marker2_Data = new ValidationTestsSetUp.MarkerData(this, this.seiType.getResource(), "org.eclipse.jdt.apt.core.nonreconcile.compile.problem", marker2_Attributes);
        this.validateResourceMarkers(this.seiType.getResource(), marker2_Data, marker1_Data);
    }

    public void testNameNotRedundant() throws CoreException {
        this.setContents(this.seiType.getCompilationUnit(), "import javax.jws.soap.SOAPBinding;\n@SOAPBinding(style=SOAPBinding.Style.RPC)@javax.jws.WebService public interface Sei {public void test(@javax.jws.WebParam(name=\"myName\")int a); \n}");
        this.assertNoValidationErrors(this.seiType.getResource(), "org.eclipse.jdt.apt.core.nonreconcile.compile.problem");
    }

    public void testNameRedundant() throws CoreException {
        this.setContents(this.seiType.getCompilationUnit(), "import javax.jws.soap.SOAPBinding;\n@SOAPBinding(style=SOAPBinding.Style.RPC)@javax.jws.WebService public interface Sei {public void test(@javax.jws.WebParam(name=\"myName\", partName=\"myPart\")int a); \n}");
        HashMap<String, Object> markerAttributes = new HashMap<String, Object>();
        markerAttributes.put("charStart", 176);
        markerAttributes.put("charEnd", 184);
        markerAttributes.put("severity", 1);
        ValidationTestsSetUp.MarkerData markerData = new ValidationTestsSetUp.MarkerData(this, this.seiType.getResource(), "org.eclipse.jdt.apt.core.nonreconcile.compile.problem", markerAttributes);
        this.validateResourceMarkers(this.seiType.getResource(), markerData);
    }

    public void testTargetNsValidUri() throws CoreException {
        this.setContents(this.seiType.getCompilationUnit(), "@javax.jws.WebService(name=\"SeiName\") public interface Sei {public void test(@javax.jws.WebParam(targetNamespace=\"^^^\")int a); \n}");
        HashMap<String, Object> markerAttributes = new HashMap<String, Object>();
        markerAttributes.put("charStart", 127);
        markerAttributes.put("charEnd", 132);
        markerAttributes.put("severity", 2);
        ValidationTestsSetUp.MarkerData markerData = new ValidationTestsSetUp.MarkerData(this, this.seiType.getResource(), "org.eclipse.jdt.apt.core.nonreconcile.compile.problem", markerAttributes);
        this.validateResourceMarkers(this.seiType.getResource(), markerData);
    }
}

