/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.model.internal.validation;

import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.jst.j2ee.core.internal.plugin.J2EECorePlugin;

public class J2EEValidationResourceHandler {
    private static Hashtable handlers = new Hashtable();
    protected ClassLoader resourceClassLoader;
    protected Locale locale = null;
    protected String bundleName = null;
    protected ResourceBundle bundle = null;

    public J2EEValidationResourceHandler() {
    }

    public J2EEValidationResourceHandler(Locale locale) {
        this.setLocale(locale);
    }

    public ResourceBundle getBundle() {
        if (this.bundle == null) {
            try {
                this.bundle = this.getResourceClassLoader() == null ? ResourceBundle.getBundle(this.getBundleName(), this.getLocale()) : ResourceBundle.getBundle(this.getBundleName(), this.getLocale(), this.getResourceClassLoader());
            }
            catch (MissingResourceException e) {
                System.out.println("Exception retrieving bundle: " + this.getBundleName() + " using locale: " + this.getLocale().toString());
                J2EECorePlugin.logError(e);
            }
        }
        return this.bundle;
    }

    public String getBundleName() {
        return this.bundleName;
    }

    public static String getExternalizedMessage(String fileName, String key, Class aClass) {
        return J2EEValidationResourceHandler.getHandler(fileName, aClass).getMessage(key);
    }

    public static String getExternalizedMessage(String fileName, String key, Class aClass, Object[] arg) {
        return J2EEValidationResourceHandler.getHandler(fileName, aClass).getMessage(key, arg);
    }

    public static String getExternalizedMessage(String fileName, String key, Class aClass, Object[] arg, Locale locale) {
        return J2EEValidationResourceHandler.getHandler(fileName, aClass, locale).getMessage(key, arg);
    }

    public static String getExternalizedMessage(String fileName, String key, Class aClass, String arg1) {
        return J2EEValidationResourceHandler.getHandler(fileName, aClass).getMessage(key, arg1);
    }

    public static String getExternalizedMessage(String fileName, String key, Class aClass, String arg1, String arg2) {
        return J2EEValidationResourceHandler.getHandler(fileName, aClass).getMessage(key, arg1, arg2);
    }

    public static String getExternalizedMessage(String fileName, String key, Class aClass, String arg1, String arg2, String arg3) {
        return J2EEValidationResourceHandler.getHandler(fileName, aClass).getMessage(key, arg1, arg2, arg3);
    }

    public static String getExternalizedMessage(String fileName, String key, Class aClass, String arg1, String arg2, String arg3, String arg4) {
        return J2EEValidationResourceHandler.getHandler(fileName, aClass).getMessage(key, arg1, arg2, arg3, arg4);
    }

    public static String getExternalizedMessage(String fileName, String key, Class aClass, String arg1, String arg2, String arg3, String arg4, String arg5) {
        return J2EEValidationResourceHandler.getHandler(fileName, aClass).getMessage(key, arg1, arg2, arg3, arg4, arg5);
    }

    public static String getExternalizedMessage(String fileName, String key, Class aClass, Locale locale) {
        return J2EEValidationResourceHandler.getHandler(fileName, aClass, locale).getMessage(key);
    }

    public static J2EEValidationResourceHandler getHandler(String fileName, Class aClass) {
        return J2EEValidationResourceHandler.getHandler(fileName, aClass, Locale.getDefault());
    }

    public static J2EEValidationResourceHandler getHandler(String fileName, Class aClass, Locale locale) {
        String handlerKey = J2EEValidationResourceHandler.getHandlerKey(fileName, locale);
        if (handlers.get(handlerKey) == null) {
            J2EEValidationResourceHandler temp = new J2EEValidationResourceHandler(locale);
            temp.setResourceClassLoader(aClass.getClassLoader());
            temp.setBundleName(fileName);
            handlers.put(handlerKey, temp);
        }
        return (J2EEValidationResourceHandler)handlers.get(handlerKey);
    }

    private static String getHandlerKey(String _baseName, Locale locale) {
        StringBuffer localeName = new StringBuffer("_").append(locale.toString());
        if (locale.toString().equals("")) {
            localeName.setLength(0);
        }
        return String.valueOf(_baseName) + localeName.toString();
    }

    public ClassLoader getResourceClassLoader() {
        return this.resourceClassLoader;
    }

    public void setResourceClassLoader(ClassLoader newResourceClassLoader) {
        this.resourceClassLoader = newResourceClassLoader;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public void setBundleName(String newBundleName) {
        this.bundleName = newBundleName;
    }

    public Locale getLocale() {
        if (this.locale == null) {
            this.locale = Locale.getDefault();
        }
        return this.locale;
    }

    public String getMessage(String key) {
        String temp = null;
        try {
            temp = this.getBundle().getString(key);
        }
        catch (MissingResourceException ex) {
            System.out.println("Resource Exception: " + ex);
            temp = "<<Key: " + key + " not found in resource: " + this.getBundleName() + ">>";
        }
        return temp;
    }

    public String getMessage(String key, Object[] arg) {
        String temp = null;
        try {
            temp = MessageFormat.format(this.getBundle().getString(key), arg);
        }
        catch (MissingResourceException ex) {
            System.out.println("Resource Exception: " + ex);
            temp = "<<Key: " + key + " not found in resource: " + this.getBundleName() + ">>";
        }
        return temp;
    }

    public String getMessage(String key, String arg1) {
        String temp = null;
        try {
            if (arg1 != null) {
                Object[] msgobj = new Object[]{arg1};
                temp = this.getMessage(key, msgobj);
            } else {
                temp = this.getMessage(key);
            }
        }
        catch (MissingResourceException ex) {
            System.out.println("Resource Exception: " + ex);
            temp = "<<Key: " + key + " not found in resource: " + this.getBundleName() + ">>";
        }
        return temp;
    }

    public String getMessage(String key, String arg1, String arg2) {
        String temp = null;
        try {
            if (arg1 != null && arg2 != null) {
                Object[] msgobj = new Object[]{arg1, arg2};
                temp = this.getMessage(key, msgobj);
            } else {
                temp = this.getMessage(key);
            }
        }
        catch (MissingResourceException ex) {
            System.out.println("Resource Exception: " + ex);
            temp = "<<Key: " + key + " not found in resource: " + this.getBundleName() + ">>";
        }
        return temp;
    }

    public String getMessage(String key, String arg1, String arg2, String arg3) {
        String temp = null;
        try {
            if (arg1 != null && arg2 != null && arg3 != null) {
                Object[] msgobj = new Object[]{arg1, arg2, arg3};
                temp = this.getMessage(key, msgobj);
            } else {
                temp = this.getMessage(key);
            }
        }
        catch (MissingResourceException ex) {
            System.out.println("Resource Exception: " + ex);
            temp = "<<Key: " + key + " not found in resource: " + this.getBundleName() + ">>";
        }
        return temp;
    }

    public String getMessage(String key, String arg1, String arg2, String arg3, String arg4) {
        String temp = null;
        try {
            if (arg1 != null && arg2 != null && arg3 != null && arg4 != null) {
                Object[] msgobj = new Object[]{arg1, arg2, arg3, arg4};
                temp = this.getMessage(key, msgobj);
            } else {
                temp = this.getMessage(key);
            }
        }
        catch (MissingResourceException ex) {
            System.out.println("Resource Exception: " + ex);
            temp = "<<Key: " + key + " not found in resource: " + this.getBundleName() + ">>";
        }
        return temp;
    }

    public String getMessage(String key, String arg1, String arg2, String arg3, String arg4, String arg5) {
        String temp = null;
        try {
            if (arg1 != null && arg2 != null && arg3 != null && arg4 != null && arg5 != null) {
                Object[] msgobj = new Object[]{arg1, arg2, arg3, arg4, arg5};
                temp = this.getMessage(key, msgobj);
            } else {
                temp = this.getMessage(key);
            }
        }
        catch (MissingResourceException ex) {
            System.out.println("Resource Exception: " + ex);
            temp = "<<Key: " + key + " not found in resource: " + this.getBundleName() + ">>";
        }
        return temp;
    }
}

