/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.launching.tests;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;

public class EnvironmentTestSetup {
    public static final boolean DEBUG = true;
    private IWorkspace _workspace;
    private HashMap<String, IProject> _projects = new HashMap(20);

    public EnvironmentTestSetup() throws CoreException {
        this._workspace = ResourcesPlugin.getWorkspace();
        this._workspace.getRoot().delete(true, true, null);
    }

    public IPath addFolder(IPath root, String folderName) throws CoreException {
        IPath path = root.append(folderName);
        this.createFolder(path);
        return path;
    }

    public void incrementalBuild() throws CoreException {
        this.getWorkspace().build(10, null);
    }

    public void fullBuild() throws CoreException {
        this.getWorkspace().build(6, null);
    }

    public void waitForBuild() {
        boolean wasInterrupted = false;
        do {
            try {
                Job.getJobManager().join(ResourcesPlugin.FAMILY_MANUAL_BUILD, null);
                wasInterrupted = false;
            }
            catch (InterruptedException interruptedException) {
                wasInterrupted = true;
            }
        } while (wasInterrupted);
    }

    private IFolder createFolder(IPath path) throws CoreException {
        if (path.segmentCount() <= 1) {
            return null;
        }
        IFolder folder = this._workspace.getRoot().getFolder(path);
        if (!folder.exists()) {
            folder.create(true, true, null);
        }
        return folder;
    }

    public IProject createProject(String name) throws CoreException {
        final IProject project = this._workspace.getRoot().getProject(name);
        IWorkspaceRunnable create = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                project.create(monitor);
                project.open(monitor);
            }
        };
        this._workspace.run(create, null);
        this._projects.put(name, project);
        return project;
    }

    public void dispose() throws CoreException {
    }

    public IPath addFile(IPath folder, String fileName, String contents) throws CoreException, UnsupportedEncodingException {
        IPath filePath = folder.append(fileName);
        this.createFile(filePath, contents.getBytes("UTF8"));
        return filePath;
    }

    public IPath addFileFromResource(IPath folder, String fileName, String path) throws CoreException {
        IPath filePath = folder.append(fileName);
        this.createFileFromResource(filePath, path);
        return filePath;
    }

    private IFile createFile(IPath filePath, byte[] contents) throws CoreException {
        IFile file = this._workspace.getRoot().getFile(filePath);
        ByteArrayInputStream in = new ByteArrayInputStream(contents);
        if (file.exists()) {
            file.setContents((InputStream)in, true, false, null);
        } else {
            file.create((InputStream)in, true, null);
        }
        return file;
    }

    private IFile createFileFromResource(IPath filePath, String path) throws CoreException {
        IFile file = this._workspace.getRoot().getFile(filePath);
        InputStream in = EnvironmentTestSetup.class.getResourceAsStream(path);
        if (file.exists()) {
            file.setContents(in, true, false, null);
        } else {
            file.create(in, true, null);
        }
        return file;
    }

    public IWorkspace getWorkspace() {
        return this._workspace;
    }
}

