/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jee.ui.internal.navigator;

import java.net.URL;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jst.j2ee.internal.plugin.J2EEPlugin;
import org.eclipse.jst.j2ee.internal.provider.J2EEAdapterFactoryLabelProvider;
import org.eclipse.jst.j2ee.navigator.internal.J2EELabelProvider;
import org.eclipse.jst.j2ee.navigator.internal.LoadingDDNode;
import org.eclipse.jst.javaee.core.EjbLocalRef;
import org.eclipse.jst.javaee.core.EjbRef;
import org.eclipse.jst.javaee.core.EnvEntry;
import org.eclipse.jst.javaee.core.ResourceEnvRef;
import org.eclipse.jst.javaee.core.ResourceRef;
import org.eclipse.jst.javaee.core.ServiceRef;
import org.eclipse.jst.javaee.ejb.ActivationConfigProperty;
import org.eclipse.jst.javaee.ejb.EntityBean;
import org.eclipse.jst.javaee.ejb.MessageDrivenBean;
import org.eclipse.jst.javaee.ejb.SessionBean;
import org.eclipse.jst.jee.ui.internal.navigator.AbstractDDNode;
import org.eclipse.jst.jee.ui.internal.navigator.AbstractGroupProvider;
import org.eclipse.jst.jee.ui.internal.navigator.ejb.GroupEJBProvider;
import org.eclipse.jst.jee.ui.plugin.JEEUIPlugin;
import org.eclipse.jst.jee.ui.plugin.JEEUIPluginIcons;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.common.internal.emfworkbench.integration.DynamicAdapterFactory;

public class Ejb3LabelProvider
extends J2EELabelProvider {
    private Image ejb30Image;
    private Image ejb31Image;
    private Image ejb32Image;
    private Image sessionBeanImage;
    private Image mdbImage;
    private Image cmpImage;
    private Image ejbRefImage;
    private Image resourceRefImage;
    private Image serviceRefImage;
    private Image activationConfigImage;

    public Ejb3LabelProvider() {
        new J2EEAdapterFactoryLabelProvider((AdapterFactory)new DynamicAdapterFactory("org.eclipse.ui.navigator.ProjectExplorer"));
    }

    public Image getImage(Object element) {
        if (element instanceof LoadingDDNode) {
            return ((LoadingDDNode)element).getImage();
        }
        if (element instanceof IProject || element instanceof IJavaProject) {
            return null;
        }
        if (element instanceof GroupEJBProvider) {
            String version = ((GroupEJBProvider)element).getEjbJar().getVersion();
            if ("3.0".equals(version)) {
                return this.getEjb30Image();
            }
            if ("3.1".equals(version)) {
                return this.getEjb31Image();
            }
            if ("3.2".equals(version)) {
                return this.getEjb32Image();
            }
            return this.getEjb30Image();
        }
        if (element instanceof AbstractDDNode) {
            return ((AbstractDDNode)element).getImage();
        }
        if (element instanceof SessionBean) {
            return this.getSessionBeanImage();
        }
        if (element instanceof MessageDrivenBean) {
            return this.getMDBImage();
        }
        if (element instanceof EntityBean) {
            return this.getCMPImage();
        }
        if (element instanceof EjbLocalRef || element instanceof EjbRef) {
            return this.getEjbRefImage();
        }
        if (element instanceof EnvEntry) {
            return this.getResourceRefImage();
        }
        if (element instanceof ResourceEnvRef) {
            return this.getResourceRefImage();
        }
        if (element instanceof ResourceRef) {
            return this.getResourceRefImage();
        }
        if (element instanceof ServiceRef) {
            return this.getServiceRefImage();
        }
        if (element instanceof ActivationConfigProperty) {
            return this.getActivationConfigImage();
        }
        return null;
    }

    public String getText(Object element) {
        String ret = null;
        if (element instanceof SessionBean || element instanceof MessageDrivenBean || element instanceof EntityBean) {
            ret = element instanceof SessionBean ? ((SessionBean)element).getEjbName() : (element instanceof MessageDrivenBean ? ((MessageDrivenBean)element).getEjbName() : (element instanceof EntityBean ? ((EntityBean)element).getEjbName() : null));
        } else if (element instanceof AbstractDDNode) {
            ret = ((AbstractDDNode)element).getText();
        } else if (element instanceof AbstractGroupProvider) {
            ret = ((AbstractGroupProvider)element).getText();
        } else if (element instanceof EjbLocalRef || element instanceof EjbRef) {
            ret = element instanceof EjbLocalRef ? ((EjbLocalRef)element).getEjbRefName() : (element instanceof EjbRef ? ((EjbRef)element).getEjbRefName() : null);
        } else if (element instanceof EnvEntry) {
            ret = ((EnvEntry)element).getEnvEntryName();
        } else if (element instanceof ResourceEnvRef) {
            ret = ((ResourceEnvRef)element).getResourceEnvRefName();
        } else if (element instanceof ResourceRef) {
            ret = ((ResourceRef)element).getResRefName();
        } else if (element instanceof ServiceRef) {
            ret = ((ServiceRef)element).getServiceRefName();
        } else if (element instanceof ActivationConfigProperty) {
            ret = String.valueOf(((ActivationConfigProperty)element).getActivationConfigPropertyName()) + ":" + ((ActivationConfigProperty)element).getActivationConfigPropertyValue();
        }
        return ret;
    }

    public String getDescription(Object anElement) {
        String desc;
        String description = super.getDescription(anElement);
        if (anElement instanceof AbstractDDNode && (desc = ((AbstractDDNode)anElement).getDescription()) != null) {
            description = desc;
        }
        return description;
    }

    private Image getEjb30Image() {
        if (this.ejb30Image == null) {
            this.ejb30Image = JEEUIPlugin.getDefault().getImageDescriptor(JEEUIPluginIcons.IMG_EJBEEMODEL).createImage();
        }
        return this.ejb30Image;
    }

    private Image getEjb31Image() {
        if (this.ejb31Image == null) {
            this.ejb31Image = JEEUIPlugin.getDefault().getImageDescriptor(JEEUIPluginIcons.IMG_EJBEE6MODEL).createImage();
        }
        return this.ejb31Image;
    }

    private Image getEjb32Image() {
        if (this.ejb32Image == null) {
            this.ejb32Image = JEEUIPlugin.getDefault().getImageDescriptor(JEEUIPluginIcons.IMG_EJBEE7MODEL).createImage();
        }
        return this.ejb32Image;
    }

    private Image getSessionBeanImage() {
        if (this.sessionBeanImage == null) {
            URL url = (URL)J2EEPlugin.getPlugin().getImage("sessionBean_obj");
            this.sessionBeanImage = ImageDescriptor.createFromURL((URL)url).createImage();
        }
        return this.sessionBeanImage;
    }

    private Image getMDBImage() {
        if (this.mdbImage == null) {
            URL url = (URL)J2EEPlugin.getPlugin().getImage("message_bean_obj");
            this.mdbImage = ImageDescriptor.createFromURL((URL)url).createImage();
        }
        return this.mdbImage;
    }

    private Image getCMPImage() {
        if (this.cmpImage == null) {
            URL url = (URL)J2EEPlugin.getPlugin().getImage("cmpEntity_obj");
            this.cmpImage = ImageDescriptor.createFromURL((URL)url).createImage();
        }
        return this.cmpImage;
    }

    private Image getEjbRefImage() {
        if (this.ejbRefImage == null) {
            URL url = (URL)J2EEPlugin.getPlugin().getImage("ejbRef_obj");
            this.ejbRefImage = ImageDescriptor.createFromURL((URL)url).createImage();
        }
        return this.ejbRefImage;
    }

    private Image getResourceRefImage() {
        if (this.resourceRefImage == null) {
            URL url = (URL)J2EEPlugin.getPlugin().getImage("resourceRef_obj");
            this.resourceRefImage = ImageDescriptor.createFromURL((URL)url).createImage();
        }
        return this.resourceRefImage;
    }

    private Image getServiceRefImage() {
        if (this.serviceRefImage == null) {
            URL url = (URL)J2EEPlugin.getPlugin().getImage("attribute_obj");
            this.serviceRefImage = ImageDescriptor.createFromURL((URL)url).createImage();
        }
        return this.serviceRefImage;
    }

    private Image getActivationConfigImage() {
        if (this.activationConfigImage == null) {
            URL url = (URL)J2EEPlugin.getPlugin().getImage("access_intent_obj");
            this.activationConfigImage = ImageDescriptor.createFromURL((URL)url).createImage();
        }
        return this.activationConfigImage;
    }
}

