/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.proxy.initParser;

import java.io.IOException;
import java.io.StringWriter;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.jem.internal.proxy.initParser.Expression;
import org.eclipse.jem.internal.proxy.initParser.Field;
import org.eclipse.jem.internal.proxy.initParser.Message;
import org.eclipse.jem.internal.proxy.initParser.MessageArgument;
import org.eclipse.jem.internal.proxy.initParser.Statement;

public class Static
extends Expression {
    protected static final HashMap sPrimitiveTypes = new HashMap(10);
    protected ArrayList arrayDimensions;
    protected List fArrayArguments;
    protected StringWriter typeWriter = new StringWriter();
    protected boolean completedWithPeriod = false;
    protected char[] completionToken;
    public Class type;
    protected boolean isComplete;
    public boolean isProcessingArrayDimension;
    protected Object array;

    static {
        sPrimitiveTypes.put("byte", Byte.TYPE);
        sPrimitiveTypes.put("char", Character.TYPE);
        sPrimitiveTypes.put("short", Short.TYPE);
        sPrimitiveTypes.put("int", Integer.TYPE);
        sPrimitiveTypes.put("long", Long.TYPE);
        sPrimitiveTypes.put("float", Float.TYPE);
        sPrimitiveTypes.put("double", Double.TYPE);
    }

    public Static(ClassLoader aClassLoader) {
        this.fClassLoader = aClassLoader;
    }

    public Static(char[] aToken, char delimiter, ClassLoader aClassLoader) {
        this.fClassLoader = aClassLoader;
        try {
            this.typeWriter.write(aToken);
        }
        catch (IOException iOException) {}
        this.checkForValidType();
        if (this.type == null && delimiter == '.') {
            this.typeWriter.write(46);
        }
    }

    public Static(char[] aToken, char delimiter, ClassLoader aClassLoader, boolean isArray) {
        this(aToken, delimiter, aClassLoader);
        this.isProcessingArrayDimension = true;
        this.arrayDimensions = new ArrayList(1);
        this.arrayDimensions.add(new Statement(aClassLoader));
    }

    public boolean isComplete() {
        return this.isComplete;
    }

    public boolean isArray() {
        return this.arrayDimensions != null;
    }

    protected void checkForValidType() {
        this.type = (Class)sPrimitiveTypes.get(this.typeWriter.toString());
        if (this.type == null) {
            try {
                this.type = this.fClassLoader == null ? Class.forName(this.typeWriter.toString()) : this.fClassLoader.loadClass(this.typeWriter.toString());
            }
            catch (ClassNotFoundException classNotFoundException) {
                try {
                    this.type = Class.forName("java.lang." + this.typeWriter.toString());
                    StringWriter writer = new StringWriter();
                    writer.write(this.type.getName());
                    this.typeWriter = writer;
                }
                catch (ClassNotFoundException classNotFoundException2) {}
            }
            catch (NoClassDefFoundError noClassDefFoundError) {}
        }
    }

    public Object evaluate() {
        if (this.isArray()) {
            if (this.array == null) {
                this.evaluateArray();
            }
            return this.array;
        }
        if (this.type != null) {
            return this.type;
        }
        throw new RuntimeException();
    }

    public Class getTypeClass() {
        if (this.isArray()) {
            if (this.array == null) {
                Object result = Array.newInstance(this.type, this.getNumberOfDimensions());
                return result.getClass();
            }
            return this.array.getClass();
        }
        return this.type;
    }

    protected String getTypeClassName() {
        return this.typeWriter.toString();
    }

    public Class getPrimitiveTypeClass() {
        return this.type;
    }

    protected int[] getNumberOfDimensions() {
        ArrayList<Integer> dimensions = new ArrayList<Integer>(1);
        dimensions.add(new Integer(this.fArrayArguments.size()));
        ((MessageArgument)this.fArrayArguments.get(0)).contributeArgumentNumber(dimensions);
        int[] intDimensions = new int[dimensions.size()];
        int i = 0;
        while (i < dimensions.size()) {
            intDimensions[i] = (Integer)dimensions.get(i);
            ++i;
        }
        return intDimensions;
    }

    protected void evaluateArray() {
        if (this.fArrayArguments != null) {
            if (this.array == null) {
                this.array = Array.newInstance(this.type, this.getNumberOfDimensions());
                int i = 0;
                while (i < this.fArrayArguments.size()) {
                    Expression expression = (Expression)this.fArrayArguments.get(i);
                    try {
                        Object element = expression.evaluate();
                        Array.set(this.array, i, element);
                    }
                    catch (Exception exception) {
                        throw new RuntimeException();
                    }
                    ++i;
                }
            }
        } else if (this.arrayDimensions != null && this.array == null) {
            int[] dimensionSizes = new int[this.arrayDimensions.size()];
            int i = 0;
            while (i < dimensionSizes.length) {
                try {
                    Integer dimensionSize = (Integer)((Expression)this.arrayDimensions.get(i)).evaluate();
                    dimensionSizes[i] = dimensionSize;
                }
                catch (Exception exception) {
                    throw new RuntimeException();
                }
                ++i;
            }
            this.array = Array.newInstance(this.type, dimensionSizes);
        }
    }

    public Expression push(char[] token, char delimiter) {
        if (this.type == null) {
            try {
                this.typeWriter.write(token);
            }
            catch (IOException iOException) {}
            this.checkForValidType();
            if (delimiter == '.' && this.type != null) {
                this.completedWithPeriod = true;
                return this;
            }
        }
        if (this.arrayDimensions != null && this.isProcessingArrayDimension) {
            Expression lastArrayDimension = (Expression)this.arrayDimensions.get(this.arrayDimensions.size() - 1);
            lastArrayDimension.push(token, delimiter);
            if (delimiter == ']' && this.isProcessingArrayDimension) {
                this.isProcessingArrayDimension = false;
            }
            return this;
        }
        if (delimiter == '[' && !this.isProcessingArrayDimension) {
            if (this.arrayDimensions == null) {
                this.arrayDimensions = new ArrayList(1);
            }
            Statement statement = new Statement(this.fClassLoader);
            this.arrayDimensions.add(statement);
            this.isProcessingArrayDimension = true;
            return this;
        }
        if (this.type != null) {
            if (delimiter == '(') {
                this.isComplete = true;
                return new Message(this, token, this.fClassLoader);
            }
            if (this.completedWithPeriod) {
                this.isComplete = true;
                Field field = new Field(this, token, this.fClassLoader);
                if (delimiter == ')' || delimiter == ',') {
                    field.isComplete = true;
                }
                return field;
            }
        }
        if (this.type == null) {
            this.typeWriter.write(46);
        }
        return this;
    }

    public String toString() {
        StringWriter writer = new StringWriter();
        writer.write("Static ");
        if (this.type == null) {
            writer.write("(Incomplete) {");
        } else {
            writer.write("(Complete) {");
        }
        writer.write(this.typeWriter.toString());
        writer.write("}");
        if (this.arrayDimensions != null) {
            writer.write(" array dimensions=");
            writer.write(new Integer(this.arrayDimensions.size()).toString());
        }
        if (this.fArrayArguments != null) {
            writer.write(" array dimensions=");
            writer.write(new Integer(this.fArrayArguments.size()).toString());
        }
        return writer.toString();
    }

    public boolean isPrimitive() {
        return this.getTypeClass().isPrimitive();
    }

    public void setArrayArguments(List arguments) {
        this.fArrayArguments = arguments;
    }
}

