/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.proxy.core;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class ContainerPathContributionMapping {
    public Map containerIdToContributions = Collections.EMPTY_MAP;
    private final Class contributionType;

    public ContainerPathContributionMapping(Class type) {
        this.contributionType = type;
    }

    public Object[] getContributors(String containerId, String[] containerPaths) {
        ContainerContributionEntry[] bundleContributions = (ContainerContributionEntry[])this.containerIdToContributions.get(containerId);
        if (bundleContributions == null) {
            return (Object[])Array.newInstance(this.contributionType, 0);
        }
        ArrayList<Object> contributions = new ArrayList<Object>();
        HashMap<Pattern, Boolean> testedPatterns = new HashMap<Pattern, Boolean>();
        int i = 0;
        while (i < bundleContributions.length) {
            Boolean tested = (Boolean)testedPatterns.get(bundleContributions[i].getContainerPathPattern());
            if (tested == null) {
                tested = Boolean.FALSE;
                Pattern pattern = bundleContributions[i].getContainerPathPattern();
                int j = 0;
                while (j < containerPaths.length) {
                    if (pattern.matcher(containerPaths[j]).matches()) {
                        tested = Boolean.TRUE;
                        break;
                    }
                    ++j;
                }
                testedPatterns.put(pattern, tested);
            }
            if (tested.booleanValue()) {
                contributions.add(bundleContributions[i].getContribution());
            }
            ++i;
        }
        return contributions.toArray((Object[])Array.newInstance(this.contributionType, contributions.size()));
    }

    public void addContribution(String containerId, Pattern pattern, Object contribution) {
        Object contributions;
        if (this.containerIdToContributions == Collections.EMPTY_MAP) {
            this.containerIdToContributions = new HashMap();
        }
        if ((contributions = this.containerIdToContributions.get(containerId)) == null) {
            contributions = new ArrayList(1);
            this.containerIdToContributions.put(containerId, contributions);
        } else if (!(contributions instanceof List)) {
            List<Object> oldContributions = Arrays.asList((Object[])contribution);
            contributions = new ArrayList(oldContributions.size());
            ((List)contributions).addAll(oldContributions);
            this.containerIdToContributions.put(containerId, contributions);
        }
        ((List)contributions).add(new ContainerContributionEntry(contribution, pattern));
    }

    public void finalizeMapping() {
        Iterator iter = this.containerIdToContributions.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            if (!(entry.getValue() instanceof List)) continue;
            entry.setValue(((List)entry.getValue()).toArray(new ContainerContributionEntry[((List)entry.getValue()).size()]));
        }
    }

    public static class ContainerContributionEntry {
        private final Object contribution;
        private final Pattern containerPathPattern;

        public ContainerContributionEntry(Object contribution, Pattern containerPathPattern) {
            this.contribution = contribution;
            this.containerPathPattern = containerPathPattern;
        }

        public final Object getContribution() {
            return this.contribution;
        }

        public final Pattern getContainerPathPattern() {
            return this.containerPathPattern;
        }
    }
}

