/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.ui.tests;

import java.lang.reflect.Field;
import junit.framework.TestCase;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.swt.graphics.Image;

public class ImageDescriptorTest
extends TestCase {
    private final Class<?> clazz;

    public ImageDescriptorTest(Class<?> clazz) {
        super(ImageDescriptorTest.buildName(clazz));
        this.clazz = clazz;
    }

    private static String buildName(Class<?> clazz) {
        return String.valueOf(ImageDescriptorTest.class.getSimpleName()) + ": " + clazz.getName();
    }

    protected void runTest() throws Throwable {
        ResourceManager resourceManager = this.buildResourceManager();
        try {
            this.runTest(resourceManager);
        }
        finally {
            resourceManager.dispose();
        }
    }

    protected void runTest(ResourceManager resourceManager) throws Throwable {
        Field[] fieldArray = this.clazz.getFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            Object value = field.get(null);
            if (value instanceof ImageDescriptor) {
                ImageDescriptor descriptor = (ImageDescriptor)value;
                try {
                    Image image = resourceManager.createImage(descriptor);
                    ImageDescriptorTest.assertNotNull((Object)image);
                }
                catch (RuntimeException ex) {
                    ImageDescriptorTest.fail((String)("Problem loading image for ImageDescriptor defined in static field '" + this.clazz.getSimpleName() + '.' + field.getName() + "': " + descriptor + " - " + ex));
                }
            } else if (value == null) {
                ImageDescriptorTest.fail((String)("The static field '" + this.clazz.getSimpleName() + '.' + field.getName() + "' is null."));
            }
            ++n2;
        }
    }

    protected ResourceManager buildResourceManager() {
        return new LocalResourceManager(this.getParentResourceManager());
    }

    private ResourceManager getParentResourceManager() {
        return JFaceResources.getResources();
    }
}

