/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.core.tests.internal.projects;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jpt.common.core.tests.internal.projects.FacetedProjectTestHarness;
import org.eclipse.jpt.common.utility.internal.ArrayTools;

public class JavaProjectTestHarness
extends FacetedProjectTestHarness {
    private final IJavaProject javaProject;
    private final IPackageFragmentRoot sourceFolder;

    public JavaProjectTestHarness(String projectName) throws CoreException {
        this(projectName, false);
    }

    public JavaProjectTestHarness(String projectName, boolean autoBuild) throws CoreException {
        super(projectName, autoBuild);
        this.installFacet("jst.java", "5.0");
        this.javaProject = JavaCore.create((IProject)this.getProject());
        this.sourceFolder = this.javaProject.getPackageFragmentRoot((IResource)this.getProject().getFolder("src"));
    }

    public void addJar(String jarPath) throws JavaModelException {
        this.addClasspathEntry(JavaCore.newLibraryEntry((IPath)new Path(jarPath), null, null));
    }

    private void addClasspathEntry(IClasspathEntry entry) throws JavaModelException {
        this.javaProject.setRawClasspath((IClasspathEntry[])ArrayTools.add((Object[])this.javaProject.getRawClasspath(), (Object)entry), null);
    }

    public IJavaProject getJavaProject() {
        return this.javaProject;
    }

    public IPackageFragment createPackage(String packageName) throws CoreException {
        return this.sourceFolder.createPackageFragment(packageName, false, null);
    }

    public ICompilationUnit createCompilationUnit(String packageName, String compilationUnitName, String source) throws CoreException {
        return this.createCompilationUnit(this.createPackage(packageName), compilationUnitName, (SourceWriter)new SimpleSourceWriter(source));
    }

    public ICompilationUnit createCompilationUnit(String packageName, String compilationUnitName, SourceWriter sourceWriter) throws CoreException {
        return this.createCompilationUnit(this.createPackage(packageName), compilationUnitName, sourceWriter);
    }

    public ICompilationUnit createCompilationUnit(IPackageFragment packageFragment, String compilationUnitName, SourceWriter sourceWriter) throws CoreException {
        StringBuilder sb = new StringBuilder(2000);
        sourceWriter.appendSourceTo(sb);
        String source = sb.toString();
        return packageFragment.createCompilationUnit(compilationUnitName, source, false, null);
    }

    public class SimpleSourceWriter
    implements SourceWriter {
        private final String source;

        public SimpleSourceWriter(String source) {
            this.source = source;
        }

        @Override
        public void appendSourceTo(StringBuilder sb) {
            sb.append(this.source);
        }
    }

    public static interface SourceWriter {
        public void appendSourceTo(StringBuilder var1);
    }
}

