/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.jaxws.core.tests;

import java.util.ArrayList;
import javax.xml.ws.WebServiceRef;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jst.ws.annotations.core.AnnotationsCore;
import org.eclipse.jst.ws.annotations.core.utils.AnnotationUtils;
import org.eclipse.jst.ws.jaxws.core.tests.AbstractAnnotationTest;
import org.eclipse.ltk.core.refactoring.Change;

public class AddAnnotationToFieldTest
extends AbstractAnnotationTest {
    public String getPackageName() {
        return "com.example";
    }

    public String getClassName() {
        return "MyClass.java";
    }

    public String getClassContents() {
        return "package com.example;\n\npublic class MyClass {\n\n\tstatic String service;\n\n}";
    }

    public Annotation getAnnotation() {
        ArrayList<MemberValuePair> memberValuePairs = new ArrayList<MemberValuePair>();
        MemberValuePair wsdlLocationValuePair = AnnotationsCore.createStringMemberValuePair((AST)this.ast, (String)"wsdlLocation", (String)"http://localhost:8083/ServiceProject/servives/MyService?WSDL");
        memberValuePairs.add(wsdlLocationValuePair);
        return AnnotationsCore.createNormalAnnotation((AST)this.ast, (String)WebServiceRef.class.getSimpleName(), memberValuePairs);
    }

    public void testAddAnnotationToField() {
        try {
            AddAnnotationToFieldTest.assertNotNull((Object)this.annotation);
            AddAnnotationToFieldTest.assertEquals((String)WebServiceRef.class.getSimpleName(), (String)AnnotationUtils.getAnnotationName((Annotation)this.annotation));
            IField field = this.source.findPrimaryType().getField("service");
            AddAnnotationToFieldTest.assertNotNull((Object)field);
            this.textFileChange.addEdit(AnnotationUtils.createAddImportTextEdit((IJavaElement)field, (String)WebServiceRef.class.getCanonicalName()));
            this.textFileChange.addEdit(AnnotationUtils.createAddAnnotationTextEdit((IJavaElement)field, (Annotation)this.annotation));
            AddAnnotationToFieldTest.assertTrue((boolean)this.executeChange((IProgressMonitor)new NullProgressMonitor(), (Change)this.textFileChange));
            AddAnnotationToFieldTest.assertTrue((boolean)AnnotationUtils.isAnnotationPresent((IJavaElement)field, (String)AnnotationUtils.getAnnotationName((Annotation)this.annotation)));
            AddAnnotationToFieldTest.assertTrue((boolean)this.source.getImport(WebServiceRef.class.getCanonicalName()).exists());
        }
        catch (CoreException ce) {
            AddAnnotationToFieldTest.fail((String)ce.getLocalizedMessage());
        }
    }
}

