/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.core.tests.contentmodel;

import org.eclipse.wst.xml.core.internal.contentmodel.CMDocument;
import org.eclipse.wst.xml.core.internal.contentmodel.CMElementDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNamedNodeMap;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNode;
import org.eclipse.wst.xml.core.internal.contentmodel.ContentModelManager;
import org.eclipse.wst.xml.core.internal.contentmodel.internal.util.CMValidator;

public class CMValidatorTest {
    public static void main(String[] arg) {
        block9: {
            if (arg.length > 1) {
                try {
                    String grammarFileName = arg[0];
                    String elementName = arg[1];
                    CMDocument cmDocument = ContentModelManager.getInstance().createCMDocument(grammarFileName, null);
                    CMNamedNodeMap elementMap = cmDocument.getElements();
                    CMElementDeclaration element = (CMElementDeclaration)elementMap.getNamedItem(elementName);
                    if (element != null) {
                        CMValidatorTest.println("-------------- begin validate ---------------");
                        CMValidator.StringElementContentComparator comparator = new CMValidator.StringElementContentComparator();
                        CMValidator validator = new CMValidator();
                        CMValidator.ElementPathRecordingResult result = new CMValidator.ElementPathRecordingResult();
                        validator.getOriginArray(element, CMValidator.createStringList((String[])arg, (int)2), (CMValidator.ElementContentComparator)comparator, result);
                        if (result.isValid) {
                            CMNode[] nodeMapping = result.getOriginArray();
                            CMValidatorTest.println("Validation Success!");
                            CMValidatorTest.print("  ");
                            int i = 0;
                            while (i < nodeMapping.length) {
                                String name = nodeMapping[i] != null ? nodeMapping[i].getNodeName() : "null";
                                CMValidatorTest.print("[" + name + "]");
                                ++i;
                            }
                            CMValidatorTest.println("");
                        } else {
                            CMValidatorTest.println("Validation Failed! ");
                            if (result.errorMessage != null) {
                                CMValidatorTest.println("  " + result.errorMessage);
                            }
                        }
                        CMValidatorTest.println("-------------- end validate ---------------");
                        break block9;
                    }
                    CMValidatorTest.println("element [" + elementName + "] can not be found");
                }
                catch (Exception e) {
                    CMValidatorTest.println("CMValidator error");
                    e.printStackTrace();
                }
            } else {
                CMValidatorTest.println("2 args required... only " + arg.length + " provided");
                CMValidatorTest.println("usage java org.eclipse.wst.newxml.util.XMLUtil grammarFileName rootElementName pattern");
            }
        }
    }

    public static void print(String string) {
    }

    public static void println(String string) {
    }

    public static void printlnIndented(int indent, String string) {
    }
}

