/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.tests.internal.iterable;

import java.util.ArrayList;
import junit.framework.TestCase;
import org.eclipse.jpt.common.utility.internal.iterable.CompositeListIterable;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.internal.iterable.ListListIterable;
import org.eclipse.jpt.common.utility.iterable.ListIterable;

public class CompositeListIterableTests
extends TestCase {
    public CompositeListIterableTests(String name) {
        super(name);
    }

    public void testIterator() {
        ArrayList<String> c1 = new ArrayList<String>();
        c1.add("0");
        c1.add("1");
        c1.add("2");
        c1.add("3");
        ArrayList<String> c2 = new ArrayList<String>();
        c2.add("4");
        c2.add("5");
        c2.add("6");
        c2.add("7");
        ListIterable composite = IterableTools.concatenate((ListIterable[])new ListIterable[]{IterableTools.listIterable(c1), IterableTools.listIterable(c2)});
        int i = 0;
        for (String s : composite) {
            CompositeListIterableTests.assertEquals((String)String.valueOf(i++), (String)s);
        }
    }

    public void testExtraElement1() {
        ArrayList<String> c1 = new ArrayList<String>();
        c1.add("0");
        c1.add("1");
        c1.add("2");
        c1.add("3");
        ListIterable composite = IterableTools.add((ListIterable)IterableTools.listIterable(c1), (Object)"4");
        int i = 0;
        for (String s : composite) {
            CompositeListIterableTests.assertEquals((String)String.valueOf(i++), (String)s);
        }
    }

    public void testExtraElement2() {
        ArrayList<String> c1 = new ArrayList<String>();
        c1.add("1");
        c1.add("2");
        c1.add("3");
        ListIterable composite = IterableTools.insert((Object)"0", (ListIterable)IterableTools.listIterable(c1));
        int i = 0;
        for (String s : composite) {
            CompositeListIterableTests.assertEquals((String)String.valueOf(i++), (String)s);
        }
    }

    public void testCollectionOfIterables() {
        ArrayList<String> c1 = new ArrayList<String>();
        c1.add("0");
        c1.add("1");
        c1.add("2");
        c1.add("3");
        ArrayList<String> c2 = new ArrayList<String>();
        c2.add("4");
        c2.add("5");
        c2.add("6");
        c2.add("7");
        ArrayList<ListListIterable> collection = new ArrayList<ListListIterable>();
        collection.add(new ListListIterable(c1));
        collection.add(new ListListIterable(c2));
        ListListIterable li = new ListListIterable(collection);
        CompositeListIterable composite = new CompositeListIterable((ListIterable)li);
        int i = 0;
        for (String s : composite) {
            CompositeListIterableTests.assertEquals((String)String.valueOf(i++), (String)s);
        }
    }

    public void testToString() {
        ArrayList<String> c1 = new ArrayList<String>();
        c1.add("0");
        c1.add("1");
        c1.add("2");
        c1.add("3");
        ArrayList<String> c2 = new ArrayList<String>();
        c2.add("4");
        c2.add("5");
        c2.add("6");
        c2.add("7");
        ListIterable composite = IterableTools.concatenate((ListIterable[])new ListIterable[]{IterableTools.listIterable(c1), IterableTools.listIterable(c2)});
        CompositeListIterableTests.assertNotNull((Object)composite.toString());
    }
}

