/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.tests.internal;

import junit.framework.TestCase;
import org.eclipse.jpt.common.utility.Association;
import org.eclipse.jpt.common.utility.internal.SimpleAssociation;
import org.eclipse.jpt.common.utility.tests.internal.TestTools;

public class SimpleAssociationTests
extends TestCase {
    private SimpleAssociation<String, String> assoc;

    public SimpleAssociationTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.assoc = new SimpleAssociation((Object)"foo", (Object)"bar");
    }

    protected void tearDown() throws Exception {
        TestTools.clear(this);
        super.tearDown();
    }

    public void testGetKey() {
        SimpleAssociationTests.assertEquals((String)"foo", (String)((String)this.assoc.getKey()));
    }

    public void testGetValue() {
        SimpleAssociationTests.assertEquals((String)"bar", (String)((String)this.assoc.getValue()));
    }

    public void testSetValue() {
        SimpleAssociationTests.assertEquals((String)"bar", (String)((String)this.assoc.getValue()));
        this.assoc.setValue((Object)"baz");
        SimpleAssociationTests.assertEquals((String)"baz", (String)((String)this.assoc.getValue()));
    }

    public void testEquals() {
        SimpleAssociationTests.assertFalse((boolean)this.assoc.equals((Object)"foo"));
        SimpleAssociationTests.assertEquals(this.assoc, this.copy(this.assoc));
        SimpleAssociation assoc2 = new SimpleAssociation((Object)"foo", (Object)"baz");
        SimpleAssociationTests.assertFalse((boolean)this.assoc.equals((Object)assoc2));
        assoc2 = new SimpleAssociation((Object)"fop", (Object)"bar");
        SimpleAssociationTests.assertFalse((boolean)this.assoc.equals((Object)assoc2));
        SimpleAssociation assoc3 = new SimpleAssociation(null, null);
        SimpleAssociation assoc4 = new SimpleAssociation(null, null);
        SimpleAssociationTests.assertEquals((Object)assoc3, (Object)assoc4);
    }

    public void testHashCode() {
        SimpleAssociationTests.assertEquals((int)this.assoc.hashCode(), (int)this.copy(this.assoc).hashCode());
        SimpleAssociation assoc2 = new SimpleAssociation(null, null);
        SimpleAssociationTests.assertEquals((int)assoc2.hashCode(), (int)this.copy((SimpleAssociation<String, String>)assoc2).hashCode());
    }

    public void testToString() {
        SimpleAssociationTests.assertNotNull((Object)this.assoc.toString());
    }

    public void testClone() {
        this.verifyClone((Association<String, String>)this.assoc, (Association<String, String>)this.assoc.clone());
    }

    private void verifyClone(Association<String, String> expected, Association<String, String> actual) {
        SimpleAssociationTests.assertEquals(expected, actual);
        SimpleAssociationTests.assertNotSame(expected, actual);
        SimpleAssociationTests.assertEquals((String)((String)expected.getKey()), (String)((String)actual.getKey()));
        SimpleAssociationTests.assertSame((Object)expected.getKey(), (Object)actual.getKey());
        SimpleAssociationTests.assertEquals((String)((String)expected.getValue()), (String)((String)actual.getValue()));
        SimpleAssociationTests.assertSame((Object)expected.getValue(), (Object)actual.getValue());
    }

    public void testSerialization() throws Exception {
        Association assoc2 = (Association)TestTools.serialize(this.assoc);
        SimpleAssociationTests.assertEquals(this.assoc, (Object)assoc2);
        SimpleAssociationTests.assertNotSame(this.assoc, (Object)assoc2);
        SimpleAssociationTests.assertEquals((String)((String)this.assoc.getKey()), (String)((String)assoc2.getKey()));
        SimpleAssociationTests.assertNotSame((Object)this.assoc.getKey(), (Object)assoc2.getKey());
        SimpleAssociationTests.assertEquals((String)((String)this.assoc.getValue()), (String)((String)assoc2.getValue()));
        SimpleAssociationTests.assertNotSame((Object)this.assoc.getValue(), (Object)assoc2.getValue());
    }

    private SimpleAssociation<String, String> copy(SimpleAssociation<String, String> sa) {
        return new SimpleAssociation((Object)((String)sa.getKey()), (Object)((String)sa.getValue()));
    }
}

