/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.internal.audio;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.help.IWorkbenchHelpSystem;
import org.eclipse.wst.server.ui.internal.Messages;
import org.eclipse.wst.server.ui.internal.SWTUtil;
import org.eclipse.wst.server.ui.internal.Trace;
import org.eclipse.wst.server.ui.internal.audio.AudioCore;
import org.eclipse.wst.server.ui.internal.audio.AudioTableContentProvider;
import org.eclipse.wst.server.ui.internal.audio.AudioTableLabelProvider;
import org.eclipse.wst.server.ui.internal.audio.CategoryTableViewer;
import org.eclipse.wst.server.ui.internal.audio.Sound;

public class AudioPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    protected Button enableButton;
    protected Spinner volume;
    protected Map<String, IPath> userSoundMap;
    protected CategoryTableViewer viewer;
    boolean soundAvailable = true;

    public AudioPreferencePage() {
        this.loadUserMapInfo();
    }

    protected IPath chooseAudioFile() {
        FileDialog dialog = new FileDialog(this.getShell(), 4);
        dialog.setText(Messages.audioPrefSelectFile);
        dialog.setFilterExtensions(new String[]{"*.au;*.wav"});
        dialog.setFilterPath(null);
        dialog.open();
        String[] filenames = dialog.getFileNames();
        if (filenames != null && filenames.length > 0) {
            String filterPath = dialog.getFilterPath();
            return new Path(String.valueOf(filterPath) + File.separator + filenames[0]);
        }
        return null;
    }

    protected Control createContents(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        IWorkbenchHelpSystem whs = PlatformUI.getWorkbench().getHelpSystem();
        whs.setHelp((Control)parent, "org.eclipse.wst.server.ui.aupr0000");
        final AudioCore core = AudioCore.getInstance();
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(3);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(784);
        composite.setLayoutData((Object)data);
        this.enableButton = new Button(composite, 32);
        this.enableButton.setText(Messages.audioPrefEnable);
        this.enableButton.setSelection(AudioCore.getInstance().isSoundEnabled());
        data = new GridData(256);
        data.horizontalSpan = 3;
        this.enableButton.setLayoutData((Object)data);
        whs.setHelp((Control)this.enableButton, "org.eclipse.wst.server.ui.aupr0002");
        final Label volumeLabel = new Label(composite, 0);
        volumeLabel.setText(Messages.audioPrefVolume);
        data = new GridData();
        data.horizontalIndent = 20;
        volumeLabel.setLayoutData((Object)data);
        volumeLabel.setEnabled(this.enableButton.getSelection());
        this.volume = new Spinner(composite, 2048);
        this.volume.setMinimum(0);
        this.volume.setMaximum(20);
        this.volume.setSelection(AudioCore.getInstance().getVolume());
        data = new GridData(32);
        data.horizontalSpan = 2;
        data.widthHint = 60;
        this.volume.setLayoutData((Object)data);
        this.volume.setEnabled(this.enableButton.getSelection());
        whs.setHelp((Control)this.volume, "org.eclipse.wst.server.ui.aupr0004");
        this.enableButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                volumeLabel.setEnabled(AudioPreferencePage.this.enableButton.getSelection());
                AudioPreferencePage.this.volume.setEnabled(AudioPreferencePage.this.enableButton.getSelection());
            }
        });
        Label label = new Label(composite, 0);
        data = new GridData();
        data.horizontalSpan = 3;
        label.setLayoutData((Object)data);
        label = new Label(composite, 0);
        label.setText(Messages.audioPrefSounds);
        data = new GridData();
        data.horizontalSpan = 3;
        label.setLayoutData((Object)data);
        final Table table = new Table(composite, 68388);
        data = new GridData(1808);
        data.horizontalSpan = 2;
        table.setLayoutData((Object)data);
        whs.setHelp((Control)table, "org.eclipse.wst.server.ui.aupr0006");
        this.viewer = new CategoryTableViewer(table);
        TableLayout tableLayout = new TableLayout();
        table.setLayout((Layout)tableLayout);
        table.setHeaderVisible(true);
        tableLayout.addColumnData((ColumnLayoutData)new ColumnPixelData(23, false));
        TableColumn col = new TableColumn(table, 0x1000000, 0);
        col.setResizable(false);
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(11, 110, true));
        col = new TableColumn(table, 0, 1);
        col.setText(Messages.audioPrefSound);
        col.setResizable(true);
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(15, 150, true));
        col = new TableColumn(table, 0, 2);
        col.setText(Messages.audioPrefFile);
        col.setResizable(true);
        this.viewer.setContentProvider((IContentProvider)new AudioTableContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new AudioTableLabelProvider(this));
        this.viewer.setInput("root");
        this.setCheckState(this.viewer);
        this.viewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                boolean checked = event.getChecked();
                Object obj = event.getElement();
                if (obj instanceof String) {
                    String id = (String)obj;
                    core.setCategoryEnabled(id, checked);
                    for (Sound s : AudioTableContentProvider.getSoundsByCategory(id)) {
                        AudioPreferencePage.this.viewer.setChecked(s, checked);
                        core.setSoundEnabled(s.getId(), checked);
                    }
                } else {
                    Sound sound = (Sound)obj;
                    core.setSoundEnabled(sound.getId(), checked);
                }
            }
        });
        Composite right = new Composite(composite, 0);
        layout = new GridLayout();
        layout.numColumns = 1;
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        right.setLayout((Layout)layout);
        data = new GridData(144);
        right.setLayoutData((Object)data);
        final Button playButton = SWTUtil.createButton(right, Messages.audioPrefPlay);
        playButton.setEnabled(false);
        whs.setHelp((Control)playButton, "org.eclipse.wst.server.ui.aupr0008");
        final Button browseButton = SWTUtil.createButton(right, Messages.audioPrefBrowse);
        browseButton.setEnabled(false);
        whs.setHelp((Control)browseButton, "org.eclipse.wst.server.ui.aupr0010");
        final Button resetButton = SWTUtil.createButton(right, Messages.audioPrefReset);
        resetButton.setEnabled(false);
        whs.setHelp((Control)resetButton, "org.eclipse.wst.server.ui.aupr0012");
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                block8: {
                    try {
                        IStructuredSelection sel = (IStructuredSelection)event.getSelection();
                        Object obj = sel.getFirstElement();
                        if (obj instanceof Sound) {
                            Sound sound = (Sound)obj;
                            URL url = AudioPreferencePage.this.getSoundURL(sound.getId());
                            if (url != null && AudioPreferencePage.this.soundAvailable) {
                                playButton.setEnabled(true);
                            } else {
                                playButton.setEnabled(false);
                            }
                            browseButton.setEnabled(true);
                            if (AudioPreferencePage.this.getUserSoundPath(sound.getId()) != null) {
                                resetButton.setEnabled(true);
                            } else {
                                resetButton.setEnabled(false);
                            }
                        } else {
                            playButton.setEnabled(false);
                            browseButton.setEnabled(false);
                            resetButton.setEnabled(false);
                        }
                    }
                    catch (Exception ex) {
                        if (!Trace.SEVERE) break block8;
                        Trace.trace("/severe", "Error in table selection", ex);
                    }
                }
            }
        });
        this.soundAvailable = AudioCore.isAudioSupported();
        if (this.soundAvailable) {
            playButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    block2: {
                        try {
                            int sel = table.getSelectionIndex();
                            Sound sound = (Sound)table.getItem(sel).getData();
                            AudioCore.playSound(AudioPreferencePage.this.getSoundURL(sound.getId()), AudioPreferencePage.this.volume.getSelection());
                        }
                        catch (Exception ex) {
                            if (!Trace.SEVERE) break block2;
                            Trace.trace("/severe", "Error in table selection", ex);
                        }
                    }
                }
            });
        } else {
            playButton.setEnabled(false);
        }
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                block3: {
                    try {
                        IPath path = AudioPreferencePage.this.chooseAudioFile();
                        if (path != null) {
                            int sel = table.getSelectionIndex();
                            Sound sound = (Sound)table.getItem(sel).getData();
                            AudioPreferencePage.this.setUserSoundPath(sound.getId(), path);
                            AudioPreferencePage.this.viewer.refresh(sound);
                            playButton.setEnabled(true);
                        }
                    }
                    catch (Exception ex) {
                        if (!Trace.SEVERE) break block3;
                        Trace.trace("/severe", "Error browsing", ex);
                    }
                }
            }
        });
        resetButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                block2: {
                    try {
                        int sel = table.getSelectionIndex();
                        Sound sound = (Sound)table.getItem(sel).getData();
                        AudioPreferencePage.this.removeUserSoundPath(sound.getId());
                        AudioPreferencePage.this.viewer.refresh(sound);
                    }
                    catch (Exception ex) {
                        if (!Trace.SEVERE) break block2;
                        Trace.trace("/severe", "Error reseting sound", ex);
                    }
                }
            }
        });
        Dialog.applyDialogFont((Control)composite);
        return composite;
    }

    protected void setCheckState(CheckboxTableViewer viewer) {
        AudioCore core = AudioCore.getInstance();
        Map<String, String> categories = core.getCategories();
        ArrayList<String> cats = new ArrayList<String>();
        Iterator<String> iterator = categories.keySet().iterator();
        while (iterator.hasNext()) {
            cats.add(iterator.next());
        }
        for (String id : categories.keySet()) {
            List<Sound> l = AudioTableContentProvider.getSoundsByCategory(id);
            if (l.isEmpty()) continue;
            if (core.isCategoryEnabled(id)) {
                viewer.setChecked((Object)id, true);
            }
            int size = l.size();
            int i = 0;
            while (i < size) {
                Sound s = l.get(i);
                if (core.isSoundEnabled(s.getId())) {
                    viewer.setChecked((Object)s, true);
                }
                ++i;
            }
        }
        List<Sound> l = AudioTableContentProvider.getSoundsByCategory(null);
        if (!l.isEmpty()) {
            int size = l.size();
            int i = 0;
            while (i < size) {
                Sound s = l.get(i);
                if (core.isSoundEnabled(s.getId())) {
                    viewer.setChecked((Object)s, true);
                }
                ++i;
            }
        }
    }

    protected URL getSoundURL(String id) {
        try {
            IPath path = this.userSoundMap.get(id);
            if (path != null) {
                return path.toFile().toURL();
            }
        }
        catch (Exception exception) {}
        return AudioCore.getInstance().getSound(id).getLocation();
    }

    protected IPath getUserSoundPath(String id) {
        try {
            IPath path = this.userSoundMap.get(id);
            if (path != null) {
                return path;
            }
        }
        catch (Exception exception) {}
        return null;
    }

    public void init(IWorkbench workbench) {
    }

    protected void loadUserMapInfo() {
        Map<String, IPath> map = AudioCore.getInstance().getUserSoundMap();
        this.userSoundMap = new HashMap<String, IPath>(map.size());
        for (String id : map.keySet()) {
            IPath path = map.get(id);
            this.userSoundMap.put(id, path);
        }
    }

    protected void performDefaults() {
        AudioCore core = AudioCore.getInstance();
        this.enableButton.setSelection(core.getDefaultSoundsEnabled());
        this.volume.setSelection(core.getDefaultVolume());
        this.userSoundMap = new HashMap<String, IPath>();
        this.viewer.refresh();
        super.performDefaults();
    }

    public boolean performOk() {
        AudioCore core = AudioCore.getInstance();
        core.setSoundsEnabled(this.enableButton.getSelection());
        core.setVolume(this.volume.getSelection());
        core.setUserSoundMap(this.userSoundMap);
        this.viewer.refresh();
        return super.performOk();
    }

    protected void removeUserSoundPath(String id) {
        if (this.userSoundMap.containsKey(id)) {
            this.userSoundMap.remove(id);
        }
    }

    protected void saveUserMapInfo() {
        Map<String, IPath> map = AudioCore.getInstance().getUserSoundMap();
        this.userSoundMap = new HashMap<String, IPath>(map.size());
        for (String id : map.keySet()) {
            IPath path = map.get(id);
            this.userSoundMap.put(id, path);
        }
    }

    protected void setUserSoundPath(String id, IPath path) {
        this.userSoundMap.put(id, path);
    }
}

