/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.internal.environment.eclipse;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.environment.IEnvironment;
import org.eclipse.wst.common.environment.uri.IURI;
import org.eclipse.wst.common.environment.uri.IURIScheme;
import org.eclipse.wst.common.environment.uri.URIException;
import org.eclipse.wst.common.internal.environment.eclipse.EclipseURI;
import org.eclipse.wst.common.internal.environment.eclipse.Messages;
import org.eclipse.wst.common.internal.environment.relative.RelativeURI;

public class EclipseScheme
implements IURIScheme {
    private IEnvironment environment_;

    public EclipseScheme(IEnvironment environment) {
        this.environment_ = environment;
    }

    public String toString() {
        return "platform";
    }

    public boolean isHierarchical() {
        return true;
    }

    public boolean isValid(IURI uri) {
        boolean result = true;
        if (uri == null) {
            return false;
        }
        try {
            IURIScheme scheme = uri.getURIScheme();
            if (scheme.toString().equals("relative")) {
                return scheme.isValid(uri);
            }
            this.getPathFromPlatformURI(uri.toString());
        }
        catch (URIException uRIException) {
            result = false;
        }
        return result;
    }

    public IURI newURI(String uri) throws URIException {
        String newURI = null;
        if (uri != null && uri.startsWith("platform:")) {
            newURI = uri;
        } else {
            if (uri == null || uri.indexOf(":") != -1) {
                throw new URIException((IStatus)new Status(4, "id", 0, NLS.bind((String)Messages.MSG_INVALID_PLATFORM_URL, (Object)uri), null));
            }
            if (uri.startsWith("/")) {
                newURI = "platform:/resource" + uri;
            }
        }
        if (newURI == null) {
            return new RelativeURI(uri);
        }
        return new EclipseURI(newURI, this.environment_);
    }

    public IURI newURI(IURI uri) throws URIException {
        return this.newURI(uri == null ? null : uri.toString());
    }

    public IURI newURI(URL url) throws URIException {
        return this.newURI(url == null ? null : url.toString());
    }

    public IStatus validate(IURI uri) {
        IStatus status = null;
        try {
            IURIScheme scheme = uri.getURIScheme();
            if (scheme.toString().equals("relative")) {
                return scheme.validate(uri);
            }
            this.getPathFromPlatformURI(uri.toString());
            status = Status.OK_STATUS;
        }
        catch (URIException exc) {
            status = exc.getStatus();
        }
        return status;
    }

    public String getPathFromPlatformURI(String uri) throws URIException {
        String resourceFile = null;
        URL url = null;
        try {
            url = new URL(uri);
        }
        catch (MalformedURLException exc) {
            throw new URIException((IStatus)new Status(4, "id", 0, NLS.bind((String)Messages.MSG_INVALID_PLATFORM_URL, (Object)uri), (Throwable)exc));
        }
        if (url.getProtocol().equals("platform")) {
            String resourceURL = url.getFile();
            if (resourceURL.startsWith("/resource")) {
                resourceFile = resourceURL.substring(10);
            }
        } else {
            throw new URIException((IStatus)new Status(4, "id", 0, NLS.bind((String)Messages.MSG_INVALID_PLATFORM_URL, (Object)url.getFile()), null));
        }
        return resourceFile;
    }

    public String getURLFromPath(IPath absolutePath) {
        return "platform:/resource" + absolutePath;
    }
}

