/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.test.util.mock.java;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jst.jsf.test.util.mock.IWorkspaceContext;
import org.eclipse.jst.jsf.test.util.mock.MockFile;
import org.eclipse.jst.jsf.test.util.mock.MockProject;
import org.eclipse.jst.jsf.test.util.mock.java.MockJavaProject;
import org.eclipse.jst.jsf.test.util.mock.java.MockPackageFragmentRoot;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockJDTWorkspaceContext {
    private final IWorkspaceContext _wsContext;
    private final Map<IProject, List<IPackageFragmentRoot>> _cpEntriesByProject;
    private final CopyOnWriteArrayList<IElementChangedListener> _listeners = new CopyOnWriteArrayList();

    public MockJDTWorkspaceContext(IWorkspaceContext wsContext) {
        this._wsContext = wsContext;
        this._cpEntriesByProject = new HashMap<IProject, List<IPackageFragmentRoot>>();
    }

    public MockJavaProject createJavaProject(IProject project) {
        List<IPackageFragmentRoot> cpEntries = this._cpEntriesByProject.get(project);
        return new MockJavaProject(project, cpEntries != null ? Collections.unmodifiableList(cpEntries) : Collections.EMPTY_LIST);
    }

    public void loadCPEntriesFromProject(final IProject project) throws CoreException {
        project.accept(new IResourceVisitor(){

            public boolean visit(IResource resource) throws CoreException {
                if (resource.getType() == 1 && "jar".equals(resource.getFullPath().getFileExtension())) {
                    MockJDTWorkspaceContext.this.createAndAddPackageFragmentRoot((MockProject)project, ((MockFile)resource).getLocation());
                }
                return true;
            }
        });
    }

    public IPackageFragmentRoot createCPELibraryInProject(IProject project, IPath projectRelativePath, File file) {
        try {
            this._wsContext.attachFile(project, projectRelativePath, file);
            return this.createAndAddPackageFragmentRoot(project, (IPath)new Path(file.getAbsolutePath()));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private IPackageFragmentRoot createAndAddPackageFragmentRoot(IProject project, IPath absPathToRoot) {
        MockJavaProject javaProject = this.createJavaProject(project);
        MockPackageFragmentRoot fragRoot = new MockPackageFragmentRoot(javaProject, absPathToRoot);
        this.addCPEntry(project, fragRoot);
        return fragRoot;
    }

    private void addCPEntry(IProject project, IPackageFragmentRoot packageRoot) {
        List<IPackageFragmentRoot> entriesForProject = this._cpEntriesByProject.get(project);
        if (entriesForProject == null) {
            entriesForProject = new ArrayList<IPackageFragmentRoot>();
            this._cpEntriesByProject.put(project, entriesForProject);
        }
        entriesForProject.add(packageRoot);
    }

    public void addElementChangedListener(IElementChangedListener listener) {
        this._listeners.addIfAbsent(listener);
    }

    public void removeElementChangedListener(IElementChangedListener listener) {
        this._listeners.remove(listener);
    }

    public void fireElementChangedEvent(ElementChangedEvent event) {
        for (IElementChangedListener listener : this._listeners) {
            listener.elementChanged(event);
        }
    }

    public Collection<IElementChangedListener> getListeners() {
        return Collections.unmodifiableList(this._listeners);
    }
}

