/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facesconfig.ui.pageflow.util;

import org.eclipse.jst.jsf.facesconfig.emf.DescriptionType;
import org.eclipse.jst.jsf.facesconfig.emf.DisplayNameType;
import org.eclipse.jst.jsf.facesconfig.emf.IconType;
import org.eclipse.jst.jsf.facesconfig.emf.NavigationCaseType;
import org.eclipse.jst.jsf.facesconfig.emf.NavigationRuleType;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.model.Pageflow;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.model.PageflowPage;

public class PageflowTransform {
    private static PageflowTransform transform;

    private PageflowTransform() {
    }

    public static PageflowTransform getInstance() {
        if (transform == null) {
            transform = new PageflowTransform();
        }
        return transform;
    }

    public void updatePageflowSourcePage(PageflowPage sourcePage, NavigationRuleType navigationRuleFC) {
        if (navigationRuleFC.getDescription() != null && navigationRuleFC.getDescription().size() > 0) {
            String description = ((DescriptionType)navigationRuleFC.getDescription().get(0)).getTextContent();
            sourcePage.setComment(description);
        }
        if (navigationRuleFC.getDisplayName() != null && navigationRuleFC.getDisplayName().size() > 0) {
            String displayName = ((DisplayNameType)navigationRuleFC.getDisplayName().get(0)).getTextContent();
            sourcePage.setName(displayName);
        }
        if (navigationRuleFC.getIcon() != null && navigationRuleFC.getIcon().size() > 0) {
            boolean largeUpdated = false;
            boolean smallUpdated = false;
            int i = 0;
            while (i < navigationRuleFC.getIcon().size()) {
                IconType icon = (IconType)navigationRuleFC.getIcon().get(i);
                if (!largeUpdated && icon.getLargeIcon() != null) {
                    sourcePage.setLargeicon(icon.getLargeIcon().getTextContent());
                    largeUpdated = true;
                }
                if (!smallUpdated && icon.getSmallIcon() != null) {
                    sourcePage.setSmallicon(icon.getSmallIcon().getTextContent());
                    smallUpdated = true;
                }
                if (largeUpdated && smallUpdated) {
                    return;
                }
                ++i;
            }
        }
    }

    public void updatePageflowTargetPage(PageflowPage targetPage, NavigationCaseType navigationCaseFC) {
        if (navigationCaseFC.getDescription() != null && navigationCaseFC.getDescription().size() > 0) {
            String description = ((DescriptionType)navigationCaseFC.getDescription().get(0)).getTextContent();
            targetPage.setComment(description);
        }
        if (navigationCaseFC.getDisplayName() != null && navigationCaseFC.getDisplayName().size() > 0) {
            String displayName = ((DisplayNameType)navigationCaseFC.getDisplayName().get(0)).getTextContent();
            targetPage.setName(displayName);
        }
        if (navigationCaseFC.getIcon() != null && navigationCaseFC.getIcon().size() > 0) {
            boolean largeUpdated = false;
            boolean smallUpdated = false;
            int i = 0;
            while (i < navigationCaseFC.getIcon().size()) {
                IconType icon = (IconType)navigationCaseFC.getIcon().get(0);
                if (!largeUpdated && icon.getLargeIcon() != null) {
                    targetPage.setLargeicon(icon.getLargeIcon().getTextContent());
                    largeUpdated = true;
                }
                if (!smallUpdated && icon.getSmallIcon() != null) {
                    targetPage.setSmallicon(icon.getSmallIcon().getTextContent());
                    smallUpdated = true;
                }
                if (largeUpdated && smallUpdated) {
                    return;
                }
                ++i;
            }
        }
    }

    public static void updatePageflowModelInfo(Pageflow newPageflow, Pageflow oldPageflow) {
        if (newPageflow == null || oldPageflow == null) {
            return;
        }
        newPageflow.setName(oldPageflow.getName());
        newPageflow.setComment(oldPageflow.getComment());
        newPageflow.setConfigfile(oldPageflow.getConfigfile());
    }
}

