/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.wizard;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.vorto.codegen.ui.utils.WizardUtil;
import org.eclipse.vorto.core.ui.IMessageDisplay;
import org.eclipse.vorto.core.ui.MessageDisplayFactory;
import org.eclipse.vorto.core.ui.model.IModelProject;
import org.eclipse.vorto.core.ui.model.ModelProjectFactory;
import org.eclipse.vorto.wizard.ModelBaseWizardPage;

public abstract class AbstractVortoWizard
extends Wizard
implements INewWizard,
IExecutableExtension {
    private IConfigurationElement configurationElement;
    private IWorkbench workbench;
    private IStructuredSelection selection;
    private IMessageDisplay console = MessageDisplayFactory.getMessageDisplay();

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.workbench = workbench;
        this.selection = selection;
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        this.configurationElement = config;
    }

    public void openTypeWithDefaultEditor(ModelBaseWizardPage iotWizardPage) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject project = workspace.getRoot().getProject(iotWizardPage.getProjectName());
        IModelProject modelProject = ModelProjectFactory.getInstance().getProject(project);
        final IFile modelFile = modelProject.getModelElementById(iotWizardPage.getModelId()).getModelFile();
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchPage page;
                IWorkbenchWindow activeWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                if (activeWindow != null && (page = activeWindow.getActivePage()) != null) {
                    try {
                        IDE.openEditor((IWorkbenchPage)page, (IFile)modelFile);
                    }
                    catch (PartInitException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        });
    }

    public IConfigurationElement getConfigurationElement() {
        if (this.configurationElement != null) {
            return this.configurationElement;
        }
        return WizardUtil.getWizardConfigurationElement((String)((Object)((Object)this)).getClass().getName());
    }

    public IWorkbench getWorkbench() {
        return this.workbench;
    }

    public void setWorkbench(IWorkbench workbench) {
        this.workbench = workbench;
    }

    public IStructuredSelection getSelection() {
        return this.selection;
    }

    public void setSelection(IStructuredSelection selection) {
        this.selection = selection;
    }

    public IMessageDisplay getConsole() {
        return this.console;
    }

    public void setConsole(IMessageDisplay console) {
        this.console = console;
    }

    public void setConfigurationElement(IConfigurationElement configurationElement) {
        this.configurationElement = configurationElement;
    }
}

