/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.codegen.webui.templates.service.bosch.internal;

import org.eclipse.vorto.codegen.api.IFileTemplate;
import org.eclipse.vorto.codegen.api.InvocationContext;
import org.eclipse.vorto.codegen.webui.templates.TemplateUtils;
import org.eclipse.vorto.core.api.model.informationmodel.InformationModel;
import org.eclipse.xtend2.lib.StringConcatenation;

public class ThingsInvocationTemplate
implements IFileTemplate<InformationModel> {
    public String getFileName(InformationModel context) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"ThingsInvocationTemplate.java");
        return _builder.toString();
    }

    public String getPath(InformationModel context) {
        StringConcatenation _builder = new StringConcatenation();
        String _baseApplicationPath = TemplateUtils.getBaseApplicationPath(context);
        _builder.append((Object)_baseApplicationPath, "");
        _builder.append((Object)"/service/bosch/internal");
        return _builder.toString();
    }

    public String getContent(InformationModel element, InvocationContext context) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"package com.example.iot.");
        String _name = element.getName();
        String _lowerCase = _name.toLowerCase();
        _builder.append((Object)_lowerCase, "");
        _builder.append((Object)".service.bosch.internal;");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"import org.apache.http.HttpHeaders;");
        _builder.newLine();
        _builder.append((Object)"import org.apache.http.client.methods.HttpUriRequest;");
        _builder.newLine();
        _builder.append((Object)"import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;");
        _builder.newLine();
        _builder.append((Object)"import org.springframework.security.core.Authentication;");
        _builder.newLine();
        _builder.append((Object)"import org.springframework.security.core.context.SecurityContextHolder;");
        _builder.newLine();
        _builder.append((Object)"import org.springframework.security.oauth2.client.OAuth2ClientContext;");
        _builder.newLine();
        _builder.append((Object)"import org.springframework.security.oauth2.provider.OAuth2Authentication;");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"import com.example.iot.");
        String _name_1 = element.getName();
        String _lowerCase_1 = _name_1.toLowerCase();
        _builder.append((Object)_lowerCase_1, "");
        _builder.append((Object)".service.bosch.permissions.IMUserInfo;");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"import com.google.gson.GsonBuilder;");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"public class ThingsInvocationTemplate extends AsyncInvocationTemplate {");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"private String apiToken;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"private OAuth2ClientContext oauthClientContext;");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"private final static String CR_API_TOKEN_HEADER = \"x-cr-api-token\";");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public ThingsInvocationTemplate(String apiToken, OAuth2ClientContext oauthClientContext) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"super(new GsonBuilder().create());");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"this.apiToken = apiToken;");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"this.oauthClientContext = oauthClientContext;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"@Override");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"protected void preSend(HttpUriRequest request) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"super.preSend(request);");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"request.addHeader(CR_API_TOKEN_HEADER, apiToken);");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"request.addHeader(HttpHeaders.AUTHORIZATION, \"Bearer \" + getToken());");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"private String getToken() {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"Authentication autentication = SecurityContextHolder.getContext().getAuthentication();");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"if (autentication instanceof OAuth2Authentication) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"return (String) oauthClientContext.getAccessToken().getAdditionalInformation().get(\"id_token\");");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"} else if (autentication instanceof UsernamePasswordAuthenticationToken) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"IMUserInfo userInfo =  (IMUserInfo)((UsernamePasswordAuthenticationToken)autentication).getDetails();");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"return userInfo.getAuthorizationToken().getJwt();");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"} else {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"throw new RuntimeException(\"User is not yet authenticated.\");");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        return _builder.toString();
    }
}

