/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.codegen.webui.templates.config;

import java.util.Map;
import org.eclipse.vorto.codegen.api.IFileTemplate;
import org.eclipse.vorto.codegen.api.InvocationContext;
import org.eclipse.vorto.codegen.webui.templates.TemplateUtils;
import org.eclipse.vorto.core.api.model.informationmodel.InformationModel;
import org.eclipse.xtend2.lib.StringConcatenation;

public class LocalConfigurationTemplate
implements IFileTemplate<InformationModel> {
    public String getFileName(InformationModel context) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"LocalConfiguration.java");
        return _builder.toString();
    }

    public String getPath(InformationModel context) {
        StringConcatenation _builder = new StringConcatenation();
        String _baseApplicationPath = TemplateUtils.getBaseApplicationPath(context);
        _builder.append((Object)_baseApplicationPath, "");
        _builder.append((Object)"/config");
        return _builder.toString();
    }

    public String getContent(InformationModel element, InvocationContext context) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"package com.example.iot.");
        String _name = element.getName();
        String _lowerCase = _name.toLowerCase();
        _builder.append((Object)_lowerCase, "");
        _builder.append((Object)".config;");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"import java.util.concurrent.TimeUnit;");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"import org.springframework.beans.factory.annotation.Autowired;");
        _builder.newLine();
        _builder.append((Object)"import org.springframework.beans.factory.annotation.Value;");
        _builder.newLine();
        _builder.append((Object)"import org.springframework.context.annotation.Bean;");
        _builder.newLine();
        _builder.append((Object)"import org.springframework.context.annotation.Configuration;");
        _builder.newLine();
        _builder.append((Object)"import org.springframework.context.annotation.Profile;");
        _builder.newLine();
        _builder.append((Object)"import org.springframework.security.oauth2.client.OAuth2ClientContext;");
        _builder.newLine();
        _builder.append((Object)"import com.example.iot.");
        String _name_1 = element.getName();
        String _lowerCase_1 = _name_1.toLowerCase();
        _builder.append((Object)_lowerCase_1, "");
        _builder.append((Object)".service.DataService;");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        Map _configurationProperties = context.getConfigurationProperties();
        String _orDefault = _configurationProperties.getOrDefault("boschcloud", "false");
        boolean _equalsIgnoreCase = _orDefault.equalsIgnoreCase("true");
        if (_equalsIgnoreCase) {
            _builder.append((Object)"import com.bosch.cr.integration.IntegrationClient;");
            _builder.newLine();
            _builder.append((Object)"import com.bosch.cr.integration.client.IntegrationClientImpl;");
            _builder.newLine();
            _builder.append((Object)"import com.bosch.cr.integration.client.configuration.AuthenticationConfiguration;");
            _builder.newLine();
            _builder.append((Object)"import com.bosch.cr.integration.client.configuration.IntegrationClientConfiguration;");
            _builder.newLine();
            _builder.append((Object)"import com.bosch.cr.integration.client.configuration.ProxyConfiguration;");
            _builder.newLine();
            _builder.append((Object)"import com.bosch.cr.integration.client.configuration.ProxyConfiguration.ProxyOptionalSettable;");
            _builder.newLine();
            _builder.append((Object)"import com.bosch.cr.integration.client.configuration.PublicKeyAuthenticationConfiguration;");
            _builder.newLine();
            _builder.append((Object)"import com.bosch.cr.integration.client.configuration.TrustStoreConfiguration;");
            _builder.newLine();
            _builder.append((Object)"import com.bosch.cr.integration.things.ThingIntegration;");
            _builder.newLine();
            _builder.append((Object)"import com.example.iot.");
            String _name_2 = element.getName();
            String _lowerCase_2 = _name_2.toLowerCase();
            _builder.append((Object)_lowerCase_2, "");
            _builder.append((Object)".service.bosch.BoschThingsDataService;");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"import com.example.iot.");
            String _name_3 = element.getName();
            String _lowerCase_3 = _name_3.toLowerCase();
            _builder.append((Object)_lowerCase_3, "");
            _builder.append((Object)".service.bosch.ThingClient;");
            _builder.newLineIfNotEmpty();
        } else {
            _builder.append((Object)"import com.example.iot.");
            String _name_4 = element.getName();
            String _lowerCase_4 = _name_4.toLowerCase();
            _builder.append((Object)_lowerCase_4, "");
            _builder.append((Object)".service.sample.SampleDataService;");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t\t");
        _builder.newLine();
        _builder.append((Object)"@Configuration");
        _builder.newLine();
        _builder.append((Object)"public class LocalConfiguration {");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        Map _configurationProperties_1 = context.getConfigurationProperties();
        String _orDefault_1 = _configurationProperties_1.getOrDefault("boschcloud", "false");
        boolean _equalsIgnoreCase_1 = _orDefault_1.equalsIgnoreCase("true");
        if (_equalsIgnoreCase_1) {
            _builder.append((Object)"\t");
            _builder.append((Object)"@Value(\"${bosch.things.endpointUrl}\")");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"private String thingEndpointUrl;");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"@Value(\"${bosch.things.apiToken}\")");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"private String thingApiToken;");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"@Value(\"${http.proxyHost}\")");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"private String proxyHost;");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"@Value(\"${http.proxyPort}\")");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"private int proxyPort;");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"@Value(\"${bosch.things.solutionid}\")");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"private String thingsSolutionId;");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"@Value(\"${bosch.things.keystore.password}\")");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"private String keystorePassword;");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"@Value(\"${bosch.things.alias}\")");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"private String alias;");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"@Value(\"${bosch.things.alias.password}\")");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"private String aliasPassword;");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"@Value(\"${bosch.things.keystoreLocation}\")");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"private String keystoreLocation;");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"@Value(\"${bosch.things.trustStoreLocation}\")");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"private String trustStoreLocation;");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"@Value(\"${bosch.things.trustStorePassword}\")");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"private String trustStorePassword;");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"@Value(\"${bosch.things.wsEndpointUrl}\")");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"private String wsEndpointUrl;");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"@Autowired");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"private OAuth2ClientContext oauth2context;");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"@Bean");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"public DataService dataService() {");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"return new BoschThingsDataService(thingClient(),getThingIntegration());");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"}");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"@Bean");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"public ThingClient thingClient() {");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"return ThingClient.newBuilder()");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t\t");
            _builder.append((Object)"//.withProxy(proxyHost, proxyPort)");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t\t");
            _builder.append((Object)".withEndpointUrl(thingEndpointUrl)");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t\t");
            _builder.append((Object)".withApiToken(thingApiToken)");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t\t");
            _builder.append((Object)".withOAuth2ClientContext(oauth2context)");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t\t");
            _builder.append((Object)".build();");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"}");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"@Bean");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"public ThingIntegration getThingIntegration() {");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"/* build an authentication configuration */");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"AuthenticationConfiguration authenticationConfiguration =");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t   ");
            _builder.append((Object)"PublicKeyAuthenticationConfiguration.newBuilder()");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t      ");
            _builder.append((Object)".clientId(thingsSolutionId+\":\"+\"iotconsole_local\")");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t      ");
            _builder.append((Object)".keyStoreLocation(LocalConfiguration.class.getResource(keystoreLocation))");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t      ");
            _builder.append((Object)".keyStorePassword(keystorePassword)");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t      ");
            _builder.append((Object)".alias(alias)");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t      ");
            _builder.append((Object)".aliasPassword(aliasPassword)");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t      ");
            _builder.append((Object)".build();");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t ");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"/* configure a truststore that contains trusted certificates */");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"TrustStoreConfiguration trustStore =");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t   ");
            _builder.append((Object)"TrustStoreConfiguration.newBuilder().location(LocalConfiguration.class.getResource(trustStoreLocation)).password(trustStorePassword).build();");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t ");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"ProxyOptionalSettable proxyConfig = ProxyConfiguration.newBuilder().proxyHost(proxyHost).proxyPort(proxyPort);");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"final IntegrationClientConfiguration integrationClientConfiguration =");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t   ");
            _builder.append((Object)"IntegrationClientConfiguration.newBuilder()");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t      ");
            _builder.append((Object)".authenticationConfiguration(authenticationConfiguration)");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t      ");
            _builder.append((Object)".centralRegistryEndpointUrl(wsEndpointUrl)");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t      ");
            _builder.append((Object)".trustStoreConfiguration(trustStore)");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t      ");
            _builder.append((Object)"//.proxyConfiguration(proxyConfig.build())");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t      ");
            _builder.append((Object)".build();");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t\t\t");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"final IntegrationClient integrationClient = IntegrationClientImpl.newInstance(integrationClientConfiguration);");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t ");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"try {");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t\t");
            _builder.append((Object)"/* create a subscription for this client */");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t\t");
            _builder.append((Object)"integrationClient.subscriptions().create().get(30, TimeUnit.SECONDS);");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t\t");
            _builder.append((Object)"/*");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t\t ");
            _builder.append((Object)"* start consuming events that were triggered by the subscription,");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t\t ");
            _builder.append((Object)"* usually this method is called after all handlers are registered.");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t\t ");
            _builder.append((Object)"*/");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t\t");
            _builder.append((Object)"integrationClient.subscriptions().consume().get(30, TimeUnit.SECONDS);");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"} catch (Exception e) {");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t\t");
            _builder.append((Object)"throw new RuntimeException(e);");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"}");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"return integrationClient.things();");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"}");
            _builder.newLine();
        } else {
            _builder.append((Object)"\t");
            _builder.append((Object)"@Bean");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"public DataService dataService() {");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"return new SampleDataService();");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"}");
            _builder.newLine();
        }
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder.toString();
    }
}

