/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.nano.config.internal;

import java.io.Closeable;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Dictionary;
import java.util.Enumeration;
import org.eclipse.virgo.medic.dump.Dump;
import org.eclipse.virgo.medic.dump.DumpContributionFailedException;
import org.eclipse.virgo.medic.dump.DumpContributor;
import org.eclipse.virgo.nano.serviceability.dump.DumpCoordinator;
import org.eclipse.virgo.util.io.IOUtils;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationAdminDumpContributor
implements DumpContributor {
    private static final String PROPERTY_PATTERN = "%s:\t%s\n";
    private final Logger logger;
    private final ConfigurationAdmin configurationAdmin;

    public ConfigurationAdminDumpContributor(ConfigurationAdmin configurationAdmin) {
        try {
            try {
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            this.logger = LoggerFactory.getLogger(this.getClass());
            this.configurationAdmin = configurationAdmin;
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    public void contribute(Dump dump) throws DumpContributionFailedException {
        try {
            block10: {
                StringBuilder sb = new StringBuilder();
                try {
                    Configuration[] configurationArray = this.configurationAdmin.listConfigurations(null);
                    int n = configurationArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Configuration configuration = configurationArray[n2];
                        this.appendHeader(sb, configuration.getPid());
                        this.appendProperties(sb, configuration.getProperties());
                        this.appendFooter(sb);
                        ++n2;
                    }
                }
                catch (Exception exception) {
                    this.logger.warn("Could not enumerate existing configurations");
                }
                FileWriter out = null;
                try {
                    try {
                        out = dump.createFileWriter("configurationAdmin.properties");
                        out.write(sb.toString());
                    }
                    catch (IOException iOException) {
                        this.logger.warn("Could not write configurationAdmin dump");
                        IOUtils.closeQuietly((Closeable)out);
                        break block10;
                    }
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(out);
                    throw throwable;
                }
                IOUtils.closeQuietly((Closeable)out);
            }
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    public String getName() {
        try {
            return "configurationAdmin";
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private void appendHeader(StringBuilder sb, String pid) {
        try {
            int i = 0;
            while (i < pid.length() + 4) {
                sb.append("#");
                ++i;
            }
            sb.append("\n# ").append(pid).append(" #\n");
            i = 0;
            while (i < pid.length() + 4) {
                sb.append("#");
                ++i;
            }
            sb.append("\n\n");
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private void appendProperties(StringBuilder sb, Dictionary<String, Object> properties) {
        try {
            Enumeration<String> keys = properties.keys();
            while (keys.hasMoreElements()) {
                String key = keys.nextElement();
                this.appendProperty(sb, key, properties.get(key));
            }
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private void appendProperty(StringBuilder sb, Object key, Object value) {
        try {
            sb.append(String.format(PROPERTY_PATTERN, key, value));
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private void appendFooter(StringBuilder sb) {
        try {
            sb.append("\n\n");
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }
}

