/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xbean.finder.archive;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.Iterator;
import java.util.zip.ZipEntry;
import org.apache.xbean.finder.archive.Archive;
import org.apache.xbean.osgi.bundle.util.BundleResourceFinder;
import org.apache.xbean.osgi.bundle.util.ResourceDiscoveryFilter;
import org.osgi.framework.Bundle;
import org.osgi.service.packageadmin.PackageAdmin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BundleArchive
implements Archive {
    private final Bundle bundle;

    public BundleArchive(PackageAdmin packageAdmin, Bundle bundle) throws Exception {
        this(packageAdmin, bundle, BundleResourceFinder.FULL_DISCOVERY_FILTER);
    }

    public BundleArchive(PackageAdmin packageAdmin, Bundle bundle, ResourceDiscoveryFilter discoveryFilter) throws Exception {
        this.bundle = bundle;
        BundleResourceFinder bundleResourceFinder = new BundleResourceFinder(packageAdmin, bundle, "", ".class", discoveryFilter);
        bundleResourceFinder.find((BundleResourceFinder.ResourceFinderCallback)new AnnotationFindingCallback());
    }

    @Override
    public Iterator<Archive.Entry> iterator() {
        return Collections.EMPTY_LIST.iterator();
    }

    @Override
    public InputStream getBytecode(String className) throws IOException, ClassNotFoundException {
        URL resource;
        int pos = className.indexOf("<");
        if (pos > -1) {
            className = className.substring(0, pos);
        }
        if ((pos = className.indexOf(">")) > -1) {
            className = className.substring(0, pos);
        }
        if (!className.endsWith(".class")) {
            className = className.replace('.', '/') + ".class";
        }
        if ((resource = this.bundle.getResource(className)) != null) {
            return resource.openStream();
        }
        throw new ClassNotFoundException(className);
    }

    @Override
    public Class<?> loadClass(String s) throws ClassNotFoundException {
        return this.bundle.loadClass(s);
    }

    private class AnnotationFindingCallback
    implements BundleResourceFinder.ResourceFinderCallback {
        private AnnotationFindingCallback() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean foundInDirectory(Bundle bundle, String baseDir, URL url) throws Exception {
            InputStream in = url.openStream();
            in.close();
            return true;
        }

        public boolean foundInJar(Bundle bundle, String jarName, ZipEntry entry, InputStream in) throws Exception {
            return true;
        }
    }
}

