/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.util;

import java.util.Map;
import java.util.Properties;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.util.SuperProperties;

public final class PropertyPlaceHolderHelper {
    private static final String PREFIX = "${";
    private static final String SUFFIX = "}";
    private static final Properties CACHE = new Properties();

    private PropertyPlaceHolderHelper() {
    }

    public static String simpleValue(String key) {
        if (key == null || !key.startsWith(PREFIX) || !key.endsWith(SUFFIX)) {
            return key;
        }
        String value = SystemInstance.get().getOptions().get(key.substring(2, key.length() - 1), key);
        if (!value.equals(key) && value.startsWith("java:")) {
            value = value.substring(5);
        }
        return value;
    }

    public static String value(String key) {
        if (key == null || !key.startsWith(PREFIX) || !key.endsWith(SUFFIX)) {
            return key;
        }
        String value = CACHE.getProperty(key);
        if (value != null) {
            return value;
        }
        value = PropertyPlaceHolderHelper.simpleValue(key);
        CACHE.setProperty(key, value);
        return value;
    }

    public static Properties holds(Properties properties) {
        SuperProperties updated = new SuperProperties();
        if (properties == null) {
            return updated;
        }
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            Object rawValue = entry.getValue();
            if (rawValue instanceof String) {
                ((Properties)updated).put(entry.getKey(), PropertyPlaceHolderHelper.value((String)rawValue));
                continue;
            }
            ((Properties)updated).put(entry.getKey(), rawValue);
        }
        return updated;
    }

    public static void holdsWithUpdate(Properties props) {
        Properties toUpdate = PropertyPlaceHolderHelper.holds(props);
        props.putAll((Map<?, ?>)toUpdate);
    }
}

