/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.connector.outbound;

import javax.resource.ResourceException;
import javax.transaction.xa.XAResource;
import org.apache.geronimo.connector.outbound.ConnectionInfo;
import org.apache.geronimo.connector.outbound.ConnectionInterceptor;
import org.apache.geronimo.connector.outbound.ConnectionReturnAction;
import org.apache.geronimo.connector.outbound.ManagedConnectionInfo;
import org.apache.geronimo.transaction.manager.WrapperNamedXAResource;

public class XAResourceInsertionInterceptor
implements ConnectionInterceptor {
    private final ConnectionInterceptor next;
    private final String name;

    public XAResourceInsertionInterceptor(ConnectionInterceptor next, String name) {
        this.next = next;
        this.name = name;
    }

    public void getConnection(ConnectionInfo connectionInfo) throws ResourceException {
        this.next.getConnection(connectionInfo);
        ManagedConnectionInfo mci = connectionInfo.getManagedConnectionInfo();
        mci.setXAResource((XAResource)new WrapperNamedXAResource(mci.getManagedConnection().getXAResource(), this.name));
    }

    public void returnConnection(ConnectionInfo connectionInfo, ConnectionReturnAction connectionReturnAction) {
        this.next.returnConnection(connectionInfo, connectionReturnAction);
    }

    public void destroy() {
        this.next.destroy();
    }

    public void info(StringBuilder s) {
        s.append(this.getClass().getName()).append("[name=").append(this.name).append("]\n");
        this.next.info(s);
    }
}

