/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.jsr303.xml;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.URL;
import java.util.Enumeration;
import javax.validation.ConstraintValidatorFactory;
import javax.validation.MessageInterpolator;
import javax.validation.TraversableResolver;
import javax.validation.ValidationException;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.bval.jsr303.ConfigurationImpl;
import org.apache.bval.jsr303.util.IOUtils;
import org.apache.bval.jsr303.util.SecureActions;
import org.apache.bval.jsr303.xml.PropertyType;
import org.apache.bval.jsr303.xml.ValidationConfigType;
import org.apache.bval.util.PrivilegedActions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class ValidationParser {
    private static final String DEFAULT_VALIDATION_XML_FILE = "META-INF/validation.xml";
    private static final String VALIDATION_CONFIGURATION_XSD = "META-INF/validation-configuration-1.0.xsd";
    private static final String VALIDATION_MAPPING_XSD = "META-INF/validation-mapping-1.0.xsd";
    private static final Logger log = LoggerFactory.getLogger(ValidationParser.class);
    private final String validationXmlFile;

    public ValidationParser(String file) {
        this.validationXmlFile = file == null ? DEFAULT_VALIDATION_XML_FILE : file;
    }

    public void processValidationConfig(ConfigurationImpl targetConfig) {
        ValidationConfigType xmlConfig = this.parseXmlConfig();
        if (xmlConfig != null) {
            this.applyConfig(xmlConfig, targetConfig);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ValidationConfigType parseXmlConfig() {
        ValidationConfigType validationConfigType;
        InputStream inputStream;
        block6: {
            inputStream = null;
            inputStream = this.getInputStream(this.validationXmlFile);
            if (inputStream != null) break block6;
            log.debug("No {} found. Using annotation based configuration only.", (Object)this.validationXmlFile);
            ValidationConfigType validationConfigType2 = null;
            IOUtils.closeQuietly(inputStream);
            return validationConfigType2;
        }
        try {
            log.debug("{} found.", (Object)this.validationXmlFile);
            Schema schema = ValidationParser.getSchema(new ValidationConfigurationSchemaSource());
            JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{ValidationConfigType.class});
            Unmarshaller unmarshaller = jc.createUnmarshaller();
            unmarshaller.setSchema(schema);
            StreamSource stream = new StreamSource(inputStream);
            JAXBElement root = unmarshaller.unmarshal((Source)stream, ValidationConfigType.class);
            validationConfigType = (ValidationConfigType)root.getValue();
        }
        catch (JAXBException e) {
            try {
                throw new ValidationException("Unable to parse " + this.validationXmlFile, (Throwable)e);
                catch (IOException e2) {
                    throw new ValidationException("Unable to parse " + this.validationXmlFile, (Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(inputStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(inputStream);
        return validationConfigType;
    }

    private InputStream getInputStream(String path) throws IOException {
        Enumeration<URL> urls;
        ClassLoader loader = PrivilegedActions.getClassLoader(this.getClass());
        InputStream inputStream = loader.getResourceAsStream(path);
        if (inputStream != null && path.equals(DEFAULT_VALIDATION_XML_FILE) && (urls = loader.getResources(path)).hasMoreElements() && urls.nextElement() != null && urls.hasMoreElements()) {
            throw new ValidationException("More than one " + path + " is found in the classpath");
        }
        return inputStream;
    }

    private static Schema getSchema(Source schemaSource) {
        SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        try {
            return sf.newSchema(schemaSource);
        }
        catch (SAXException e) {
            e.printStackTrace();
            return null;
        }
    }

    static Schema getSchema(String xsd) {
        if (VALIDATION_CONFIGURATION_XSD.equals(xsd)) {
            return ValidationParser.getSchema(new ValidationConfigurationSchemaSource());
        }
        if (VALIDATION_MAPPING_XSD.equals(xsd)) {
            return ValidationParser.getSchema(new ValidationMappingSchemaSource());
        }
        return ValidationParser.getSchemaFromClasspath(xsd);
    }

    private static Schema getSchemaFromClasspath(String xsd) {
        ClassLoader loader = PrivilegedActions.getClassLoader(ValidationParser.class);
        SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        URL schemaUrl = loader.getResource(xsd);
        try {
            return sf.newSchema(schemaUrl);
        }
        catch (SAXException e) {
            log.warn("Unable to parse schema: " + xsd, (Throwable)e);
            return null;
        }
    }

    private void applyConfig(ValidationConfigType xmlConfig, ConfigurationImpl targetConfig) {
        this.applyProviderClass(xmlConfig, targetConfig);
        this.applyMessageInterpolator(xmlConfig, targetConfig);
        this.applyTraversableResolver(xmlConfig, targetConfig);
        this.applyConstraintFactory(xmlConfig, targetConfig);
        this.applyMappingStreams(xmlConfig, targetConfig);
        this.applyProperties(xmlConfig, targetConfig);
    }

    private void applyProperties(ValidationConfigType xmlConfig, ConfigurationImpl target) {
        for (PropertyType property : xmlConfig.getProperty()) {
            if (log.isDebugEnabled()) {
                log.debug("Found property '" + property.getName() + "' with value '" + property.getValue() + "' in " + this.validationXmlFile);
            }
            target.addProperty(property.getName(), property.getValue());
        }
    }

    private void applyProviderClass(ValidationConfigType xmlConfig, ConfigurationImpl target) {
        String providerClassName = xmlConfig.getDefaultProvider();
        if (providerClassName != null) {
            Class<?> clazz = SecureActions.loadClass(providerClassName, this.getClass());
            target.setProviderClass(clazz);
            log.info("Using {} as validation provider.", (Object)providerClassName);
        }
    }

    private void applyMessageInterpolator(ValidationConfigType xmlConfig, ConfigurationImpl target) {
        String messageInterpolatorClass = xmlConfig.getMessageInterpolator();
        if (target.getMessageInterpolator() == null && messageInterpolatorClass != null) {
            Class<?> clazz = SecureActions.loadClass(messageInterpolatorClass, this.getClass());
            target.messageInterpolator((MessageInterpolator)SecureActions.newInstance(clazz));
            log.info("Using {} as message interpolator.", (Object)messageInterpolatorClass);
        }
    }

    private void applyTraversableResolver(ValidationConfigType xmlConfig, ConfigurationImpl target) {
        String traversableResolverClass = xmlConfig.getTraversableResolver();
        if (target.getTraversableResolver() == null && traversableResolverClass != null) {
            Class<?> clazz = SecureActions.loadClass(traversableResolverClass, this.getClass());
            target.traversableResolver((TraversableResolver)SecureActions.newInstance(clazz));
            log.info("Using {} as traversable resolver.", (Object)traversableResolverClass);
        }
    }

    private void applyConstraintFactory(ValidationConfigType xmlConfig, ConfigurationImpl target) {
        String constraintFactoryClass = xmlConfig.getConstraintValidatorFactory();
        if (target.getConstraintValidatorFactory() == null && constraintFactoryClass != null) {
            Class<?> clazz = SecureActions.loadClass(constraintFactoryClass, this.getClass());
            target.constraintValidatorFactory((ConstraintValidatorFactory)SecureActions.newInstance(clazz));
            log.info("Using {} as constraint factory.", (Object)constraintFactoryClass);
        }
    }

    private void applyMappingStreams(ValidationConfigType xmlConfig, ConfigurationImpl target) {
        for (JAXBElement<String> mappingFileNameElement : xmlConfig.getConstraintMapping()) {
            String mappingFileName = (String)mappingFileNameElement.getValue();
            if (mappingFileName.startsWith("/")) {
                mappingFileName = mappingFileName.substring(1);
            }
            log.debug("Trying to open input stream for {}", (Object)mappingFileName);
            InputStream in = null;
            try {
                in = this.getInputStream(mappingFileName);
                if (in == null) {
                    throw new ValidationException("Unable to open input stream for mapping file " + mappingFileName);
                }
            }
            catch (IOException e) {
                throw new ValidationException("Unable to open input stream for mapping file " + mappingFileName, (Throwable)e);
            }
            target.addMapping(in);
        }
    }

    private static final class ValidationConfigurationSchemaSource
    extends StreamSource {
        private ValidationConfigurationSchemaSource() {
            super(new StringReader(ValidationConfigurationSchemaSource.xsd()));
        }

        private static String xsd() {
            return "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<xs:schema attributeFormDefault=\"unqualified\"\n           elementFormDefault=\"qualified\"\n           targetNamespace=\"http://jboss.org/xml/ns/javax/validation/configuration\"\n           xmlns:xs=\"http://www.w3.org/2001/XMLSchema\"\n           version=\"1.0\">\n    <xs:element name=\"validation-config\" type=\"config:validation-configType\"\n                xmlns:config=\"http://jboss.org/xml/ns/javax/validation/configuration\"/>\n    <xs:complexType name=\"validation-configType\">\n        <xs:sequence>\n            <xs:element type=\"xs:string\" name=\"default-provider\" minOccurs=\"0\"/>\n            <xs:element type=\"xs:string\" name=\"message-interpolator\" minOccurs=\"0\"/>\n            <xs:element type=\"xs:string\" name=\"traversable-resolver\" minOccurs=\"0\"/>\n            <xs:element type=\"xs:string\" name=\"constraint-validator-factory\" minOccurs=\"0\"/>\n            <xs:element type=\"xs:string\" name=\"constraint-mapping\" maxOccurs=\"unbounded\" minOccurs=\"0\"/>\n            <xs:element type=\"config:propertyType\" name=\"property\" maxOccurs=\"unbounded\" minOccurs=\"0\"\n                        xmlns:config=\"http://jboss.org/xml/ns/javax/validation/configuration\"/>\n        </xs:sequence>\n    </xs:complexType>\n    <xs:complexType name=\"propertyType\">\n        <xs:simpleContent>\n            <xs:extension base=\"xs:string\">\n                <xs:attribute name=\"name\" use=\"required\" type=\"xs:string\"/>\n            </xs:extension>\n        </xs:simpleContent>\n    </xs:complexType>\n</xs:schema>";
        }
    }

    private static final class ValidationMappingSchemaSource
    extends StreamSource {
        private ValidationMappingSchemaSource() {
            super(new StringReader(ValidationMappingSchemaSource.xsd()));
        }

        private static String xsd() {
            return "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<xs:schema attributeFormDefault=\"unqualified\"\n           elementFormDefault=\"qualified\"\n           targetNamespace=\"http://jboss.org/xml/ns/javax/validation/mapping\"\n           xmlns:xs=\"http://www.w3.org/2001/XMLSchema\"\n           version=\"1.0\">\n    <xs:element name=\"constraint-mappings\"\n                type=\"map:constraint-mappingsType\"\n                xmlns:map=\"http://jboss.org/xml/ns/javax/validation/mapping\"/>\n\n    <xs:complexType name=\"payloadType\">\n        <xs:sequence>\n            <xs:element type=\"xs:string\" name=\"value\" maxOccurs=\"unbounded\" minOccurs=\"0\"/>\n        </xs:sequence>\n    </xs:complexType>\n    <xs:complexType name=\"groupsType\">\n        <xs:sequence>\n            <xs:element type=\"xs:string\" name=\"value\" maxOccurs=\"unbounded\" minOccurs=\"0\"/>\n        </xs:sequence>\n    </xs:complexType>\n    <xs:complexType name=\"groupSequenceType\">\n        <xs:sequence>\n            <xs:element type=\"xs:string\" name=\"value\" maxOccurs=\"unbounded\" minOccurs=\"0\"/>\n        </xs:sequence>\n    </xs:complexType>\n    <xs:complexType name=\"constraint-mappingsType\">\n        <xs:sequence>\n            <xs:element type=\"xs:string\" name=\"default-package\" minOccurs=\"0\"/>\n            <xs:element type=\"map:beanType\"\n                        name=\"bean\"\n                        maxOccurs=\"unbounded\"\n                        minOccurs=\"0\"\n                        xmlns:map=\"http://jboss.org/xml/ns/javax/validation/mapping\"/>\n            <xs:element type=\"map:constraint-definitionType\"\n                        name=\"constraint-definition\"\n                        maxOccurs=\"unbounded\"\n                        minOccurs=\"0\"\n                        xmlns:map=\"http://jboss.org/xml/ns/javax/validation/mapping\"/>\n        </xs:sequence>\n    </xs:complexType>\n    <xs:complexType name=\"validated-byType\">\n        <xs:sequence>\n            <xs:element type=\"xs:string\" name=\"value\" maxOccurs=\"unbounded\" minOccurs=\"0\"/>\n        </xs:sequence>\n        <xs:attribute type=\"xs:boolean\" name=\"include-existing-validators\" use=\"optional\"/>\n    </xs:complexType>\n    <xs:complexType name=\"constraintType\">\n        <xs:sequence>\n            <xs:element type=\"xs:string\" name=\"message\" minOccurs=\"0\"/>\n            <xs:element type=\"map:groupsType\"\n                        name=\"groups\"\n                        minOccurs=\"0\"\n                        xmlns:map=\"http://jboss.org/xml/ns/javax/validation/mapping\"/>\n            <xs:element type=\"map:payloadType\"\n                        name=\"payload\"\n                        minOccurs=\"0\"\n                        xmlns:map=\"http://jboss.org/xml/ns/javax/validation/mapping\"/>            \n            <xs:element type=\"map:elementType\"\n                        name=\"element\"\n                        maxOccurs=\"unbounded\"\n                        minOccurs=\"0\"\n                        xmlns:map=\"http://jboss.org/xml/ns/javax/validation/mapping\"/>\n        </xs:sequence>\n        <xs:attribute type=\"xs:string\" name=\"annotation\" use=\"required\"/>\n    </xs:complexType>\n    <xs:complexType name=\"elementType\" mixed=\"true\">\n        <xs:sequence>\n            <xs:element type=\"xs:string\" name=\"value\" maxOccurs=\"unbounded\" minOccurs=\"0\"/>\n            <xs:element type=\"map:annotationType\"\n                        name=\"annotation\"\n                        maxOccurs=\"unbounded\"\n                        minOccurs=\"0\"\n                        xmlns:map=\"http://jboss.org/xml/ns/javax/validation/mapping\"/>\n        </xs:sequence>\n        <xs:attribute type=\"xs:string\" name=\"name\" use=\"required\"/>\n    </xs:complexType>\n    <xs:complexType name=\"classType\">\n        <xs:sequence>\n            <xs:element type=\"map:groupSequenceType\" \n                        name=\"group-sequence\" \n                        minOccurs=\"0\" \n                        xmlns:map=\"http://jboss.org/xml/ns/javax/validation/mapping\"/>\n            <xs:element type=\"map:constraintType\"\n                        name=\"constraint\"\n                        maxOccurs=\"unbounded\"\n                        minOccurs=\"0\"\n                        xmlns:map=\"http://jboss.org/xml/ns/javax/validation/mapping\"/>\n        </xs:sequence>\n        <xs:attribute type=\"xs:boolean\" name=\"ignore-annotations\" use=\"optional\"/>\n    </xs:complexType>\n    <xs:complexType name=\"beanType\">\n        <xs:sequence>\n            <xs:element type=\"map:classType\"\n                        name=\"class\"\n                        minOccurs=\"0\"\n                        xmlns:map=\"http://jboss.org/xml/ns/javax/validation/mapping\">\n            </xs:element>\n            <xs:element type=\"map:fieldType\"\n                        name=\"field\"\n                        minOccurs=\"0\"\n                        maxOccurs=\"unbounded\"\n                        xmlns:map=\"http://jboss.org/xml/ns/javax/validation/mapping\"/>\n            <xs:element type=\"map:getterType\"\n                        name=\"getter\"\n                        minOccurs=\"0\"\n                        maxOccurs=\"unbounded\"\n                        xmlns:map=\"http://jboss.org/xml/ns/javax/validation/mapping\"/>\n        </xs:sequence>\n        <xs:attribute type=\"xs:string\" name=\"class\" use=\"required\"/>\n        <xs:attribute type=\"xs:boolean\" name=\"ignore-annotations\" use=\"optional\"/>\n    </xs:complexType>\n    <xs:complexType name=\"annotationType\">\n        <xs:sequence>\n            <xs:element type=\"map:elementType\"\n                        name=\"element\"\n                        maxOccurs=\"unbounded\"\n                        minOccurs=\"0\"\n                        xmlns:map=\"http://jboss.org/xml/ns/javax/validation/mapping\"/>\n        </xs:sequence>\n    </xs:complexType>\n    <xs:complexType name=\"getterType\">\n        <xs:sequence>\n            <xs:element type=\"xs:string\" name=\"valid\" minOccurs=\"0\" fixed=\"\"/>\n            <xs:element type=\"map:constraintType\"\n                        name=\"constraint\"\n                        minOccurs=\"0\"\n                        maxOccurs=\"unbounded\"\n                        xmlns:map=\"http://jboss.org/xml/ns/javax/validation/mapping\"/>\n        </xs:sequence>\n        <xs:attribute type=\"xs:string\" name=\"name\" use=\"required\"/>\n        <xs:attribute type=\"xs:boolean\" name=\"ignore-annotations\" use=\"optional\"/>\n    </xs:complexType>\n    <xs:complexType name=\"constraint-definitionType\">\n        <xs:sequence>\n            <xs:element type=\"map:validated-byType\"\n                        name=\"validated-by\"\n                        xmlns:map=\"http://jboss.org/xml/ns/javax/validation/mapping\"/>\n        </xs:sequence>\n        <xs:attribute type=\"xs:string\" name=\"annotation\" use=\"required\"/>\n    </xs:complexType>\n    <xs:complexType name=\"fieldType\">\n        <xs:sequence>\n            <xs:element type=\"xs:string\" name=\"valid\" minOccurs=\"0\" fixed=\"\"/>\n            <xs:element type=\"map:constraintType\"\n                        name=\"constraint\"\n                        minOccurs=\"0\"\n                        maxOccurs=\"unbounded\"\n                        xmlns:map=\"http://jboss.org/xml/ns/javax/validation/mapping\"/>\n        </xs:sequence>\n        <xs:attribute type=\"xs:string\" name=\"name\" use=\"required\"/>\n        <xs:attribute type=\"xs:boolean\" name=\"ignore-annotations\" use=\"optional\"/>\n    </xs:complexType>\n</xs:schema>";
        }
    }
}

