/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.services.concurrent.monitor;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.virgo.kernel.services.concurrent.diagnostics.ConcurrentLogEvents;
import org.eclipse.virgo.kernel.services.concurrent.monitor.DeadlockAnalyser;
import org.eclipse.virgo.medic.dump.DumpGenerator;
import org.eclipse.virgo.medic.eventlog.EventLogger;
import org.eclipse.virgo.medic.eventlog.LogEvent;
import org.eclipse.virgo.medic.log.EntryExitTrace;
import org.eclipse.virgo.util.math.Sets;

final class DeadlockMonitor {
    private static final int PERIOD = 10;
    private static final TimeUnit UNIT;
    private final ScheduledExecutorService executorService;
    private final DumpGenerator dumpGenerator;
    private final EventLogger eventLogger;
    private volatile ScheduledFuture<?> future;
    private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    static {
        Factory factory = new Factory("DeadlockMonitor.java", Class.forName("org.eclipse.virgo.kernel.services.concurrent.monitor.DeadlockMonitor"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "start", "org.eclipse.virgo.kernel.services.concurrent.monitor.DeadlockMonitor", "", "", "", "void"), 65);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "stop", "org.eclipse.virgo.kernel.services.concurrent.monitor.DeadlockMonitor", "", "", "", "void"), 72);
        ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.kernel.services.concurrent.monitor.DeadlockMonitor");
        UNIT = TimeUnit.SECONDS;
    }

    public DeadlockMonitor(ScheduledExecutorService executorService, DumpGenerator dumpGenerator, EventLogger eventLogger) {
        this.executorService = executorService;
        this.dumpGenerator = dumpGenerator;
        this.eventLogger = eventLogger;
    }

    public void start() {
        try {
            DeadlockMonitor.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_0);
            this.future = this.executorService.scheduleAtFixedRate(new DeadlockMonitorTask(this.dumpGenerator, this.eventLogger), 10L, 10L, UNIT);
            DeadlockMonitor.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_0);
            return;
        }
        catch (Throwable throwable) {
            DeadlockMonitor.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_0);
            throw throwable;
        }
    }

    public void stop() {
        try {
            DeadlockMonitor.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_1);
            if (this.executorService != null) {
                this.executorService.shutdown();
            }
            if (this.future != null) {
                this.future.cancel(true);
            }
            DeadlockMonitor.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_1);
            return;
        }
        catch (Throwable throwable) {
            DeadlockMonitor.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_1);
            throw throwable;
        }
    }

    private static class DeadlockMonitorTask
    implements Runnable {
        private final DeadlockAnalyser analyser = new DeadlockAnalyser();
        private final EventLogger eventLogger;
        private final Set<DeadlockAnalyser.Deadlock> lastSeenDeadlocks = new HashSet<DeadlockAnalyser.Deadlock>();
        private final Object monitor = new Object();
        private final DumpGenerator dumpGenerator;
        private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

        public DeadlockMonitorTask(DumpGenerator dumpGenerator, EventLogger eventLogger) {
            this.dumpGenerator = dumpGenerator;
            this.eventLogger = eventLogger;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                DeadlockMonitorTask.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_0);
                Object object = this.monitor;
                synchronized (object) {
                    Object[] deadlocks = this.analyser.findDeadlocks();
                    if (deadlocks != null && deadlocks.length > 0) {
                        Set asSet = Sets.asSet((Object[])deadlocks);
                        if (!asSet.equals(this.lastSeenDeadlocks)) {
                            this.eventLogger.log((LogEvent)ConcurrentLogEvents.DEADLOCK_DETECTED, new Object[0]);
                            this.dumpGenerator.generateDump("deadlock", new Throwable[0]);
                            this.lastSeenDeadlocks.clear();
                            this.lastSeenDeadlocks.addAll(asSet);
                        }
                    } else {
                        this.lastSeenDeadlocks.clear();
                    }
                }
                DeadlockMonitorTask.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_0);
                return;
            }
            catch (Throwable throwable) {
                DeadlockMonitorTask.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_0);
                throw throwable;
            }
        }

        static {
            Factory factory = new Factory("DeadlockMonitor.java", Class.forName("org.eclipse.virgo.kernel.services.concurrent.monitor.DeadlockMonitor$DeadlockMonitorTask"));
            ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "run", "org.eclipse.virgo.kernel.services.concurrent.monitor.DeadlockMonitor$DeadlockMonitorTask", "", "", "", "void"), 112);
            ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.kernel.services.concurrent.monitor.DeadlockMonitor$DeadlockMonitorTask");
        }
    }
}

