/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.eventadmin.impl.dispatch;

import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.felix.eventadmin.impl.dispatch.Scheduler;

public class DelayScheduler
implements Scheduler {
    private final Timer m_timer = new Timer(true);
    private final int m_delay;

    public DelayScheduler(int delay) {
        this.m_delay = delay;
    }

    public void schedule(Runnable task) {
        this.scheduleTaskWithDelay(task, this.m_delay);
    }

    public void schedule(Runnable task, int nice) {
        this.scheduleTaskWithDelay(task, this.m_delay - nice);
    }

    private void scheduleTaskWithDelay(final Runnable task, int delay) {
        this.m_timer.schedule(new TimerTask(){

            public void run() {
                task.run();
            }
        }, new Date(System.currentTimeMillis() + (long)delay));
    }
}

