/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.osgicommand.internal.commands.classloading;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.osgi.framework.console.CommandInterpreter;
import org.eclipse.osgi.framework.console.CommandProvider;
import org.eclipse.virgo.kernel.osgicommand.helper.ClassLoadingHelper;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassLoadingCommandProvider
implements CommandProvider {
    public static final String NEW_LINE = System.getProperty("line.separator", "\n");
    private BundleContext bundleContext;

    public ClassLoadingCommandProvider(BundleContext context) {
        this.bundleContext = context;
    }

    public void _clhas(CommandInterpreter interpreter) {
        String className = interpreter.nextArgument();
        if (className == null) {
            interpreter.println((Object)"No class name specified");
            return;
        }
        HashMap<Bundle, Bundle> foundBundles = ClassLoadingHelper.getBundlesLoadingClass(this.bundleContext, className);
        if (foundBundles.size() == 0) {
            interpreter.println((Object)("No bundle contains class [" + className + "]"));
            return;
        }
        HashSet<Bundle> uniqueBundles = new HashSet<Bundle>(foundBundles.values());
        HashMap<Long, String> outputBundles = new HashMap<Long, String>();
        for (Bundle bundle : uniqueBundles) {
            outputBundles.put(bundle.getBundleId(), bundle.getSymbolicName());
        }
        this.outputFoundBundles(interpreter, "Bundles containing [" + className + "]:", outputBundles);
    }

    public void _clload(CommandInterpreter interpreter) {
        String className = interpreter.nextArgument();
        if (className == null) {
            interpreter.println((Object)"No class name specified");
            return;
        }
        String bundle = interpreter.nextArgument();
        HashMap<Bundle, Bundle> foundBundles = bundle == null ? ClassLoadingHelper.getBundlesLoadingClass(this.bundleContext, className) : ClassLoadingHelper.getBundlesLoadingClass(this.bundleContext, className, bundle);
        if (foundBundles.size() == 0) {
            if (bundle == null) {
                interpreter.println((Object)("No bundle can load class [" + className + "]"));
            } else {
                interpreter.println((Object)("Bundle [" + bundle + "] cannot load class [" + className + "]"));
            }
            return;
        }
        this.outputFoundBundlesAndRelations(interpreter, "Successfully loaded [" + className + "] " + (bundle != null ? "using class loader from:" : "from:"), foundBundles, "exported by");
    }

    public void _clexport(CommandInterpreter interpreter) {
        String className = interpreter.nextArgument();
        if (className == null) {
            interpreter.println((Object)"No class name specified");
            return;
        }
        int index = className.lastIndexOf(".");
        if (index == -1) {
            interpreter.println((Object)("The class name [" + className + "] contains no package"));
            return;
        }
        String classPackage = className.substring(0, index);
        Bundle[] bundles = this.bundleContext.getBundles();
        HashMap<Long, String> foundBundles = new HashMap<Long, String>();
        Bundle[] bundleArray = bundles;
        int n = bundles.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle bundle = bundleArray[n2];
            if (ClassLoadingHelper.isPackageExported(this.bundleContext, classPackage, bundle)) {
                if (ClassLoadingHelper.tryToLoadClass(className, bundle) != null) {
                    foundBundles.put(bundle.getBundleId(), bundle.getSymbolicName());
                } else {
                    foundBundles.put(bundle.getBundleId(), String.valueOf(bundle.getSymbolicName()) + "     [class not found, package only]");
                }
            }
            ++n2;
        }
        if (foundBundles.size() == 0) {
            interpreter.println((Object)("No bundle exports class [" + className + "]"));
            return;
        }
        this.outputFoundBundles(interpreter, "Bundles exporting [" + className + "]:", foundBundles);
    }

    private void outputFoundBundles(CommandInterpreter interpreter, String message, HashMap<Long, String> foundBundles) {
        interpreter.println();
        interpreter.println((Object)message);
        for (Map.Entry<Long, String> entry : foundBundles.entrySet()) {
            interpreter.println((Object)("  " + entry.getKey() + "\t" + entry.getValue()));
        }
    }

    private void outputFoundBundlesAndRelations(CommandInterpreter interpreter, String message, HashMap<Bundle, Bundle> foundBundles, String relation) {
        interpreter.println();
        interpreter.println((Object)message);
        for (Map.Entry<Bundle, Bundle> entry : foundBundles.entrySet()) {
            Bundle originalBundle;
            Bundle testBundle = entry.getKey();
            if (testBundle.equals(originalBundle = entry.getValue())) {
                interpreter.println((Object)("  " + testBundle.getBundleId() + "\t" + testBundle.getSymbolicName()));
                continue;
            }
            interpreter.println((Object)("  " + testBundle.getBundleId() + "\t" + testBundle.getSymbolicName()));
            if (relation == null) continue;
            interpreter.println((Object)("  \t\t[" + relation + " " + originalBundle.getBundleId() + " " + originalBundle.getSymbolicName() + "]"));
        }
    }

    public String getHelp() {
        StringBuffer help = new StringBuffer();
        help.append("---");
        help.append("Classloading Commands");
        help.append("---");
        help.append(NEW_LINE);
        help.append("\tclhas <class name> - lists all bundles that contain a class with the specified name.").append(NEW_LINE);
        help.append("\tclload <class name> [<bundle id> | <bundle name>]- lists all bundles that can load a class or tries to load the class with specified bundle.").append(NEW_LINE);
        help.append("\tclexport <class name> - lists all bundles that export a class with the specified name.").append(NEW_LINE);
        return help.toString();
    }
}

