/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.ds.model;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.equinox.internal.ds.Activator;
import org.eclipse.equinox.internal.ds.InstanceProcess;
import org.eclipse.equinox.internal.ds.Messages;
import org.eclipse.equinox.internal.ds.Reference;
import org.eclipse.equinox.internal.ds.SCRUtil;
import org.eclipse.equinox.internal.ds.impl.ComponentInstanceImpl;
import org.eclipse.equinox.internal.ds.model.ServiceComponent;
import org.eclipse.equinox.internal.util.io.Externalizable;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentInstance;

public class ComponentReference
implements Externalizable,
org.apache.felix.scr.Reference {
    public static final int CARDINALITY_0_1 = 0;
    public static final int CARDINALITY_0_N = 1;
    public static final int CARDINALITY_1_1 = 2;
    public static final int CARDINALITY_1_N = 3;
    public static final int POLICY_STATIC = 0;
    public static final int POLICY_DYNAMIC = 1;
    public static final int POLICY_OPTION_RELUCTANT = 0;
    public static final int POLICY_OPTION_GREEDY = 1;
    public String name;
    public String interfaceName;
    public int cardinality = 2;
    public int policy = 0;
    public String target;
    public String bind;
    public String unbind;
    public String updated;
    public int policy_option = 0;
    public ServiceComponent component;
    private boolean bindCached;
    private boolean unbindCached;
    private boolean updatedCached;
    Method bindMethod;
    Method unbindMethod;
    Method updatedMethod;
    public Hashtable serviceReferences = new Hashtable(3);
    private Hashtable serviceReferencesToUnbind = new Hashtable(3);
    static final Class[] SERVICE_REFERENCE;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class[] classArray = new Class[1];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.osgi.framework.ServiceReference");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        SERVICE_REFERENCE = classArray;
    }

    ComponentReference(ServiceComponent component) {
        this.component = component;
        if (this.component.references == null) {
            this.component.references = new Vector(2);
        }
        this.component.references.addElement(this);
    }

    Method getMethod(ComponentInstanceImpl componentInstance, Reference reference, String methodName, ServiceReference serviceReference) {
        Class<?> consumerClass = componentInstance.getInstance().getClass();
        Object serviceObject = null;
        Class<?> serviceObjectClass = null;
        Class<?> interfaceClass = null;
        Class[] param_interfaceClass = null;
        Method method = null;
        while (consumerClass != null) {
            try {
                method = consumerClass.getDeclaredMethod(methodName, SERVICE_REFERENCE);
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (NoClassDefFoundError err) {
                this.logWarning(NLS.bind((String)Messages.EXCEPTION_GETTING_METHOD, (Object)methodName, (Object)consumerClass.getName()), err, reference);
            }
            if (method != null && SCRUtil.checkMethodAccess(componentInstance.getInstance().getClass(), consumerClass, method, this.component.isNamespaceAtLeast11())) break;
            if (serviceObject == null) {
                serviceObject = componentInstance.bindedServices.get(serviceReference);
                if (serviceObject == null) {
                    serviceObject = InstanceProcess.staticRef.getService(reference, serviceReference);
                }
                if (serviceObject == null) {
                    this.logWarning(Messages.CANT_GET_SERVICE_OBJECT, null, reference);
                    return null;
                }
                componentInstance.bindedServices.put(serviceReference, serviceObject);
                Class<?> searchForInterfaceClass = serviceObjectClass = serviceObject.getClass();
                while (searchForInterfaceClass != null) {
                    Class<?>[] interfaceClasses = searchForInterfaceClass.getInterfaces();
                    int i = 0;
                    while (i < interfaceClasses.length) {
                        if (interfaceClasses[i].getName().equals(this.interfaceName)) {
                            interfaceClass = interfaceClasses[i];
                            break;
                        }
                        ++i;
                    }
                    if (interfaceClass != null) break;
                    if (searchForInterfaceClass.getName().equals(this.interfaceName)) {
                        interfaceClass = searchForInterfaceClass;
                        break;
                    }
                    searchForInterfaceClass = searchForInterfaceClass.getSuperclass();
                }
                param_interfaceClass = new Class[]{interfaceClass};
            }
            try {
                method = consumerClass.getDeclaredMethod(methodName, param_interfaceClass);
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (NoClassDefFoundError err) {
                this.logWarning(NLS.bind((String)Messages.EXCEPTION_GETTING_METHOD, (Object)methodName, (Object)consumerClass.getName()), err, reference);
            }
            if (method != null && SCRUtil.checkMethodAccess(componentInstance.getInstance().getClass(), consumerClass, method, this.component.isNamespaceAtLeast11())) break;
            Method[] methods = consumerClass.getDeclaredMethods();
            int i = 0;
            while (i < methods.length) {
                Class<?>[] params = methods[i].getParameterTypes();
                if (params.length == 1 && methods[i].getName().equals(methodName) && params[0].isAssignableFrom(serviceObjectClass)) {
                    method = methods[i];
                    break;
                }
                ++i;
            }
            if (method != null && SCRUtil.checkMethodAccess(componentInstance.getInstance().getClass(), consumerClass, method, this.component.isNamespaceAtLeast11())) break;
            if (this.component.isNamespaceAtLeast11()) {
                i = 0;
                while (i < methods.length) {
                    Class<?>[] params = methods[i].getParameterTypes();
                    if (params.length == 2 && methods[i].getName().equals(methodName) && params[0] == interfaceClass) {
                        Class<?> clazz = params[1];
                        Class<?> clazz2 = class$1;
                        if (clazz2 == null) {
                            try {
                                clazz2 = Class.forName("java.util.Map");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        if (clazz == clazz2) {
                            method = methods[i];
                            break;
                        }
                    }
                    ++i;
                }
                if (method != null && SCRUtil.checkMethodAccess(componentInstance.getInstance().getClass(), consumerClass, method, true)) break;
                i = 0;
                while (i < methods.length) {
                    Class<?>[] params = methods[i].getParameterTypes();
                    if (params.length == 2 && methods[i].getName().equals(methodName) && params[0].isAssignableFrom(serviceObjectClass)) {
                        Class<?> clazz = params[1];
                        Class<?> clazz3 = class$1;
                        if (clazz3 == null) {
                            try {
                                clazz3 = Class.forName("java.util.Map");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        if (clazz == clazz3) {
                            method = methods[i];
                            break;
                        }
                    }
                    ++i;
                }
            }
            if (method != null) break;
            consumerClass = consumerClass.getSuperclass();
        }
        if (method == null) {
            this.logMethodNotFoundError(componentInstance, reference, methodName);
            return null;
        }
        if (!SCRUtil.checkMethodAccess(componentInstance.getInstance().getClass(), consumerClass, method, this.component.isNamespaceAtLeast11())) {
            this.logMethodNotVisible(componentInstance, reference, methodName, method.getParameterTypes());
            return null;
        }
        int modifier = method.getModifiers();
        if (!Modifier.isPublic(modifier)) {
            SCRUtil.setAccessible(method);
        }
        return method;
    }

    private void logMethodNotVisible(ComponentInstanceImpl componentInstance, Reference reference, String methodName, Class[] param_interfaceClasses) {
        StringBuffer buffer = this.createBuffer();
        buffer.append("[SCR] Method ");
        buffer.append(methodName);
        buffer.append('(');
        int i = 0;
        while (i < param_interfaceClasses.length) {
            buffer.append(param_interfaceClasses[i].getName());
            if (i < param_interfaceClasses.length - 1) {
                buffer.append(',');
            }
            ++i;
        }
        buffer.append(')');
        buffer.append(" is not accessible!");
        this.component.componentIssues.add("Method [" + methodName + "]  is not accessible in " + componentInstance.getInstance().getClass());
        this.appendDetails(buffer, reference);
        String message = buffer.toString();
        Activator.log(reference.reference.component.bc, 1, message, null);
    }

    private void logMethodNotFoundError(ComponentInstanceImpl componentInstance, Reference reference, String methodName) {
        StringBuffer buffer = this.createBuffer();
        buffer.append("[SCR] Method was not found: ");
        buffer.append(methodName);
        buffer.append('(');
        buffer.append("...");
        buffer.append(')');
        this.component.componentIssues.add("Method [" + methodName + "] was not found in " + componentInstance.getInstance().getClass());
        this.appendDetails(buffer, reference);
        String message = buffer.toString();
        Activator.log(reference.reference.component.bc, 1, message, null);
    }

    private void appendDetails(StringBuffer buffer, Reference reference) {
        try {
            String indent = "\n\t";
            buffer.append(indent);
            buffer.append("Details:");
            buffer.append(indent);
            buffer.append("Problematic reference = " + reference.reference);
            buffer.append(indent);
            buffer.append("of service component = ");
            buffer.append(reference.reference.component.name);
            buffer.append(indent);
            buffer.append("component implementation class = ");
            buffer.append(reference.reference.component.implementation);
            buffer.append(indent);
            buffer.append("located in bundle with symbolic name = ");
            buffer.append(this.component.bc.getBundle().getSymbolicName());
            buffer.append(indent);
            buffer.append("bundle location = ");
            buffer.append(this.component.bc.getBundle().getLocation());
        }
        catch (Throwable throwable) {}
    }

    private void logWarning(String message, Throwable t, Reference reference) {
        StringBuffer buffer = this.createBuffer();
        buffer.append(message);
        this.appendDetails(buffer, reference);
        Activator.log(reference.reference.component.bc, 2, buffer.toString(), t);
    }

    private void logError(String message, Throwable t, Reference reference) {
        StringBuffer buffer = this.createBuffer();
        buffer.append(message);
        String cause = t.toString();
        if (t instanceof InvocationTargetException) {
            cause = "The called method throws: " + t.getCause().toString();
        }
        this.component.componentIssues.add(String.valueOf(message) + " Root Cause [" + cause + "]");
        this.appendDetails(buffer, reference);
        Activator.log(reference.reference.component.bc, 1, buffer.toString(), t);
    }

    private StringBuffer createBuffer() {
        return new StringBuffer(400);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    final boolean bind(Reference reference, ComponentInstance instance, ServiceReference serviceReference) throws Exception {
        block25: {
            block28: {
                block27: {
                    if (this.bind == null) break block25;
                    bound = false;
                    var5_5 = this.serviceReferences;
                    synchronized (var5_5) {
                        block23: {
                            block26: {
                                instances = (Vector<ComponentInstance>)this.serviceReferences.get(serviceReference);
                                if (instances != null) break block26;
                                instances = new Vector<ComponentInstance>(1);
                                instances.addElement(instance);
                                this.serviceReferences.put(serviceReference, instances);
                                break block27;
                            }
                            if (!instances.contains(instance)) break block23;
                            if (reference.isUnary()) {
                                this.logWarning(NLS.bind((String)Messages.SERVICE_REFERENCE_ALREADY_BOUND, (Object)serviceReference, (Object)instance), null, reference);
                            }
                            return false;
                        }
                        instances.addElement(instance);
                    }
                }
                if (!this.bindCached) {
                    this.bindMethod = this.getMethod((ComponentInstanceImpl)instance, reference, this.bind, serviceReference);
                    if (this.bindMethod != null) {
                        this.bindCached = true;
                    }
                }
                if (this.bindMethod == null) break block28;
                methodParam /* !! */  = null;
                paramTypes = this.bindMethod.getParameterTypes();
                if (paramTypes.length != 1) ** GOTO lbl-1000
                v1 = paramTypes[0];
                v2 = ComponentReference.class$0;
                if (v2 == null) {
                    try {
                        v2 = ComponentReference.class$0 = Class.forName("org.osgi.framework.ServiceReference");
                    }
                    catch (ClassNotFoundException v3) {
                        throw new NoClassDefFoundError(v3.getMessage());
                    }
                }
                if (v1.equals(v2)) {
                    methodParam /* !! */  = serviceReference;
                } else lbl-1000:
                // 2 sources

                {
                    if ((methodParam /* !! */  = (ServiceReference)((ComponentInstanceImpl)instance).bindedServices.get(serviceReference)) == null && (methodParam /* !! */  = InstanceProcess.staticRef.getService(reference, serviceReference)) != null) {
                        ((ComponentInstanceImpl)instance).bindedServices.put(serviceReference, methodParam /* !! */ );
                    }
                    if (methodParam /* !! */  == null) {
                        this.removeServiceReference(serviceReference, instance);
                        return false;
                    }
                }
                params = null;
                if (paramTypes.length == 1) {
                    params = SCRUtil.getObjectArray();
                    params[0] = methodParam /* !! */ ;
                } else {
                    map = new HashMap<String, Object>();
                    keys = serviceReference.getPropertyKeys();
                    i = 0;
                    while (i < keys.length) {
                        map.put(keys[i], serviceReference.getProperty(keys[i]));
                        ++i;
                    }
                    params = new Object[]{methodParam /* !! */ , map};
                }
                try {
                    try {
                        this.bindMethod.invoke(instance.getInstance(), params);
                        bound = true;
                    }
                    catch (Throwable t) {
                        this.logError(NLS.bind((String)Messages.ERROR_BINDING_REFERENCE, (Object)this), t, reference);
                        this.removeServiceReference(serviceReference, instance);
                        if (params.length != 1) ** GOTO lbl84
                        SCRUtil.release(params);
                    }
                }
                finally {
                    if (params.length == 1) {
                        SCRUtil.release(params);
                    }
                }
            }
            this.removeServiceReference(serviceReference, instance);
            this.logWarning(NLS.bind((String)Messages.BIND_METHOD_NOT_FOUND_OR_NOT_ACCESSIBLE, (Object)this.bind), null, reference);
lbl84:
            // 4 sources

            return bound;
        }
        return false;
    }

    private void removeServiceReference(ServiceReference serviceReference, ComponentInstance instance) {
        Vector instances = (Vector)this.serviceReferences.get(serviceReference);
        instances.removeElement(instance);
        if (instances.isEmpty()) {
            this.serviceReferences.remove(serviceReference);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void unbind(Reference reference, ComponentInstance instance, ServiceReference serviceReference) {
        block46: {
            Class<?>[] paramTypes;
            Object methodParam;
            block48: {
                boolean referenceExists = true;
                Hashtable hashtable = this.serviceReferences;
                synchronized (hashtable) {
                    Vector instances = (Vector)this.serviceReferences.get(serviceReference);
                    if (instances == null) {
                        referenceExists = false;
                    } else if (!instances.contains(instance)) {
                        this.logWarning(NLS.bind((String)Messages.INSTANCE_NOT_BOUND, (Object)instance), null, reference);
                        return;
                    }
                    if (referenceExists) {
                        Vector<ComponentInstance> instancesToUnbind = (Vector<ComponentInstance>)this.serviceReferencesToUnbind.get(serviceReference);
                        if (instancesToUnbind != null && instancesToUnbind.contains(instance)) {
                            return;
                        }
                        if (instancesToUnbind == null) {
                            instancesToUnbind = new Vector<ComponentInstance>(1);
                            this.serviceReferencesToUnbind.put(serviceReference, instancesToUnbind);
                        }
                        instancesToUnbind.addElement(instance);
                    }
                }
                if (!referenceExists) {
                    this.logWarning(NLS.bind((String)Messages.INVALID_SERVICE_REFERENCE, (Object)serviceReference), null, reference);
                    return;
                }
                if (this.unbind == null) break block46;
                if (!this.unbindCached) {
                    this.unbindCached = true;
                    this.unbindMethod = this.getMethod((ComponentInstanceImpl)instance, reference, this.unbind, serviceReference);
                }
                if (this.unbindMethod == null) break block46;
                methodParam = null;
                paramTypes = this.unbindMethod.getParameterTypes();
                if (paramTypes.length == 1) {
                    Class<?> clazz = paramTypes[0];
                    Class<?> clazz2 = class$0;
                    if (clazz2 == null) {
                        try {
                            clazz2 = class$0 = Class.forName("org.osgi.framework.ServiceReference");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (clazz.equals(clazz2)) {
                        methodParam = serviceReference;
                        break block48;
                    }
                }
                if ((methodParam = (Object)((ComponentInstanceImpl)instance).bindedServices.get(serviceReference)) == null) {
                    methodParam = InstanceProcess.staticRef.getService(reference, serviceReference);
                }
                if (methodParam != null) break block48;
                Hashtable hashtable2 = this.serviceReferences;
                synchronized (hashtable2) {
                    Vector instances = (Vector)this.serviceReferences.get(serviceReference);
                    instances.removeElement(instance);
                    if (instances.isEmpty()) {
                        this.serviceReferences.remove(serviceReference);
                    }
                    instances = (Vector)this.serviceReferencesToUnbind.get(serviceReference);
                    instances.removeElement(instance);
                    if (instances.isEmpty()) {
                        this.serviceReferencesToUnbind.remove(serviceReference);
                    }
                }
                return;
            }
            try {
                Object[] params = null;
                if (paramTypes.length == 1) {
                    params = SCRUtil.getObjectArray();
                    params[0] = methodParam;
                } else {
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    String[] keys = serviceReference.getPropertyKeys();
                    int i = 0;
                    while (i < keys.length) {
                        map.put(keys[i], serviceReference.getProperty(keys[i]));
                        ++i;
                    }
                    params = new Object[]{methodParam, map};
                }
                try {
                    try {
                        this.unbindMethod.invoke(instance.getInstance(), params);
                    }
                    catch (Throwable t) {
                        this.logError(NLS.bind((String)Messages.EXCEPTION_UNBINDING_REFERENCE, (Object)this), t, reference);
                        if (params.length == 1) {
                            SCRUtil.release(params);
                        }
                        break block46;
                    }
                }
                catch (Throwable throwable) {
                    if (params.length == 1) {
                        SCRUtil.release(params);
                    }
                    throw throwable;
                }
                if (params.length == 1) {
                    SCRUtil.release(params);
                }
            }
            catch (Throwable throwable) {
                Hashtable hashtable = this.serviceReferences;
                synchronized (hashtable) {
                    Vector instances = (Vector)this.serviceReferences.get(serviceReference);
                    instances.removeElement(instance);
                    if (instances.isEmpty()) {
                        this.serviceReferences.remove(serviceReference);
                    }
                    instances = (Vector)this.serviceReferencesToUnbind.get(serviceReference);
                    instances.removeElement(instance);
                    if (instances.isEmpty()) {
                        this.serviceReferencesToUnbind.remove(serviceReference);
                    }
                }
                throw throwable;
            }
        }
        Hashtable hashtable = this.serviceReferences;
        synchronized (hashtable) {
            Vector instances = (Vector)this.serviceReferences.get(serviceReference);
            instances.removeElement(instance);
            if (instances.isEmpty()) {
                this.serviceReferences.remove(serviceReference);
            }
            instances = (Vector)this.serviceReferencesToUnbind.get(serviceReference);
            instances.removeElement(instance);
            if (instances.isEmpty()) {
                this.serviceReferencesToUnbind.remove(serviceReference);
            }
        }
        if (((ComponentInstanceImpl)instance).bindedServices.remove(serviceReference) != null) {
            this.component.bc.ungetService(serviceReference);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    final void updated(Reference reference, ComponentInstance instance, ServiceReference serviceReference) {
        block23: {
            block24: {
                if (this.updated == null) break block23;
                var4_4 = this.serviceReferences;
                synchronized (var4_4) {
                    instances = (Vector)this.serviceReferences.get(serviceReference);
                    if (instances == null || !instances.contains(instance)) {
                        return;
                    }
                }
                if (!this.updatedCached) {
                    this.updatedMethod = this.getMethod((ComponentInstanceImpl)instance, reference, this.updated, serviceReference);
                    if (this.updatedMethod != null) {
                        this.updatedCached = true;
                    }
                }
                if (this.updatedMethod == null) break block24;
                methodParam /* !! */  = null;
                paramTypes = this.updatedMethod.getParameterTypes();
                if (paramTypes.length != 1) ** GOTO lbl-1000
                v1 = paramTypes[0];
                v2 = ComponentReference.class$0;
                if (v2 == null) {
                    try {
                        v2 = ComponentReference.class$0 = Class.forName("org.osgi.framework.ServiceReference");
                    }
                    catch (ClassNotFoundException v3) {
                        throw new NoClassDefFoundError(v3.getMessage());
                    }
                }
                if (v1.equals(v2)) {
                    methodParam /* !! */  = serviceReference;
                } else lbl-1000:
                // 2 sources

                {
                    if ((methodParam /* !! */  = (ServiceReference)((ComponentInstanceImpl)instance).bindedServices.get(serviceReference)) == null && (methodParam /* !! */  = InstanceProcess.staticRef.getService(reference, serviceReference)) != null) {
                        ((ComponentInstanceImpl)instance).bindedServices.put(serviceReference, methodParam /* !! */ );
                    }
                    if (methodParam /* !! */  == null) {
                        Activator.log(null, 2, NLS.bind((String)Messages.UPDATED_METHOD_NOT_CALLED, (Object)this.name, (Object)this.component.name), null);
                        return;
                    }
                }
                params = null;
                if (paramTypes.length == 1) {
                    params = SCRUtil.getObjectArray();
                    params[0] = methodParam /* !! */ ;
                } else {
                    map = new HashMap<String, Object>();
                    keys = serviceReference.getPropertyKeys();
                    i = 0;
                    while (i < keys.length) {
                        map.put(keys[i], serviceReference.getProperty(keys[i]));
                        ++i;
                    }
                    params = new Object[]{methodParam /* !! */ , map};
                }
                try {
                    try {
                        this.updatedMethod.invoke(instance.getInstance(), params);
                    }
                    catch (Throwable t) {
                        this.logError(NLS.bind((String)Messages.ERROR_UPDATING_REFERENCE, (Object)this, (Object)instance.getInstance()), t, reference);
                        if (params.length != 1) ** GOTO lbl67
                        SCRUtil.release(params);
                    }
                }
                finally {
                    if (params.length == 1) {
                        SCRUtil.release(params);
                    }
                }
            }
            this.logWarning(NLS.bind((String)Messages.UPDATED_METHOD_NOT_FOUND_OR_NOT_ACCESSIBLE, (Object)this.updated), null, reference);
        }
    }

    public final void dispose() {
        this.updatedCached = false;
        this.unbindCached = false;
        this.bindCached = false;
        this.updatedMethod = null;
        this.unbindMethod = null;
        this.bindMethod = null;
        this.serviceReferences = null;
    }

    public final String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Reference[");
        buffer.append("name = ").append(this.name);
        buffer.append(", interface = ").append(this.interfaceName);
        buffer.append(", policy = ");
        switch (this.policy) {
            case 1: {
                buffer.append("dynamic");
                break;
            }
            case 0: {
                buffer.append("static");
            }
        }
        if (this.component.isNamespaceAtLeast12()) {
            buffer.append(", policy-option = ");
            switch (this.policy_option) {
                case 0: {
                    buffer.append("reluctant");
                    break;
                }
                case 1: {
                    buffer.append("greedy");
                }
            }
        }
        buffer.append(", cardinality = ");
        switch (this.cardinality) {
            case 0: {
                buffer.append("0..1");
                break;
            }
            case 1: {
                buffer.append("0..n");
                break;
            }
            case 2: {
                buffer.append("1..1");
                break;
            }
            case 3: {
                buffer.append("1..n");
            }
        }
        buffer.append(", target = ").append(this.target);
        buffer.append(", bind = ").append(this.bind);
        buffer.append(", unbind = ").append(this.unbind);
        if (this.component.isNamespaceAtLeast12()) {
            buffer.append(", updated = ").append(this.updated);
        }
        buffer.append("]");
        return buffer.toString();
    }

    public synchronized void writeObject(OutputStream o) throws Exception {
        try {
            DataOutputStream out = o instanceof DataOutputStream ? (DataOutputStream)o : new DataOutputStream(o);
            out.writeUTF(this.name);
            out.writeUTF(this.interfaceName);
            out.writeInt(this.cardinality);
            out.writeInt(this.policy);
            boolean flag = this.target != null;
            out.writeBoolean(flag);
            if (flag) {
                out.writeUTF(this.target);
            }
            flag = this.bind != null;
            out.writeBoolean(flag);
            if (flag) {
                out.writeUTF(this.bind);
            }
            flag = this.unbind != null;
            out.writeBoolean(flag);
            if (flag) {
                out.writeUTF(this.unbind);
            }
            out.writeBoolean(this.component.isNamespaceAtLeast12());
            if (this.component.isNamespaceAtLeast12()) {
                flag = this.updated != null;
                out.writeBoolean(flag);
                if (flag) {
                    out.writeUTF(this.updated);
                }
                out.writeInt(this.policy_option);
            }
        }
        catch (Exception e) {
            Activator.log(null, 1, Messages.ERROR_WRITING_OBJECT, e);
            throw e;
        }
    }

    public synchronized void readObject(InputStream s) throws Exception {
        try {
            DataInputStream in = s instanceof DataInputStream ? (DataInputStream)s : new DataInputStream(s);
            this.name = in.readUTF();
            this.interfaceName = in.readUTF();
            this.cardinality = in.readInt();
            this.policy = in.readInt();
            boolean flag = in.readBoolean();
            if (flag) {
                this.target = in.readUTF();
            }
            if (flag = in.readBoolean()) {
                this.bind = in.readUTF();
            }
            if (flag = in.readBoolean()) {
                this.unbind = in.readUTF();
            }
            if (flag = in.readBoolean()) {
                flag = in.readBoolean();
                if (flag) {
                    this.updated = in.readUTF();
                }
                this.policy_option = in.readInt();
            }
        }
        catch (Exception e) {
            Activator.log(null, 1, Messages.ERROR_READING_OBJECT, e);
            throw e;
        }
    }

    public String getBindMethodName() {
        return this.bind;
    }

    public String getName() {
        return this.name;
    }

    public String getServiceName() {
        return this.interfaceName;
    }

    public ServiceReference[] getServiceReferences() {
        Vector result = null;
        if (this.bind != null && !this.serviceReferences.isEmpty()) {
            result = new Vector(2);
            Enumeration keys = this.serviceReferences.keys();
            while (keys.hasMoreElements()) {
                result.add(keys.nextElement());
            }
        }
        if (result != null && !result.isEmpty()) {
            Object[] finalResult = new ServiceReference[result.size()];
            result.copyInto(finalResult);
            return finalResult;
        }
        return null;
    }

    public String getTarget() {
        return this.target;
    }

    public String getUnbindMethodName() {
        return this.unbind;
    }

    public boolean isMultiple() {
        return this.cardinality == 1 || this.cardinality == 3;
    }

    public boolean isOptional() {
        return this.cardinality == 0 || this.cardinality == 1;
    }

    public boolean isSatisfied() {
        if (this.isOptional()) {
            return true;
        }
        try {
            ServiceReference[] _serviceReferences = this.component.bc.getServiceReferences(this.interfaceName, this.target);
            if (_serviceReferences != null) {
                return true;
            }
        }
        catch (InvalidSyntaxException invalidSyntaxException) {}
        return false;
    }

    public boolean isStatic() {
        return this.policy == 0;
    }

    public String getUpdatedMethodName() {
        if (this.component.isNamespaceAtLeast12()) {
            return this.updated;
        }
        return null;
    }
}

