/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.install.artifact.internal;

import java.io.Closeable;
import java.io.InputStream;
import java.util.Locale;
import java.util.Map;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.virgo.kernel.artifact.plan.PlanDescriptor;
import org.eclipse.virgo.kernel.artifact.plan.PlanReader;
import org.eclipse.virgo.kernel.deployer.core.DeploymentException;
import org.eclipse.virgo.kernel.install.artifact.ArtifactIdentity;
import org.eclipse.virgo.kernel.install.artifact.ArtifactIdentityDeterminer;
import org.eclipse.virgo.kernel.install.artifact.ArtifactStorage;
import org.eclipse.virgo.kernel.install.artifact.InstallArtifact;
import org.eclipse.virgo.kernel.install.artifact.ScopeServiceRepository;
import org.eclipse.virgo.kernel.install.artifact.internal.AbstractArtifactGraphFactory;
import org.eclipse.virgo.kernel.install.artifact.internal.ArtifactStorageFactory;
import org.eclipse.virgo.kernel.install.artifact.internal.ConfigInstallArtifactGraphFactory;
import org.eclipse.virgo.kernel.install.artifact.internal.InstallArtifactRefreshHandler;
import org.eclipse.virgo.kernel.install.artifact.internal.ParPlanInstallArtifact;
import org.eclipse.virgo.kernel.install.artifact.internal.ParPlanInstallArtifactFactory;
import org.eclipse.virgo.kernel.install.artifact.internal.StandardArtifactStateMonitor;
import org.eclipse.virgo.kernel.install.artifact.internal.StandardPlanInstallArtifact;
import org.eclipse.virgo.kernel.install.artifact.internal.bundle.BundleInstallArtifactGraphFactory;
import org.eclipse.virgo.kernel.serviceability.NonNull;
import org.eclipse.virgo.kernel.serviceability.dump.DumpCoordinator;
import org.eclipse.virgo.kernel.serviceability.enforcement.NonNullAssertionEnforcer;
import org.eclipse.virgo.kernel.shim.scope.ScopeFactory;
import org.eclipse.virgo.medic.eventlog.EventLogger;
import org.eclipse.virgo.medic.log.EntryExitTrace;
import org.eclipse.virgo.util.common.DirectedAcyclicGraph;
import org.eclipse.virgo.util.common.GraphNode;
import org.eclipse.virgo.util.io.IOUtils;
import org.osgi.framework.BundleContext;

final class PlanInstallArtifactGraphFactory
extends AbstractArtifactGraphFactory {
    private static final String PROVISIONING_PROPERTY_NAME = "org.eclipse.virgo.kernel.provisioning";
    private final BundleContext bundleContext;
    private final ScopeServiceRepository scopeServiceRepository;
    private final ScopeFactory scopeFactory;
    private final EventLogger eventLogger;
    private final InstallArtifactRefreshHandler refreshHandler;
    private final ParPlanInstallArtifactFactory parFactory;
    private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;

    public PlanInstallArtifactGraphFactory(@NonNull BundleContext bundleContext, @NonNull ScopeServiceRepository scopeServiceRepository, @NonNull ScopeFactory scopeFactory, @NonNull EventLogger eventLogger, @NonNull BundleInstallArtifactGraphFactory bundleInstallArtifactGraphFactory, @NonNull InstallArtifactRefreshHandler refreshHandler, @NonNull ConfigInstallArtifactGraphFactory configInstallArtifactGraphFactory, @NonNull ArtifactStorageFactory artifactStorageFactory, @NonNull ArtifactIdentityDeterminer artifactIdentityDeterminer, @NonNull DirectedAcyclicGraph<InstallArtifact> dag) {
        InstallArtifactRefreshHandler installArtifactRefreshHandler = refreshHandler;
        BundleInstallArtifactGraphFactory bundleInstallArtifactGraphFactory2 = bundleInstallArtifactGraphFactory;
        EventLogger eventLogger2 = eventLogger;
        ScopeFactory scopeFactory2 = scopeFactory;
        ScopeServiceRepository scopeServiceRepository2 = scopeServiceRepository;
        BundleContext bundleContext2 = bundleContext;
        NonNullAssertionEnforcer.aspectOf().ajc$before$org_eclipse_virgo_kernel_serviceability_enforcement_NonNullAssertionEnforcer$1$7118cd8((Object)bundleContext2);
        NonNullAssertionEnforcer.aspectOf().ajc$before$org_eclipse_virgo_kernel_serviceability_enforcement_NonNullAssertionEnforcer$2$ea5bfc82((Object)scopeServiceRepository2);
        NonNullAssertionEnforcer.aspectOf().ajc$before$org_eclipse_virgo_kernel_serviceability_enforcement_NonNullAssertionEnforcer$3$438bd8c1((Object)scopeFactory2);
        NonNullAssertionEnforcer.aspectOf().ajc$before$org_eclipse_virgo_kernel_serviceability_enforcement_NonNullAssertionEnforcer$4$c122b91c((Object)eventLogger2);
        NonNullAssertionEnforcer.aspectOf().ajc$before$org_eclipse_virgo_kernel_serviceability_enforcement_NonNullAssertionEnforcer$5$e9cfb671((Object)bundleInstallArtifactGraphFactory2);
        NonNullAssertionEnforcer.aspectOf().ajc$before$org_eclipse_virgo_kernel_serviceability_enforcement_NonNullAssertionEnforcer$6$2b4b16f2((Object)installArtifactRefreshHandler);
        super(dag);
        try {
            this.bundleContext = bundleContext;
            this.scopeServiceRepository = scopeServiceRepository;
            this.scopeFactory = scopeFactory;
            this.eventLogger = eventLogger;
            this.refreshHandler = refreshHandler;
            this.parFactory = new ParPlanInstallArtifactFactory(eventLogger, bundleContext, bundleInstallArtifactGraphFactory, scopeServiceRepository, scopeFactory, refreshHandler, configInstallArtifactGraphFactory, artifactStorageFactory, artifactIdentityDeterminer, this);
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    @Override
    public GraphNode<InstallArtifact> constructInstallArtifactGraph(ArtifactIdentity identity, ArtifactStorage artifactStorage, Map<String, String> deploymentProperties, String repositoryName) throws DeploymentException {
        try {
            try {
                PlanInstallArtifactGraphFactory.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_0);
                String type = identity.getType();
                GraphNode<InstallArtifact> graphNode = "plan".equalsIgnoreCase(type) ? this.createPlanGraph(identity, artifactStorage, this.getPlanDescriptor(artifactStorage), repositoryName, deploymentProperties) : ("par".equalsIgnoreCase(type) ? this.createParGraph(identity, artifactStorage, repositoryName) : null);
                PlanInstallArtifactGraphFactory.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_0);
                return graphNode;
            }
            catch (Throwable throwable) {
                PlanInstallArtifactGraphFactory.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_0);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private GraphNode<InstallArtifact> createParGraph(ArtifactIdentity artifactIdentity, ArtifactStorage artifactStorage, String repositoryName) throws DeploymentException {
        try {
            try {
                PlanInstallArtifactGraphFactory.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_1);
                ParPlanInstallArtifact parArtifact = this.parFactory.createParPlanInstallArtifact(artifactIdentity, artifactStorage, repositoryName);
                GraphNode<InstallArtifact> graphNode = this.constructAssociatedGraphNode(parArtifact);
                PlanInstallArtifactGraphFactory.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_1);
                return graphNode;
            }
            catch (Throwable throwable) {
                PlanInstallArtifactGraphFactory.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_1);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private PlanDescriptor getPlanDescriptor(ArtifactStorage artifactStorage) throws DeploymentException {
        try {
            PlanDescriptor planDescriptor;
            InputStream in = null;
            try {
                PlanDescriptor planDescriptor2;
                in = artifactStorage.getArtifactFS().getEntry("").getInputStream();
                planDescriptor = planDescriptor2 = new PlanReader().read(in);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                throw throwable;
            }
            IOUtils.closeQuietly((Closeable)in);
            return planDescriptor;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private GraphNode<InstallArtifact> createPlanGraph(ArtifactIdentity artifactIdentity, ArtifactStorage artifactStorage, PlanDescriptor planDescriptor, String repositoryName, Map<String, String> deploymentProperties) throws DeploymentException {
        try {
            try {
                PlanInstallArtifactGraphFactory.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_2);
                PlanDescriptor.Provisioning resultantProvisioning = this.determinePlanProvisioning(planDescriptor, this.getParentProvisioning(deploymentProperties));
                StandardPlanInstallArtifact planInstallArtifact = new StandardPlanInstallArtifact(artifactIdentity, planDescriptor.getAtomic(), planDescriptor.getScoped(), resultantProvisioning, artifactStorage, new StandardArtifactStateMonitor(this.bundleContext), this.scopeServiceRepository, this.scopeFactory, this.eventLogger, this.refreshHandler, repositoryName, planDescriptor.getArtifactSpecifications());
                GraphNode<InstallArtifact> graphNode = this.constructAssociatedGraphNode(planInstallArtifact);
                PlanInstallArtifactGraphFactory.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_2);
                return graphNode;
            }
            catch (Throwable throwable) {
                PlanInstallArtifactGraphFactory.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_2);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private PlanDescriptor.Provisioning getParentProvisioning(Map<String, String> deploymentProperties) {
        try {
            String provisioningProperty;
            PlanDescriptor.Provisioning parentProvisioning = PlanDescriptor.Provisioning.AUTO;
            if (deploymentProperties != null && (provisioningProperty = deploymentProperties.get(PROVISIONING_PROPERTY_NAME)) != null && (parentProvisioning = PlanDescriptor.Provisioning.valueOf((String)provisioningProperty.toUpperCase(Locale.ENGLISH))) == PlanDescriptor.Provisioning.INHERIT) {
                parentProvisioning = PlanDescriptor.Provisioning.AUTO;
            }
            return parentProvisioning;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private PlanDescriptor.Provisioning determinePlanProvisioning(PlanDescriptor planDescriptor, PlanDescriptor.Provisioning parentProvisioning) {
        try {
            try {
                PlanDescriptor.Provisioning resultantProvisioning;
                PlanInstallArtifactGraphFactory.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_3);
                PlanDescriptor.Provisioning planProvisioningSpec = planDescriptor.getProvisioning();
                PlanDescriptor.Provisioning provisioning = resultantProvisioning = planProvisioningSpec == PlanDescriptor.Provisioning.INHERIT ? parentProvisioning : planProvisioningSpec;
                PlanInstallArtifactGraphFactory.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_3);
                return provisioning;
            }
            catch (Throwable throwable) {
                PlanInstallArtifactGraphFactory.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_3);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    static {
        Factory factory = new Factory("PlanInstallArtifactGraphFactory.java", Class.forName("org.eclipse.virgo.kernel.install.artifact.internal.PlanInstallArtifactGraphFactory"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "constructInstallArtifactGraph", "org.eclipse.virgo.kernel.install.artifact.internal.PlanInstallArtifactGraphFactory", "org.eclipse.virgo.kernel.install.artifact.ArtifactIdentity:org.eclipse.virgo.kernel.install.artifact.ArtifactStorage:java.util.Map:java.lang.String:", "identity:artifactStorage:deploymentProperties:repositoryName:", "org.eclipse.virgo.kernel.deployer.core.DeploymentException:", "org.eclipse.virgo.util.common.GraphNode"), 88);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "createParGraph", "org.eclipse.virgo.kernel.install.artifact.internal.PlanInstallArtifactGraphFactory", "org.eclipse.virgo.kernel.install.artifact.ArtifactIdentity:org.eclipse.virgo.kernel.install.artifact.ArtifactStorage:java.lang.String:", "artifactIdentity:artifactStorage:repositoryName:", "org.eclipse.virgo.kernel.deployer.core.DeploymentException:", "org.eclipse.virgo.util.common.GraphNode"), 101);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "createPlanGraph", "org.eclipse.virgo.kernel.install.artifact.internal.PlanInstallArtifactGraphFactory", "org.eclipse.virgo.kernel.install.artifact.ArtifactIdentity:org.eclipse.virgo.kernel.install.artifact.ArtifactStorage:org.eclipse.virgo.kernel.artifact.plan.PlanDescriptor:java.lang.String:java.util.Map:", "artifactIdentity:artifactStorage:planDescriptor:repositoryName:deploymentProperties:", "org.eclipse.virgo.kernel.deployer.core.DeploymentException:", "org.eclipse.virgo.util.common.GraphNode"), 122);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "determinePlanProvisioning", "org.eclipse.virgo.kernel.install.artifact.internal.PlanInstallArtifactGraphFactory", "org.eclipse.virgo.kernel.artifact.plan.PlanDescriptor:org.eclipse.virgo.kernel.artifact.plan.PlanDescriptor$Provisioning:", "planDescriptor:parentProvisioning:", "", "org.eclipse.virgo.kernel.artifact.plan.PlanDescriptor$Provisioning"), 147);
        ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.kernel.install.artifact.internal.PlanInstallArtifactGraphFactory");
    }
}

