/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.osgi.extensions.equinox;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.osgi.framework.internal.core.FrameworkProperties;
import org.eclipse.osgi.launch.Equinox;
import org.eclipse.virgo.osgi.extensions.equinox.EquinoxLauncherConfiguration;
import org.eclipse.virgo.osgi.extensions.equinox.hooks.ExtensionsHookConfigurator;
import org.osgi.framework.BundleException;
import org.osgi.framework.launch.Framework;

public final class ExtendedEquinoxLauncher {
    private static final String PROP_CONTEXT_BOOTDELEGATION = "osgi.context.bootdelegation";
    private static final String PROP_COMPATIBILITY_BOOTDELEGATION = "osgi.compatibility.bootdelegation";
    private static final String PROP_OSGI_CLEAN = "osgi.clean";
    private static final String PROP_OSGI_PARENT_CLASSLOADER = "osgi.parentClassloader";

    public static Equinox launch(EquinoxLauncherConfiguration config) throws BundleException {
        try {
            Field f = FrameworkProperties.class.getDeclaredField("properties");
            f.setAccessible(true);
            f.set(null, null);
        }
        catch (Exception e) {
            System.out.println("Unable to reset Equinox FrameworkProperties");
            e.printStackTrace(System.out);
        }
        Map<String, String> configuration = ExtendedEquinoxLauncher.populateConfiguration(config);
        Equinox equinox = new Equinox(configuration);
        equinox.start();
        equinox.getBundleContext().registerService(Framework.class.getName(), (Object)equinox, null);
        return equinox;
    }

    private static Map<String, String> populateConfiguration(EquinoxLauncherConfiguration config) {
        HashMap<String, String> configuration = new HashMap<String, String>();
        configuration.putAll(config.getFrameworkProperties());
        ExtendedEquinoxLauncher.mergeListProperty(configuration, "osgi.hook.configurators.include", ExtensionsHookConfigurator.class.getName());
        configuration.put(PROP_OSGI_PARENT_CLASSLOADER, "fwk");
        configuration.put(PROP_CONTEXT_BOOTDELEGATION, "false");
        configuration.put(PROP_COMPATIBILITY_BOOTDELEGATION, "false");
        if (config.getProfilePath() != null) {
            configuration.put("osgi.java.profile", config.getProfilePath().toString());
        }
        configuration.put("osgi.java.profile.bootdelegation", "override");
        configuration.put("osgi.configuration.area", config.getConfigPath().toString());
        configuration.put("osgi.install.area", config.getInstallPath().toString());
        configuration.put(PROP_OSGI_CLEAN, Boolean.toString(config.isClean()));
        return configuration;
    }

    private static void mergeListProperty(Map<String, String> properties, String key, String value) {
        String existingValue = properties.get(key);
        if (existingValue != null) {
            properties.put(key, String.valueOf(existingValue) + "," + value);
        } else {
            properties.put(key, value);
        }
    }
}

