/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.shell.internal.help;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.virgo.kernel.shell.internal.help.HelpAccessor;
import org.eclipse.virgo.medic.log.EntryExitTrace;
import org.eclipse.virgo.util.io.IOUtils;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleFileHelpAccessor
implements HelpAccessor {
    private static final char HELP_FILE_COMMENT_CHARACTER = '#';
    private static final String HELP_ACCESSOR_RESOURCE_EXTENSION = ".help";
    private static final Logger logger;
    private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;

    static {
        Factory factory = new Factory("SimpleFileHelpAccessor.java", Class.forName("org.eclipse.virgo.kernel.shell.internal.help.SimpleFileHelpAccessor"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("12", "readFirstHelpLine", "org.eclipse.virgo.kernel.shell.internal.help.SimpleFileHelpAccessor", "java.io.BufferedReader:", "reader:", "java.io.IOException:", "java.lang.String"), 89);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("12", "readAllButFirstHelpLines", "org.eclipse.virgo.kernel.shell.internal.help.SimpleFileHelpAccessor", "java.io.BufferedReader:", "reader:", "java.io.IOException:", "java.util.List"), 100);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1a", "contentLine", "org.eclipse.virgo.kernel.shell.internal.help.SimpleFileHelpAccessor", "java.lang.String:", "line:", "", "boolean"), 119);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("12", "helpResourceReader", "org.eclipse.virgo.kernel.shell.internal.help.SimpleFileHelpAccessor", "java.lang.Class:", "clazz:", "", "java.io.BufferedReader"), 125);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "helpResourceUrl", "org.eclipse.virgo.kernel.shell.internal.help.SimpleFileHelpAccessor", "java.lang.Class:java.lang.String:", "clazz:fileResourceName:", "", "java.net.URL"), 146);
        ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.kernel.shell.internal.help.SimpleFileHelpAccessor");
        logger = LoggerFactory.getLogger(SimpleFileHelpAccessor.class);
    }

    @Override
    public List<String> getDetailedHelp(Class<?> clazz) {
        BufferedReader readFileIn = null;
        try {
            readFileIn = this.helpResourceReader(clazz);
            if (readFileIn != null) {
                List<String> list = this.readAllButFirstHelpLines(readFileIn);
                return list;
            }
        }
        catch (IOException ioe) {
            logger.error(String.format("Exception reading help resource for class '%s'.", clazz.getCanonicalName()), (Throwable)ioe);
        }
        finally {
            IOUtils.closeQuietly((Closeable)readFileIn);
        }
        return Collections.emptyList();
    }

    @Override
    public String getSummaryHelp(Class<?> clazz) {
        BufferedReader readFileIn = null;
        try {
            readFileIn = this.helpResourceReader(clazz);
            if (readFileIn != null) {
                String string = this.readFirstHelpLine(readFileIn);
                return string;
            }
        }
        catch (IOException ioe) {
            logger.error(String.format("Exception reading help resource for class '%s'.", clazz.getCanonicalName()), (Throwable)ioe);
        }
        finally {
            IOUtils.closeQuietly((Closeable)readFileIn);
        }
        return null;
    }

    private final String readFirstHelpLine(BufferedReader reader) throws IOException {
        try {
            String string;
            block4: {
                SimpleFileHelpAccessor.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_0);
                String line = reader.readLine();
                while (line != null) {
                    if (SimpleFileHelpAccessor.contentLine(line)) {
                        string = line;
                        break block4;
                    }
                    line = reader.readLine();
                }
                string = line;
            }
            SimpleFileHelpAccessor.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_0);
            return string;
        }
        catch (Throwable throwable) {
            SimpleFileHelpAccessor.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_0);
            throw throwable;
        }
    }

    private final List<String> readAllButFirstHelpLines(BufferedReader reader) throws IOException {
        try {
            SimpleFileHelpAccessor.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_1);
            ArrayList<String> lines = new ArrayList<String>();
            String line = reader.readLine();
            boolean skipLine = true;
            while (line != null) {
                if (SimpleFileHelpAccessor.contentLine(line)) {
                    if (!skipLine) {
                        lines.add(line);
                    } else {
                        skipLine = false;
                    }
                }
                line = reader.readLine();
            }
            ArrayList<String> arrayList = lines;
            SimpleFileHelpAccessor.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_1);
            return arrayList;
        }
        catch (Throwable throwable) {
            SimpleFileHelpAccessor.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_1);
            throw throwable;
        }
    }

    private static final boolean contentLine(String line) {
        try {
            SimpleFileHelpAccessor.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_2);
            boolean bl = line == null ? false : line.length() == 0 || line.charAt(0) != '#';
            SimpleFileHelpAccessor.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_2);
            return bl;
        }
        catch (Throwable throwable) {
            SimpleFileHelpAccessor.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_2);
            throw throwable;
        }
    }

    private final BufferedReader helpResourceReader(Class<?> clazz) {
        try {
            BufferedReader bufferedReader;
            block5: {
                String fileResourceName;
                URL resourceUrl;
                SimpleFileHelpAccessor.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_3);
                BufferedReader readFileIn = null;
                String className = clazz.getCanonicalName();
                if (className != null && (resourceUrl = this.helpResourceUrl(clazz, fileResourceName = new StringBuffer(className).append(HELP_ACCESSOR_RESOURCE_EXTENSION).toString())) != null) {
                    InputStream resourceIn = null;
                    try {
                        resourceIn = resourceUrl.openStream();
                        readFileIn = new BufferedReader(new InputStreamReader(resourceIn));
                    }
                    catch (IOException ioe) {
                        logger.error(String.format("Exception reading help resource '%s'.", resourceUrl), (Throwable)ioe);
                        IOUtils.closeQuietly((Closeable)resourceIn);
                        bufferedReader = null;
                        break block5;
                    }
                }
                bufferedReader = readFileIn;
            }
            SimpleFileHelpAccessor.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_3);
            return bufferedReader;
        }
        catch (Throwable throwable) {
            SimpleFileHelpAccessor.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_3);
            throw throwable;
        }
    }

    protected URL helpResourceUrl(Class<?> clazz, String fileResourceName) {
        try {
            URL uRL;
            block5: {
                block4: {
                    SimpleFileHelpAccessor.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_4);
                    Bundle bundle = FrameworkUtil.getBundle(clazz);
                    try {
                        if (bundle == null) break block4;
                        uRL = bundle.getResource(fileResourceName);
                        break block5;
                    }
                    catch (IllegalStateException ise) {
                        logger.error(String.format("Exception obtaining help resource file '%s'.", fileResourceName), (Throwable)ise);
                    }
                }
                uRL = null;
            }
            SimpleFileHelpAccessor.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_4);
            return uRL;
        }
        catch (Throwable throwable) {
            SimpleFileHelpAccessor.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_4);
            throw throwable;
        }
    }
}

