/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.web.core.internal;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.gemini.web.core.spi.ContextPathExistsException;
import org.eclipse.virgo.medic.eventlog.EventLogger;
import org.eclipse.virgo.medic.eventlog.LogEvent;
import org.eclipse.virgo.web.core.internal.WebLogEvents;
import org.osgi.framework.Version;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

final class WebApplicationEventLogger
implements EventHandler {
    private static final String EMPTY_CONTEXT_PATH = "";
    private static final String ROOT_CONTEXT_PATH = "/";
    private final EventLogger eventLogger;
    private static final Map<String, WebLogEvents> MAPPINGS;

    static {
        HashMap<String, WebLogEvents> mappings = new HashMap<String, WebLogEvents>();
        mappings.put("org/osgi/service/web/DEPLOYING", WebLogEvents.STARTING_WEB_BUNDLE);
        mappings.put("org/osgi/service/web/DEPLOYED", WebLogEvents.STARTED_WEB_BUNDLE);
        mappings.put("org/osgi/service/web/UNDEPLOYING", WebLogEvents.STOPPING_WEB_BUNDLE);
        mappings.put("org/osgi/service/web/UNDEPLOYED", WebLogEvents.STOPPED_WEB_BUNDLE);
        MAPPINGS = mappings;
    }

    public WebApplicationEventLogger(EventLogger eventLogger) {
        this.eventLogger = eventLogger;
    }

    public void handleEvent(Event event) {
        String topic = event.getTopic();
        if ("org/osgi/service/web/FAILED".equals(topic)) {
            this.logFailure(event);
        } else {
            WebLogEvents logEvent = MAPPINGS.get(topic);
            if (logEvent != null) {
                this.eventLogger.log((LogEvent)logEvent, new Object[]{this.bundleName(event), this.bundleVersion(event), this.contextPathFor(event)});
            }
        }
    }

    private void logFailure(Event event) {
        Exception ex = (Exception)event.getProperty("exception");
        if (ex instanceof ContextPathExistsException) {
            this.eventLogger.log((LogEvent)WebLogEvents.WEB_BUNDLE_FAILED_CONTEXT_PATH_USED, new Object[]{this.bundleName(event), this.bundleVersion(event), this.contextPathFor(event)});
        } else {
            this.eventLogger.log((LogEvent)WebLogEvents.WEB_BUNDLE_FAILED, new Object[]{this.bundleName(event), this.bundleVersion(event)});
        }
    }

    private String contextPathFor(Event event) {
        String contextPath = (String)event.getProperty("context.path");
        if (EMPTY_CONTEXT_PATH.equals(contextPath)) {
            return ROOT_CONTEXT_PATH;
        }
        return contextPath;
    }

    private String bundleName(Event event) {
        return (String)event.getProperty("bundle.symbolicName");
    }

    private Version bundleVersion(Event event) {
        return (Version)event.getProperty("bundle.version");
    }
}

