/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.am;

import java.math.BigDecimal;
import java.sql.SQLException;
import org.apache.derby.client.am.ResultSet;
import org.apache.derby.client.am.SqlException;
import org.apache.derby.client.am.SqlWarning;
import org.apache.derby.client.am.Sqlca;
import org.apache.derby.client.am.Statement;

public final class Utils {
    private static byte[][] tenRadixArr = new byte[][]{{1}, {10}, {100}, {3, -24}, {39, 16}, {1, -122, -96}, {15, 66, 64}, {-104, -106, -128}, {5, -11, -31, 0}, {59, -102, -54, 0}, {2, 84, 11, -28, 0}, {23, 72, 118, -24, 0}, {-24, -44, -91, 16, 0}, {9, 24, 78, 114, -96, 0}, {90, -13, 16, 122, 64, 0}, {3, -115, 126, -92, -58, -128, 0}, {35, -122, -14, 111, -63, 0, 0}, {1, 99, 69, 120, 93, -118, 0, 0}, {13, -32, -74, -77, -89, 100, 0, 0}, {-118, -57, 35, 4, -119, -24, 0, 0}, {5, 107, -57, 94, 45, 99, 16, 0, 0}, {54, 53, -55, -83, -59, -34, -96, 0, 0}, {2, 30, 25, -32, -55, -70, -78, 64, 0, 0}, {21, 45, 2, -57, -31, 74, -10, -128, 0, 0}, {-45, -62, 27, -50, -52, -19, -95, 0, 0, 0}, {8, 69, -107, 22, 20, 1, 72, 74, 0, 0, 0}, {82, -73, -46, -36, -56, 12, -46, -28, 0, 0, 0}, {3, 59, 46, 60, -97, -48, -128, 60, -24, 0, 0, 0}, {32, 79, -50, 94, 62, 37, 2, 97, 16, 0, 0, 0}, {1, 67, 30, 15, -82, 109, 114, 23, -54, -96, 0, 0, 0}, {12, -97, 44, -100, -48, 70, 116, -19, -22, 64, 0, 0, 0}, {126, 55, -66, 32, 34, -64, -111, 75, 38, -128, 0, 0, 0}};

    static String quoteSqlIdentifier(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length() + 2);
        stringBuffer.append('\"');
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\"') {
                stringBuffer.append('\"');
            }
            stringBuffer.append(c);
        }
        stringBuffer.append('\"');
        return stringBuffer.toString();
    }

    static String getStringFromBytes(byte[] byArray) {
        if (byArray == null) {
            return "{}";
        }
        StringBuffer stringBuffer = new StringBuffer(byArray.length * 6 + 4);
        stringBuffer.append("{ ");
        for (int i = 0; i < byArray.length; ++i) {
            stringBuffer.append("0x");
            stringBuffer.append(Integer.toHexString(byArray[i] & 0xFF));
            if (i == byArray.length - 1) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append(" }");
        return stringBuffer.toString();
    }

    static String getStringFromInts(int[] nArray) {
        if (nArray == null) {
            return "{}";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{ ");
        for (int i = 0; i < nArray.length; ++i) {
            stringBuffer.append(String.valueOf(nArray[i]));
            if (i == nArray.length - 1) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append(" }");
        return stringBuffer.toString();
    }

    static String getStringFromStrings(String[] stringArray) {
        if (stringArray == null) {
            return "{}";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{ ");
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append(stringArray[i]);
            if (i == stringArray.length - 1) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append(" }");
        return stringBuffer.toString();
    }

    public static int computeBigDecimalPrecision(BigDecimal bigDecimal) {
        byte[] byArray = bigDecimal.unscaledValue().abs().toByteArray();
        if (Utils.byteArrayCmp(byArray, tenRadixArr[tenRadixArr.length - 1]) >= 0) {
            throw new IllegalArgumentException(SqlException.getMessageUtil().getTextMessage("J105"));
        }
        int n = 0;
        int n2 = tenRadixArr.length - 1;
        int n3 = (n2 + n) / 2;
        do {
            int n4;
            if ((n4 = Utils.byteArrayCmp(byArray, tenRadixArr[n3])) == 1) {
                n = n3;
                continue;
            }
            if (n4 != -1) break;
            n2 = n3;
        } while ((n3 = (n2 + n) / 2) != n);
        return n3 + 1;
    }

    private static int byteArrayCmp(byte[] byArray, byte[] byArray2) {
        int n;
        int n2;
        int n3;
        int n4;
        if (byArray.length > byArray2.length) {
            n4 = byArray.length - byArray2.length;
            for (n3 = 0; n3 < n4; ++n3) {
                if (byArray[n3] == 0) continue;
                return 1;
            }
            n2 = byArray2.length;
        } else if (byArray.length < byArray2.length) {
            n4 = byArray2.length - byArray.length;
            for (n = 0; n < n4; ++n) {
                if (byArray2[n] == 0) continue;
                return -1;
            }
            n2 = byArray.length;
        } else {
            n2 = byArray.length;
        }
        for (n4 = 0; n4 < n2; ++n4) {
            int n5 = byArray[n3 + n4] & 0xFF;
            int n6 = byArray2[n + n4] & 0xFF;
            if (n5 > n6) {
                return 1;
            }
            if (n5 >= n6) continue;
            return -1;
        }
        return 0;
    }

    public static String padOrTruncate(String string, int n) {
        if (string.length() >= n) {
            return string.substring(0, n);
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        for (int i = 0; i < n - string.length(); ++i) {
            stringBuffer.append(" ");
        }
        return stringBuffer.toString();
    }

    public static void checkForNegativePositiveSqlcard(Sqlca sqlca, Statement statement) throws SqlException {
        if (sqlca != null) {
            int n = sqlca.getSqlCode();
            if (n < 0) {
                throw new SqlException(statement.agent_.logWriter_, sqlca);
            }
            if (n > 0) {
                statement.accumulateWarning(new SqlWarning(statement.agent_.logWriter_, sqlca));
            }
        }
    }

    public static void checkForNegativePositiveSqlcard(Sqlca sqlca, ResultSet resultSet) throws SqlException {
        if (sqlca != null) {
            int n = sqlca.getSqlCode();
            if (n < 0) {
                throw new SqlException(resultSet.agent_.logWriter_, sqlca);
            }
            if (n > 0) {
                resultSet.accumulateWarning(new SqlWarning(resultSet.agent_.logWriter_, sqlca));
            }
        }
    }

    public static int getSqlcodeFromSqlca(Sqlca sqlca) {
        if (sqlca == null) {
            return 0;
        }
        return sqlca.getSqlCode();
    }

    public static int getUpdateCountFromSqlcard(Sqlca sqlca) {
        if (sqlca == null) {
            return 0;
        }
        return sqlca.getUpdateCount();
    }

    public static SQLException accumulateSQLException(SQLException sQLException, SQLException sQLException2) {
        if (sQLException2 == null) {
            return sQLException;
        }
        sQLException2.setNextException(sQLException);
        return sQLException2;
    }

    public static SqlException accumulateSQLException(SqlException sqlException, SqlException sqlException2) {
        if (sqlException2 == null) {
            return sqlException;
        }
        sqlException2.setNextException(sqlException);
        return sqlException2;
    }

    public static SqlWarning accumulateSQLWarning(SqlWarning sqlWarning, SqlWarning sqlWarning2) {
        sqlWarning.setNextException(sqlWarning2);
        return sqlWarning;
    }

    static String getSQLTypeName(int n) {
        switch (n) {
            case -5: {
                return "BIGINT";
            }
            case -2: {
                return "BINARY";
            }
            case -7: {
                return "BIT";
            }
            case 1: {
                return "CHAR";
            }
            case 91: {
                return "DATE";
            }
            case 3: {
                return "DECIMAL";
            }
            case 8: {
                return "DOUBLE";
            }
            case 7: {
                return "REAL";
            }
            case 4: {
                return "INTEGER";
            }
            case -4: {
                return "LONGVARBINARY";
            }
            case -1: {
                return "LONGVARCHAR";
            }
            case 0: {
                return "NULL";
            }
            case 2: {
                return "NUMERIC";
            }
            case 1111: {
                return "OTHER";
            }
            case 6: {
                return "FLOAT";
            }
            case 5: {
                return "SMALLINT";
            }
            case 92: {
                return "TIME";
            }
            case 93: {
                return "TIMESTAMP";
            }
            case -6: {
                return "TINYINT";
            }
            case -3: {
                return "VARBINARY";
            }
            case 12: {
                return "VARCHAR";
            }
        }
        return null;
    }

    public static boolean isSqlTypeNullable(int n) {
        return (n | 1) == n;
    }

    public static int getNonNullableSqlType(int n) {
        return n & 0xFFFFFFFE;
    }
}

