/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.am;

import java.io.IOException;
import java.io.OutputStream;
import java.io.StringBufferInputStream;
import java.io.StringReader;
import org.apache.derby.client.am.Clob;
import org.apache.derby.client.am.SqlException;

public class ClobOutputStream
extends OutputStream {
    private Clob clob_;
    private long offset_;

    public ClobOutputStream(Clob clob, long l) throws SqlException {
        this.clob_ = clob;
        this.offset_ = l;
        if (this.offset_ - 1L > this.clob_.sqlLength()) {
            throw new IndexOutOfBoundsException();
        }
    }

    public void write(int n) throws IOException {
        byte[] byArray = new byte[]{(byte)n};
        this.writeBytes(byArray);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n > byArray.length || n2 < 0 || n + n2 > byArray.length || n + n2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return;
        }
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        this.writeBytes(byArray2);
    }

    private void writeBytes(byte[] byArray) throws IOException {
        String string = new String(byArray, "ISO-8859-1");
        this.clob_.string_ = this.clob_.string_.substring(0, (int)this.offset_ - 1);
        this.clob_.string_ = this.clob_.string_.concat(string);
        this.clob_.asciiStream_ = new StringBufferInputStream(this.clob_.string_);
        this.clob_.unicodeStream_ = new StringBufferInputStream(this.clob_.string_);
        this.clob_.characterStream_ = new StringReader(this.clob_.string_);
        this.clob_.setSqlLength(this.clob_.string_.length());
        this.offset_ += (long)byArray.length;
    }
}

