/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.model.management.internal;

import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.eclipse.equinox.region.Region;
import org.eclipse.virgo.kernel.model.Artifact;
import org.eclipse.virgo.kernel.model.management.RuntimeArtifactModelObjectNameCreator;
import org.eclipse.virgo.nano.serviceability.NonNull;
import org.eclipse.virgo.nano.serviceability.dump.DumpCoordinator;
import org.eclipse.virgo.nano.serviceability.enforcement.NonNullAssertionEnforcer;
import org.osgi.framework.Version;

public final class DefaultRuntimeArtifactModelObjectNameCreator
implements RuntimeArtifactModelObjectNameCreator {
    private static final String ALL_ARTIFACTS_FORMAT = "%s:type=ArtifactModel,*";
    private static final String ARTIFACTS_OF_TYPE_FORMAT = "%s:type=ArtifactModel,artifact-type=%s,*";
    private static final String ARTIFACTS_OF_TYPE_AND_NAME_FORMAT = "%s:type=ArtifactModel,artifact-type=%s,name=%s,*";
    private static final String ARTIFACT_FORMAT = "%s:type=ArtifactModel,artifact-type=%s,name=%s,version=%s,region=%s";
    private static final String KEY_NAME = "name";
    private static final String KEY_VERSION = "version";
    private static final String KEY_REGION = "region";
    private static final String NULL_REGION_NAME = "global";
    private final String domain;

    public DefaultRuntimeArtifactModelObjectNameCreator(String domain) {
        try {
            try {
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            this.domain = domain;
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    @Override
    public ObjectName createArtifactModel(@NonNull Artifact artifact) {
        Artifact artifact2 = artifact;
        try {
            NonNullAssertionEnforcer.aspectOf().ajc$before$org_eclipse_virgo_nano_serviceability_enforcement_NonNullAssertionEnforcer$1$7118cd8((Object)artifact2);
            return this.createArtifactModel(artifact.getType(), artifact.getName(), artifact.getVersion(), artifact.getRegion());
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    @Override
    public ObjectName createArtifactModel(String type, String name, Version version, Region region) {
        try {
            return this.createObjectName(String.format(ARTIFACT_FORMAT, this.domain, this.quoteValueIfNeeded(type), this.quoteValueIfNeeded(name), this.quoteValueIfNeeded(version.toString()), this.quoteValueIfNeeded(this.getRegionName(region))));
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private String getRegionName(Region region) {
        try {
            return region == null ? NULL_REGION_NAME : region.getName();
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    @Override
    public ObjectName createArtifactsOfTypeQuery(String type) {
        try {
            return this.createObjectName(String.format(ARTIFACTS_OF_TYPE_FORMAT, this.domain, this.quoteValueIfNeeded(type)));
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    @Override
    public ObjectName createArtifactVersionsQuery(String type, String name) {
        try {
            return this.createObjectName(String.format(ARTIFACTS_OF_TYPE_AND_NAME_FORMAT, this.domain, this.quoteValueIfNeeded(type), this.quoteValueIfNeeded(name)));
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    @Override
    public ObjectName createAllArtifactsQuery() {
        try {
            return this.createObjectName(String.format(ALL_ARTIFACTS_FORMAT, this.domain));
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    @Override
    public String getRegion(ObjectName objectName) {
        try {
            return objectName.getKeyProperty(KEY_REGION);
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    @Override
    public String getName(ObjectName objectName) {
        try {
            return objectName.getKeyProperty(KEY_NAME);
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    @Override
    public String getVersion(ObjectName objectName) {
        try {
            return objectName.getKeyProperty(KEY_VERSION);
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private String quoteValueIfNeeded(String value) {
        try {
            if (value.contains(":") || value.contains(",") || value.contains("=") || value.contains("\"")) {
                value = String.format("%s%s%s", "\"", value.replace("\"", "\\\""), "\"");
            }
            return value;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private ObjectName createObjectName(String objectName) {
        try {
            try {
                return new ObjectName(objectName);
            }
            catch (MalformedObjectNameException e) {
                throw new RuntimeException(String.format("Unable to create object name '%s'", objectName), e);
            }
            catch (NullPointerException e) {
                throw new RuntimeException(String.format("Unable to create object name '%s'", objectName), e);
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }
}

